/*
 * Decompiled with CFR 0.152.
 */
package de.rototor.pdfbox.graphics2d;

import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DColorMapper;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2DColorMapper;
import java.awt.Color;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;

public class RGBtoCMYKColorMapper
extends PdfBoxGraphics2DColorMapper {
    private final ICC_ColorSpace icc_colorspace;
    private final PDICCBased pdProfile;

    public RGBtoCMYKColorMapper(ICC_Profile icc_profile, PDDocument document) throws IOException {
        this.icc_colorspace = new ICC_ColorSpace(icc_profile);
        this.pdProfile = new PDICCBased(document);
        OutputStream outputStream = this.pdProfile.getPDStream().createOutputStream(COSName.FLATE_DECODE);
        outputStream.write(icc_profile.getData());
        outputStream.close();
        this.pdProfile.getPDStream().getCOSObject().setInt(COSName.N, 4);
        this.pdProfile.getPDStream().getCOSObject().setItem(COSName.ALTERNATE, (COSBase)COSName.DEVICECMYK);
    }

    @Override
    public PDColor mapColor(Color rgbColor, IPdfBoxGraphics2DColorMapper.IColorMapperEnv env) {
        int r = rgbColor.getRed();
        int g = rgbColor.getGreen();
        int b2 = rgbColor.getBlue();
        int[] rgbInts = new int[]{r, g, b2};
        float[] rgbFoats = RGBtoCMYKColorMapper.rgbIntToFloat(rgbInts);
        float[] cmykFloats = this.icc_colorspace.fromRGB(rgbFoats);
        return new PDColor(cmykFloats, (PDColorSpace)this.pdProfile);
    }

    private static float[] rgbIntToFloat(int[] rgbInts) {
        float red = (float)rgbInts[0] / 255.0f;
        float green = (float)rgbInts[1] / 255.0f;
        float blue = (float)rgbInts[2] / 255.0f;
        return new float[]{red, green, blue};
    }
}

