/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import java.io.Serializable;
import java.util.Formatter;
import java.util.Iterator;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;

public abstract class AbstractVector
implements Vector,
Serializable {
    protected int size;

    protected AbstractVector(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Vector size cannot be negative");
        }
        this.size = size;
    }

    protected AbstractVector(Vector x) {
        this.size = x.size();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void set(int index, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, double value) {
        this.set(index, value + this.get(index));
    }

    @Override
    public double get(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Vector copy() {
        throw new UnsupportedOperationException();
    }

    protected void check(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index is negative (" + index + ")");
        }
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index >= size (" + index + " >= " + this.size + ")");
        }
    }

    @Override
    public Vector zero() {
        for (VectorEntry e2 : this) {
            e2.set(0.0);
        }
        return this;
    }

    @Override
    public Vector scale(double alpha) {
        if (alpha == 0.0) {
            return this.zero();
        }
        if (alpha == 1.0) {
            return this;
        }
        for (VectorEntry e2 : this) {
            e2.set(alpha * e2.get());
        }
        return this;
    }

    @Override
    public Vector set(Vector y) {
        return this.set(1.0, y);
    }

    @Override
    public Vector set(double alpha, Vector y) {
        this.checkSize(y);
        if (alpha == 0.0) {
            return this.zero();
        }
        this.zero();
        for (VectorEntry e2 : y) {
            this.set(e2.index(), alpha * e2.get());
        }
        return this;
    }

    @Override
    public Vector add(Vector y) {
        return this.add(1.0, y);
    }

    @Override
    public Vector add(double alpha, Vector y) {
        this.checkSize(y);
        if (alpha == 0.0) {
            return this;
        }
        for (VectorEntry e2 : y) {
            this.add(e2.index(), alpha * e2.get());
        }
        return this;
    }

    @Override
    public double dot(Vector y) {
        this.checkSize(y);
        double ret = 0.0;
        for (VectorEntry e2 : this) {
            ret += e2.get() * y.get(e2.index());
        }
        return ret;
    }

    protected void checkSize(Vector y) {
        if (this.size != y.size()) {
            throw new IndexOutOfBoundsException("x.size != y.size (" + this.size + " != " + y.size() + ")");
        }
    }

    @Override
    public double norm(Vector.Norm type) {
        if (type == Vector.Norm.One) {
            return this.norm1();
        }
        if (type == Vector.Norm.Two) {
            return this.norm2();
        }
        if (type == Vector.Norm.TwoRobust) {
            return this.norm2_robust();
        }
        return this.normInf();
    }

    protected double norm1() {
        double sum = 0.0;
        for (VectorEntry e2 : this) {
            sum += Math.abs(e2.get());
        }
        return sum;
    }

    protected double norm2() {
        double norm = 0.0;
        for (VectorEntry e2 : this) {
            norm += e2.get() * e2.get();
        }
        return Math.sqrt(norm);
    }

    protected double norm2_robust() {
        double scale = 0.0;
        double ssq = 1.0;
        for (VectorEntry e2 : this) {
            double xval = e2.get();
            if (xval == 0.0) continue;
            double absxi = Math.abs(xval);
            if (scale < absxi) {
                ssq = 1.0 + ssq * Math.pow(scale / absxi, 2.0);
                scale = absxi;
                continue;
            }
            ssq += Math.pow(absxi / scale, 2.0);
        }
        return scale * Math.sqrt(ssq);
    }

    protected double normInf() {
        double max = 0.0;
        for (VectorEntry e2 : this) {
            max = Math.max(Math.abs(e2.get()), max);
        }
        return max;
    }

    @Override
    public Iterator<VectorEntry> iterator() {
        return new RefVectorIterator();
    }

    public String toString() {
        Formatter out = new Formatter();
        out.format("%10d %19d\n", this.size, Matrices.cardinality(this));
        int i = 0;
        for (VectorEntry e2 : this) {
            if (e2.get() != 0.0) {
                out.format("%10d % .12e\n", e2.index() + 1, e2.get());
            }
            if (++i != 100) continue;
            out.format("...\n", new Object[0]);
            break;
        }
        return out.toString();
    }

    private class RefVectorEntry
    implements VectorEntry {
        private int index;

        private RefVectorEntry() {
        }

        public void update(int index) {
            this.index = index;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public double get() {
            return AbstractVector.this.get(this.index);
        }

        @Override
        public void set(double value) {
            AbstractVector.this.set(this.index, value);
        }
    }

    private class RefVectorIterator
    implements Iterator<VectorEntry> {
        private int index;
        private final RefVectorEntry entry;

        private RefVectorIterator() {
            this.entry = new RefVectorEntry();
        }

        @Override
        public boolean hasNext() {
            return this.index < AbstractVector.this.size;
        }

        @Override
        public VectorEntry next() {
            this.entry.update(this.index);
            ++this.index;
            return this.entry;
        }

        @Override
        public void remove() {
            this.entry.set(0.0);
        }
    }
}

