/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.Diag;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.UpperTriangBandMatrix;

public class UnitUpperTriangBandMatrix
extends UpperTriangBandMatrix {
    public UnitUpperTriangBandMatrix(int n, int kd) {
        super(n, kd, Diag.Unit);
    }

    public UnitUpperTriangBandMatrix(Matrix A, int kd) {
        this(A, kd, true);
    }

    public UnitUpperTriangBandMatrix(Matrix A, int kd, boolean deep) {
        super(A, kd, deep, Diag.Unit);
    }

    @Override
    public void add(int row, int column, double value) {
        if (row == column) {
            throw new IllegalArgumentException("row == column");
        }
        super.add(row, column, value);
    }

    @Override
    public double get(int row, int column) {
        if (row == column) {
            return 1.0;
        }
        return super.get(row, column);
    }

    @Override
    public void set(int row, int column, double value) {
        if (row == column) {
            throw new IllegalArgumentException("row == column");
        }
        super.set(row, column, value);
    }

    @Override
    public UnitUpperTriangBandMatrix copy() {
        return new UnitUpperTriangBandMatrix(this, this.ku);
    }

    @Override
    public Matrix zero() {
        throw new UnsupportedOperationException();
    }

    @Override
    void copy(Matrix A) {
        for (MatrixEntry e2 : A) {
            if (!this.inBand(e2.row(), e2.column()) || e2.row() == e2.column()) continue;
            this.set(e2.row(), e2.column(), e2.get());
        }
    }
}

