/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.AbstractIterativeSolver;
import no.uib.cipr.matrix.sparse.IterativeSolverNotConvergedException;

public class BiCG
extends AbstractIterativeSolver {
    private Vector z;
    private Vector p;
    private Vector q;
    private Vector r;
    private Vector ztilde;
    private Vector ptilde;
    private Vector qtilde;
    private Vector rtilde;

    public BiCG(Vector template) {
        this.z = template.copy();
        this.p = template.copy();
        this.q = template.copy();
        this.r = template.copy();
        this.ztilde = template.copy();
        this.ptilde = template.copy();
        this.qtilde = template.copy();
        this.rtilde = template.copy();
    }

    @Override
    public Vector solve(Matrix A, Vector b2, Vector x) throws IterativeSolverNotConvergedException {
        this.checkSizes(A, b2, x);
        double rho_1 = 1.0;
        double rho_2 = 1.0;
        double alpha = 1.0;
        double beta = 1.0;
        A.multAdd(-1.0, x, this.r.set(b2));
        this.rtilde.set(this.r);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, x)) {
            this.M.apply(this.r, this.z);
            this.M.transApply(this.rtilde, this.ztilde);
            rho_1 = this.z.dot(this.rtilde);
            if (rho_1 == 0.0) {
                throw new IterativeSolverNotConvergedException(NotConvergedException.Reason.Breakdown, "rho", this.iter);
            }
            if (this.iter.isFirst()) {
                this.p.set(this.z);
                this.ptilde.set(this.ztilde);
            } else {
                beta = rho_1 / rho_2;
                this.p.scale(beta).add(this.z);
                this.ptilde.scale(beta).add(this.ztilde);
            }
            A.mult(this.p, this.q);
            A.transMult(this.ptilde, this.qtilde);
            alpha = rho_1 / this.ptilde.dot(this.q);
            x.add(alpha, this.p);
            this.r.add(-alpha, this.q);
            this.rtilde.add(-alpha, this.qtilde);
            rho_2 = rho_1;
            this.iter.next();
        }
        return x;
    }
}

