/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.AbstractIterativeSolver;
import no.uib.cipr.matrix.sparse.IterativeSolverNotConvergedException;

public class Chebyshev
extends AbstractIterativeSolver {
    private double eigmin;
    private double eigmax;
    private Vector p;
    private Vector z;
    private Vector r;
    private Vector q;

    public Chebyshev(Vector template, double eigmin, double eigmax) {
        this.p = template.copy();
        this.z = template.copy();
        this.r = template.copy();
        this.q = template.copy();
        this.setEigenvalues(eigmin, eigmax);
    }

    public void setEigenvalues(double eigmin, double eigmax) {
        this.eigmin = eigmin;
        this.eigmax = eigmax;
        if (eigmin <= 0.0) {
            throw new IllegalArgumentException("eigmin <= 0");
        }
        if (eigmax <= 0.0) {
            throw new IllegalArgumentException("eigmax <= 0");
        }
        if (eigmin > eigmax) {
            throw new IllegalArgumentException("eigmin > eigmax");
        }
    }

    @Override
    public Vector solve(Matrix A, Vector b2, Vector x) throws IterativeSolverNotConvergedException {
        this.checkSizes(A, b2, x);
        double alpha = 0.0;
        double beta = 0.0;
        double c2 = 0.0;
        double d2 = 0.0;
        A.multAdd(-1.0, x, this.r.set(b2));
        c2 = (this.eigmax - this.eigmin) / 2.0;
        d2 = (this.eigmax + this.eigmin) / 2.0;
        this.iter.setFirst();
        while (!this.iter.converged(this.r, x)) {
            this.M.apply(this.r, this.z);
            if (this.iter.isFirst()) {
                this.p.set(this.z);
                alpha = 2.0 / d2;
            } else {
                beta = alpha * c2 / 2.0;
                beta *= beta;
                alpha = 1.0 / (d2 - beta);
                this.p.scale(beta).add(this.z);
            }
            A.mult(this.p, this.q);
            x.add(alpha, this.p);
            this.r.add(-alpha, this.q);
            this.iter.next();
        }
        return x;
    }
}

