/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.View;
import org.bounce.QButton;
import org.bounce.plaf.BounceButtonListener;
import org.bounce.plaf.BounceGraphicsUtils;

public class BounceButtonUI
extends BasicButtonUI {
    private static final BounceButtonUI ui = new BounceButtonUI();

    public static ComponentUI createUI(JComponent c2) {
        return ui;
    }

    public void paint(Graphics g, JComponent c2) {
        QButton b2 = (QButton)c2;
        ButtonModel model = b2.getModel();
        Color foreground = b2.getForeground();
        Color tmpForeground = null;
        Color background = b2.getBackground();
        Color tmpBackground = null;
        Font font = b2.getFont();
        Font tmpFont = null;
        Icon icon = b2.getIcon();
        Icon tmpIcon = null;
        FontMetrics fm = g.getFontMetrics();
        Insets i = c2.getInsets();
        Rectangle viewRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = b2.getWidth() - (i.right + viewRect.x);
        viewRect.height = b2.getHeight() - (i.bottom + viewRect.y);
        textRect.height = 0;
        textRect.width = 0;
        textRect.y = 0;
        textRect.x = 0;
        iconRect.height = 0;
        iconRect.width = 0;
        iconRect.y = 0;
        iconRect.x = 0;
        if (!model.isEnabled()) {
            if (model.isSelected()) {
                tmpForeground = b2.getDisabledSelectedForeground();
                tmpBackground = b2.getDisabledSelectedBackground();
                tmpFont = b2.getDisabledSelectedFont();
                tmpIcon = b2.getDisabledSelectedIcon();
            } else {
                tmpForeground = b2.getDisabledForeground();
                tmpBackground = b2.getDisabledBackground();
                tmpFont = b2.getDisabledFont();
                tmpIcon = b2.getDisabledIcon();
            }
        } else if (model.isPressed() && model.isArmed()) {
            tmpForeground = b2.getPressedForeground();
            tmpBackground = b2.getPressedBackground();
            tmpFont = b2.getPressedFont();
            tmpIcon = b2.getPressedIcon();
        } else if (b2.hasFocus()) {
            if (model.isSelected()) {
                tmpForeground = b2.getFocusedSelectedForeground();
                tmpBackground = b2.getFocusedSelectedBackground();
                tmpFont = b2.getFocusedSelectedFont();
                tmpIcon = b2.getFocusedSelectedIcon();
            } else {
                tmpForeground = b2.getFocusedForeground();
                tmpBackground = b2.getFocusedBackground();
                tmpFont = b2.getFocusedFont();
                tmpIcon = b2.getFocusedIcon();
            }
        } else if (b2.isRolloverEnabled() && model.isRollover()) {
            if (model.isSelected()) {
                tmpForeground = b2.getRolloverSelectedForeground();
                tmpBackground = b2.getRolloverSelectedBackground();
                tmpFont = b2.getRolloverSelectedFont();
                tmpIcon = b2.getRolloverSelectedIcon();
            } else {
                tmpForeground = b2.getRolloverForeground();
                tmpBackground = b2.getRolloverBackground();
                tmpFont = b2.getRolloverFont();
                tmpIcon = b2.getRolloverIcon();
            }
        } else if (model.isSelected()) {
            tmpForeground = b2.getSelectedForeground();
            tmpBackground = b2.getSelectedBackground();
            tmpFont = b2.getSelectedFont();
            tmpIcon = b2.getSelectedIcon();
        }
        if (tmpFont != null) {
            font = tmpFont;
        }
        g.setFont(font);
        String[] text = BounceGraphicsUtils.layoutMultilineCompoundLabel(c2, fm, b2.getText(), b2.getIcon(), b2.getVerticalAlignment(), b2.getHorizontalAlignment(), b2.getVerticalTextPosition(), b2.getHorizontalTextPosition(), viewRect, iconRect, textRect, b2.getText() == null ? 0 : this.defaultTextIconGap, b2.getMinimumLines(), b2.getMaximumLines());
        this.clearTextShiftOffset();
        if (tmpBackground != null) {
            background = tmpBackground;
        }
        g.setColor(background);
        if (tmpIcon != null) {
            icon = tmpIcon;
        }
        if (icon != null) {
            this.paintIcon(g, c2, iconRect, icon);
        }
        if (tmpForeground != null) {
            foreground = tmpForeground;
        }
        g.setColor(foreground);
        if (text != null && !text.equals("")) {
            View v = (View)c2.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, c2, textRect, text);
            }
        }
        if (b2.getFocusedRectangleMode() != 0 && b2.isFocusPainted() && b2.hasFocus() && b2.getFocusedRectangleColor() != null) {
            this.paintFocus(g, b2, viewRect, textRect, iconRect);
        }
    }

    protected void paintIcon(Graphics g, JComponent c2, Rectangle iconRect, Icon icon) {
        QButton b2 = (QButton)c2;
        ButtonModel model = b2.getModel();
        if (icon == null) {
            return;
        }
        if (model.isPressed() && model.isArmed()) {
            icon.paintIcon(c2, g, iconRect.x + this.getTextShiftOffset(), iconRect.y + this.getTextShiftOffset());
        } else {
            icon.paintIcon(c2, g, iconRect.x, iconRect.y);
        }
    }

    protected void paintBackground(Graphics g, JComponent c2) {
        Dimension size = c2.getSize();
        g.fillRect(0, 0, size.width, size.height);
    }

    protected void paintFocus(Graphics g, QButton b2, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        boolean isIcon;
        Rectangle focusRect = new Rectangle();
        String text = b2.getText();
        boolean bl = isIcon = b2.getIcon() != null;
        if (text != null && !text.equals("")) {
            if (!isIcon && b2.getFocusedRectangleMode() != 2) {
                focusRect.setBounds(textRect);
            } else if (b2.getFocusedRectangleMode() == 3) {
                focusRect.setBounds(iconRect.union(textRect));
            } else if (b2.getFocusedRectangleMode() == 1) {
                focusRect.setBounds(textRect);
            } else if (b2.getFocusedRectangleMode() == 2) {
                focusRect.setBounds(iconRect);
            }
        } else if (isIcon) {
            focusRect.setBounds(iconRect);
        }
        g.setColor(b2.getFocusedRectangleColor());
        g.drawRect(focusRect.x - 1, focusRect.y - 1, focusRect.width + 1, focusRect.height + 1);
    }

    protected void paintText(Graphics g, JComponent c2, Rectangle textRect, String[] text) {
        QButton b2 = (QButton)c2;
        ButtonModel model = b2.getModel();
        FontMetrics fm = g.getFontMetrics();
        int y = textRect.y + fm.getAscent();
        for (int i = 0; i < text.length; ++i) {
            BounceGraphicsUtils.drawLine(g, fm, textRect, text[i], b2.getHorizontalAlignment(), y, model.getMnemonic());
            y += fm.getHeight();
        }
    }

    protected BasicButtonListener createButtonListener(AbstractButton b2) {
        return new BounceButtonListener(b2);
    }

    public Dimension getPreferredSize(JComponent c2) {
        QButton b2 = (QButton)c2;
        if (b2.getComponentCount() > 0) {
            return null;
        }
        Insets i = c2.getInsets();
        Rectangle viewRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        if (b2.getMaximumLines() == 1) {
            viewRect.x = i.left + i.right;
            viewRect.y = i.top + i.bottom;
            viewRect.height = Short.MAX_VALUE;
            viewRect.width = Short.MAX_VALUE;
        } else {
            viewRect.x = i.left;
            viewRect.y = i.top;
            viewRect.width = b2.getWidth() - (i.right + viewRect.x);
            viewRect.height = b2.getHeight() - (i.bottom + viewRect.y);
        }
        BounceGraphicsUtils.layoutMultilineCompoundLabel(c2, b2.getGraphics().getFontMetrics(), b2.getText(), b2.getIcon(), b2.getVerticalAlignment(), b2.getHorizontalAlignment(), b2.getVerticalTextPosition(), b2.getHorizontalTextPosition(), viewRect, iconRect, textRect, b2.getText() == null ? 0 : this.defaultTextIconGap, b2.getMinimumLines(), b2.getMaximumLines());
        Rectangle r = iconRect.union(textRect);
        Insets insets = b2.getInsets();
        r.width += insets.left + insets.right;
        r.height += insets.top + insets.bottom;
        if (r.width % 2 == 0) {
            ++r.width;
        }
        if (r.height % 2 == 0) {
            ++r.height;
        }
        return r.getSize();
    }
}

