/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.plaf;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class BounceGraphicsUtils {
    public static int drawLine(Graphics g, FontMetrics fm, Rectangle rect, String text, int hAlign, int y, int mnemonic) {
        int x = rect.x;
        if (text != null) {
            int width = SwingUtilities.computeStringWidth(fm, text);
            if (hAlign == 0) {
                x = rect.x + (rect.width - width) / 2;
            } else if (hAlign == 4) {
                x = rect.x + (rect.width - width);
            }
            BasicGraphicsUtils.drawString(g, text, mnemonic, x, y);
        }
        return x;
    }

    public static String[] layoutMultilineCompoundLabel(JComponent c2, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap, int minLines, int maxLines) {
        int gap;
        String[] result = new String[maxLines];
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        boolean textIsEmpty = text == null || text.equals("");
        View v = null;
        if (textIsEmpty) {
            textR.height = 0;
            textR.width = 0;
            text = "";
        } else {
            View view = v = c2 != null ? (View)c2.getClientProperty("html") : null;
            if (v != null) {
                textR.width = (int)v.getPreferredSpan(0);
                textR.height = (int)v.getPreferredSpan(1);
            } else {
                textR.width = SwingUtilities.computeStringWidth(fm, text);
                textR.height = fm.getHeight() * minLines;
            }
        }
        int n = gap = textIsEmpty || icon == null ? 0 : textIconGap;
        if (!textIsEmpty) {
            int availTextWidth = horizontalTextPosition == 0 ? viewR.width : viewR.width - (iconR.width + gap);
            if (textR.width > availTextWidth) {
                if (v != null) {
                    textR.width = availTextWidth;
                } else {
                    int i;
                    textR.width = 0;
                    String clipString = "...";
                    int prevChars = 0;
                    int nChars = 0;
                    for (i = 1; i <= maxLines && nChars < text.length(); ++i) {
                        int totalWidth = 0;
                        int spacePos = 0;
                        if (i == maxLines) {
                            totalWidth = SwingUtilities.computeStringWidth(fm, clipString);
                        }
                        for (nChars = prevChars; nChars < text.length(); ++nChars) {
                            char ch = text.charAt(nChars);
                            if (ch == ' ') {
                                spacePos = nChars;
                            }
                            if ((totalWidth += fm.charWidth(ch)) <= availTextWidth) continue;
                            if (spacePos <= 0 || i >= maxLines) break;
                            nChars = spacePos;
                            break;
                        }
                        if (i == maxLines && nChars < text.length()) {
                            result[i - 1] = text.substring(prevChars, nChars) + clipString;
                        } else {
                            result[i - 1] = text.substring(prevChars, nChars);
                            prevChars = nChars;
                            if (spacePos != 0) {
                                ++prevChars;
                            }
                        }
                        textR.width = Math.max(textR.width, SwingUtilities.computeStringWidth(fm, result[i - 1]));
                    }
                    textR.height = fm.getHeight() * minLines;
                    for (i = minLines; i < maxLines && result[i] != null; ++i) {
                        textR.height += fm.getHeight();
                    }
                }
            } else {
                result[0] = text;
            }
        }
        textR.y = verticalTextPosition == 1 ? (horizontalTextPosition != 0 ? 0 : -(textR.height + gap)) : (verticalTextPosition == 0 ? iconR.height / 2 - textR.height / 2 : (horizontalTextPosition != 0 ? iconR.height - textR.height : iconR.height + gap));
        textR.x = horizontalTextPosition == 2 ? -(textR.width + gap) : (horizontalTextPosition == 0 ? iconR.width / 2 - textR.width / 2 : iconR.width + gap);
        int labelR_x = Math.min(iconR.x, textR.x);
        int labelR_width = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_x;
        int labelR_y = Math.min(iconR.y, textR.y);
        int labelR_height = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_y;
        int dy = verticalAlignment == 1 ? viewR.y - labelR_y : (verticalAlignment == 0 ? viewR.y + viewR.height / 2 - (labelR_y + labelR_height / 2) : viewR.y + viewR.height - (labelR_y + labelR_height));
        int dx = horizontalAlignment == 2 ? viewR.x - labelR_x : (horizontalAlignment == 4 ? viewR.x + viewR.width - (labelR_x + labelR_width) : viewR.x + viewR.width / 2 - (labelR_x + labelR_width / 2));
        textR.x += dx;
        textR.y += dy;
        iconR.x += dx;
        iconR.y += dy;
        return result;
    }
}

