/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.knowm.xchart.CategorySeries;
import org.knowm.xchart.internal.chartpart.Axis;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.ChartPart;
import org.knowm.xchart.internal.series.AxesChartSeries;
import org.knowm.xchart.internal.series.AxesChartSeriesCategory;
import org.knowm.xchart.style.AxesChartStyler;
import org.knowm.xchart.style.BoxStyler;
import org.knowm.xchart.style.CategoryStyler;
import org.knowm.xchart.style.Styler;

public class AxisPair<ST extends AxesChartStyler, S extends AxesChartSeries>
implements ChartPart {
    private final Chart<ST, S> chart;
    private final Axis<ST, S> xAxis;
    private final Axis<ST, S> yAxis;
    private final TreeMap<Integer, Axis<ST, S>> yAxisMap;
    private final Rectangle2D.Double leftYAxisBounds;
    private final Rectangle2D.Double rightYAxisBounds;
    private Axis<ST, S> leftMainYAxis;
    private Axis<ST, S> rightMainYAxis;

    public AxisPair(Chart<ST, S> chart) {
        this.chart = chart;
        this.xAxis = new Axis<ST, S>(chart, Axis.Direction.X, 0);
        this.yAxis = new Axis<ST, S>(chart, Axis.Direction.Y, 0);
        this.yAxisMap = new TreeMap();
        this.yAxisMap.put(0, this.yAxis);
        this.leftYAxisBounds = new Rectangle2D.Double();
        this.rightYAxisBounds = new Rectangle2D.Double();
    }

    @Override
    public void paint(Graphics2D g) {
        Rectangle2D.Double bounds;
        double rightEnd;
        double width;
        Rectangle2D.Double bounds2;
        Axis<ST, S> ya;
        int chartPadding;
        this.prepareForPaint();
        this.leftMainYAxis = null;
        this.rightMainYAxis = null;
        AxesChartStyler styler = (AxesChartStyler)this.chart.getStyler();
        int paddingBetweenAxes = chartPadding = styler.getChartPadding();
        int tickMargin = styler.isYAxisTicksVisible() ? styler.getPlotMargin() : 0;
        this.leftYAxisBounds.width = 0.0;
        int leftCount = 0;
        double leftStart = chartPadding;
        int desiredLeftYAxisWidth = styler.getYAxisLeftWidthHint();
        if (desiredLeftYAxisWidth > 0) {
            double widthEstimation = 0.0;
            for (Map.Entry<Integer, Axis<ST, S>> e2 : this.yAxisMap.entrySet()) {
                ya = e2.getValue();
                if (styler.getYAxisGroupPosistion(e2.getKey()) == Styler.YAxisPosition.Right) continue;
                ya.preparePaint();
                bounds2 = (Rectangle2D.Double)ya.getBounds();
                width = bounds2.getWidth();
                widthEstimation += width;
                ++leftCount;
            }
            if (leftCount > 1) {
                widthEstimation += (double)((leftCount - 1) * paddingBetweenAxes);
            }
            if ((widthEstimation += (double)(leftCount * tickMargin)) < (double)desiredLeftYAxisWidth) {
                leftStart = (double)desiredLeftYAxisWidth - widthEstimation;
            }
            leftCount = 0;
        }
        double leftStartFirst = leftStart;
        for (Map.Entry<Integer, Axis<ST, S>> e2 : this.yAxisMap.entrySet()) {
            ya = e2.getValue();
            if (styler.getYAxisGroupPosistion(e2.getKey()) == Styler.YAxisPosition.Right || e2.getKey() == 0) continue;
            ya.preparePaint();
            bounds2 = (Rectangle2D.Double)ya.getBounds();
            bounds2.x = leftStart;
            ya.paint(g);
            width = bounds2.getWidth();
            leftStart += (double)paddingBetweenAxes + width + (double)tickMargin;
            this.leftYAxisBounds.width += width;
            ++leftCount;
            this.leftMainYAxis = ya;
        }
        if (styler.getYAxisGroupPosistion(0) != Styler.YAxisPosition.Right) {
            this.yAxis.preparePaint();
            Rectangle2D.Double bounds3 = (Rectangle2D.Double)this.yAxis.getBounds();
            bounds3.x = leftStart;
            this.yAxis.paint(g);
            double width2 = bounds3.getWidth();
            leftStart += (double)paddingBetweenAxes + width2 + (double)tickMargin;
            this.leftYAxisBounds.width += width2;
            ++leftCount;
            this.leftMainYAxis = this.yAxis;
        }
        if (leftCount > 1) {
            this.leftYAxisBounds.width += (double)((leftCount - 1) * paddingBetweenAxes);
        }
        this.leftYAxisBounds.width += (double)(leftCount * tickMargin);
        this.rightYAxisBounds.width = 0.0;
        double legendWidth = 0.0;
        if (styler.getLegendPosition() == Styler.LegendPosition.OutsideE && styler.isLegendVisible()) {
            legendWidth = this.chart.getLegend().getBounds().getWidth() + (double)styler.getChartPadding();
        }
        this.rightYAxisBounds.x = rightEnd = (double)this.chart.getWidth() - legendWidth - (double)chartPadding;
        int rightCount = 0;
        for (Map.Entry e3 : this.yAxisMap.descendingMap().entrySet()) {
            double xOffset;
            Axis ya2 = (Axis)e3.getValue();
            if (styler.getYAxisGroupPosistion((Integer)e3.getKey()) != Styler.YAxisPosition.Right || (Integer)e3.getKey() == 0) continue;
            ya2.preparePaint();
            Rectangle2D.Double bounds4 = (Rectangle2D.Double)ya2.getBounds();
            double aproxWidth = bounds4.getWidth();
            bounds4.x = xOffset = rightEnd - aproxWidth;
            this.rightYAxisBounds.x = xOffset;
            ya2.paint(g);
            this.rightYAxisBounds.width += aproxWidth;
            rightEnd -= (double)paddingBetweenAxes + aproxWidth + (double)tickMargin;
            ++rightCount;
            this.rightMainYAxis = ya2;
        }
        if (styler.getYAxisGroupPosistion(0) == Styler.YAxisPosition.Right) {
            double xOffset;
            this.yAxis.preparePaint();
            bounds = (Rectangle2D.Double)this.yAxis.getBounds();
            double aproxWidth = bounds.getWidth();
            bounds.x = xOffset = rightEnd - aproxWidth;
            this.rightYAxisBounds.x = xOffset;
            this.yAxis.paint(g);
            this.rightYAxisBounds.width += aproxWidth;
            rightEnd -= (double)paddingBetweenAxes + aproxWidth + (double)tickMargin;
            ++rightCount;
            this.rightMainYAxis = this.yAxis;
        }
        if (this.leftMainYAxis == null) {
            this.leftMainYAxis = this.yAxis;
        }
        if (this.rightMainYAxis == null) {
            this.rightMainYAxis = this.yAxis;
        }
        if (rightCount > 1) {
            this.rightYAxisBounds.width += (double)((rightCount - 1) * paddingBetweenAxes);
        }
        this.rightYAxisBounds.width += (double)(rightCount * tickMargin);
        bounds = (Rectangle2D.Double)this.yAxis.getBounds();
        this.leftYAxisBounds.x = leftStartFirst;
        this.leftYAxisBounds.y = bounds.y;
        this.leftYAxisBounds.height = bounds.height;
        this.rightYAxisBounds.y = bounds.y;
        this.rightYAxisBounds.height = bounds.height;
        this.xAxis.preparePaint();
        this.xAxis.paint(g);
    }

    private void prepareForPaint() {
        this.yAxisMap.clear();
        this.yAxisMap.put(0, this.yAxis);
        boolean mainYAxisUsed = false;
        if (this.chart.getSeriesMap() != null) {
            for (AxesChartSeries series : this.chart.getSeriesMap().values()) {
                if (!series.isEnabled()) continue;
                int yIndex = series.getYAxisGroup();
                if (!mainYAxisUsed && yIndex == 0) {
                    mainYAxisUsed = true;
                }
                if (this.yAxisMap.containsKey(yIndex)) continue;
                this.yAxisMap.put(yIndex, new Axis<ST, S>(this.chart, Axis.Direction.Y, yIndex));
            }
        }
        this.xAxis.setDataType(null);
        for (Axis<ST, S> ya : this.yAxisMap.values()) {
            ya.setDataType(null);
        }
        for (AxesChartSeries series : this.chart.getSeriesMap().values()) {
            this.xAxis.setDataType(series.getxAxisDataType());
            if (!series.isEnabled()) continue;
            this.getYAxis(series.getYAxisGroup()).setDataType(series.getyAxisDataType());
            if (!mainYAxisUsed) {
                this.yAxis.setDataType(series.getyAxisDataType());
            }
            if (series.getYAxisDecimalPattern() == null) continue;
            ((AxesChartStyler)this.chart.getStyler()).putYAxisGroupDecimalPatternMap(series.getYAxisGroup(), series.getYAxisDecimalPattern());
        }
        this.xAxis.resetMinMax();
        for (Axis<ST, S> ya : this.yAxisMap.values()) {
            ya.resetMinMax();
        }
        if (this.chart.getSeriesMap() == null || this.chart.getSeriesMap().size() < 1) {
            this.setDefaultAxisMinMax();
        } else {
            int disabledCount = 0;
            for (AxesChartSeries series : this.chart.getSeriesMap().values()) {
                if (!series.isEnabled()) {
                    ++disabledCount;
                    continue;
                }
                this.xAxis.addMinMax(series.getXMin(), series.getXMax());
                this.getYAxis(series.getYAxisGroup()).addMinMax(series.getYMin(), series.getYMax());
                if (mainYAxisUsed) continue;
                this.yAxis.addMinMax(series.getYMin(), series.getYMax());
            }
            if (disabledCount == this.chart.getSeriesMap().values().size()) {
                this.setDefaultAxisMinMax();
            }
        }
        this.overrideMinMaxForXAxis();
        for (Axis<ST, S> ya : this.yAxisMap.values()) {
            this.overrideMinMaxForYAxis(ya);
        }
        if (((AxesChartStyler)this.chart.getStyler()).isXAxisLogarithmic() && this.xAxis.getMin() <= 0.0) {
            throw new IllegalArgumentException("Series data (accounting for error bars too) cannot be less or equal to zero for a logarithmic X-Axis!!!");
        }
        if (((AxesChartStyler)this.chart.getStyler()).isYAxisLogarithmic()) {
            for (Axis<ST, S> ya : this.yAxisMap.values()) {
                if (!(ya.getMin() <= 0.0)) continue;
                throw new IllegalArgumentException("Series data (accounting for error bars too) cannot be less or equal to zero for a logarithmic Y-Axis!!!");
            }
        }
        if (this.xAxis.getMin() == Double.POSITIVE_INFINITY || this.xAxis.getMax() == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException("Series data (accounting for error bars too) cannot be equal to Double.POSITIVE_INFINITY!!!");
        }
        for (Axis<ST, S> ya : this.yAxisMap.values()) {
            if (ya.getMin() == Double.POSITIVE_INFINITY || ya.getMax() == Double.POSITIVE_INFINITY) {
                throw new IllegalArgumentException("Series data (accounting for error bars too) cannot be equal to Double.POSITIVE_INFINITY!!!");
            }
            if (ya.getMin() != Double.NEGATIVE_INFINITY && ya.getMax() != Double.NEGATIVE_INFINITY) continue;
            throw new IllegalArgumentException("Series data (accounting for error bars too) cannot be equal to Double.NEGATIVE_INFINITY!!!");
        }
        if (this.xAxis.getMin() == Double.NEGATIVE_INFINITY || this.xAxis.getMax() == Double.NEGATIVE_INFINITY) {
            throw new IllegalArgumentException("Series data (accounting for error bars too) cannot be equal to Double.NEGATIVE_INFINITY!!!");
        }
    }

    private void setDefaultAxisMinMax() {
        double xMin = ((AxesChartStyler)this.chart.getStyler()).isXAxisLogarithmic() ? 0.1 : -1.0;
        double yMin = ((AxesChartStyler)this.chart.getStyler()).isYAxisLogarithmic() ? 0.1 : -1.0;
        this.xAxis.addMinMax(xMin, 1.0);
        for (Axis<ST, S> ya : this.yAxisMap.values()) {
            ya.addMinMax(yMin, 1.0);
        }
    }

    Axis<ST, S> getYAxis(int yIndex) {
        return this.yAxisMap.get(yIndex);
    }

    private void overrideMinMaxForXAxis() {
        double overrideXAxisMinValue = this.xAxis.getMin();
        double overrideXAxisMaxValue = this.xAxis.getMax();
        if (((AxesChartStyler)this.chart.getStyler()).getXAxisMin() != null) {
            overrideXAxisMinValue = ((AxesChartStyler)this.chart.getStyler()).getXAxisMin();
        }
        if (((AxesChartStyler)this.chart.getStyler()).getXAxisMax() != null) {
            overrideXAxisMaxValue = ((AxesChartStyler)this.chart.getStyler()).getXAxisMax();
        }
        this.xAxis.setMin(overrideXAxisMinValue);
        this.xAxis.setMax(overrideXAxisMaxValue);
    }

    private void overrideMinMaxForYAxis(Axis yAxis) {
        CategoryStyler categoryStyler;
        double overrideYAxisMinValue = yAxis.getMin();
        double overrideYAxisMaxValue = yAxis.getMax();
        if (this.chart.getStyler() instanceof CategoryStyler && ((categoryStyler = (CategoryStyler)this.chart.getStyler()).getDefaultSeriesRenderStyle() == CategorySeries.CategorySeriesRenderStyle.Bar || categoryStyler.getDefaultSeriesRenderStyle() == CategorySeries.CategorySeriesRenderStyle.Stick)) {
            if (categoryStyler.isStacked()) {
                AxesChartSeriesCategory axesChartSeries = (AxesChartSeriesCategory)this.chart.getSeriesMap().values().iterator().next();
                List categories = (List)axesChartSeries.getXData();
                int numCategories = categories.size();
                double[] accumulatedStackOffsetPos = new double[numCategories];
                double[] accumulatedStackOffsetNeg = new double[numCategories];
                for (AxesChartSeries series : this.chart.getSeriesMap().values()) {
                    AxesChartSeriesCategory axesChartSeriesCategory = (AxesChartSeriesCategory)series;
                    if (!series.isEnabled()) continue;
                    int categoryCounter = 0;
                    for (Number number : axesChartSeriesCategory.getYData()) {
                        if (number == null) {
                            ++categoryCounter;
                            continue;
                        }
                        if (number.doubleValue() > 0.0) {
                            int n = categoryCounter;
                            accumulatedStackOffsetPos[n] = accumulatedStackOffsetPos[n] + number.doubleValue();
                        } else if (number.doubleValue() < 0.0) {
                            int n = categoryCounter;
                            accumulatedStackOffsetNeg[n] = accumulatedStackOffsetNeg[n] + number.doubleValue();
                        }
                        ++categoryCounter;
                    }
                }
                double max = accumulatedStackOffsetPos[0];
                for (int i = 1; i < accumulatedStackOffsetPos.length; ++i) {
                    if (!(accumulatedStackOffsetPos[i] > max)) continue;
                    max = accumulatedStackOffsetPos[i];
                }
                double min = accumulatedStackOffsetNeg[0];
                for (int i = 1; i < accumulatedStackOffsetNeg.length; ++i) {
                    if (!(accumulatedStackOffsetNeg[i] < min)) continue;
                    min = accumulatedStackOffsetNeg[i];
                }
                overrideYAxisMaxValue = max;
                overrideYAxisMinValue = min;
            }
            if (yAxis.getMin() > 0.0) {
                overrideYAxisMinValue = 0.0;
            }
            if (yAxis.getMax() < 0.0) {
                overrideYAxisMaxValue = 0.0;
            }
        }
        if (((AxesChartStyler)this.chart.getStyler()).getYAxisMin(yAxis.getYIndex()) != null && !(this.chart.getStyler() instanceof BoxStyler)) {
            overrideYAxisMinValue = ((AxesChartStyler)this.chart.getStyler()).getYAxisMin(yAxis.getYIndex());
        } else if (((AxesChartStyler)this.chart.getStyler()).getYAxisMin() != null && !(this.chart.getStyler() instanceof BoxStyler)) {
            overrideYAxisMinValue = ((AxesChartStyler)this.chart.getStyler()).getYAxisMin();
        }
        if (((AxesChartStyler)this.chart.getStyler()).getYAxisMax(yAxis.getYIndex()) != null && !(this.chart.getStyler() instanceof BoxStyler)) {
            overrideYAxisMaxValue = ((AxesChartStyler)this.chart.getStyler()).getYAxisMax(yAxis.getYIndex());
        } else if (((AxesChartStyler)this.chart.getStyler()).getYAxisMax() != null && !(this.chart.getStyler() instanceof BoxStyler)) {
            overrideYAxisMaxValue = ((AxesChartStyler)this.chart.getStyler()).getYAxisMax();
        }
        yAxis.setMin(overrideYAxisMinValue);
        yAxis.setMax(overrideYAxisMaxValue);
    }

    public Axis<ST, S> getXAxis() {
        return this.xAxis;
    }

    Axis<ST, S> getYAxis() {
        return this.yAxis;
    }

    @Override
    public Rectangle2D getBounds() {
        return null;
    }

    Rectangle2D.Double getLeftYAxisBounds() {
        return this.leftYAxisBounds;
    }

    Rectangle2D.Double getRightYAxisBounds() {
        return this.rightYAxisBounds;
    }

    Axis<ST, S> getLeftMainYAxis() {
        return this.leftMainYAxis;
    }

    Axis<ST, S> getRightMainYAxis() {
        return this.rightMainYAxis;
    }
}

