/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.binarysolution.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.uma.jmetal.solution.AbstractSolution;
import org.uma.jmetal.solution.binarysolution.BinarySolution;
import org.uma.jmetal.util.binarySet.BinarySet;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class DefaultBinarySolution
extends AbstractSolution<BinarySet>
implements BinarySolution {
    protected List<Integer> numberOfBitsPerVariable;

    public DefaultBinarySolution(List<Integer> bitsPerVariable, int numberOfObjectives) {
        this(bitsPerVariable, numberOfObjectives, 0);
    }

    public DefaultBinarySolution(List<Integer> bitsPerVariable, int numberOfObjectives, int numberOfConstraints) {
        super(bitsPerVariable.size(), numberOfObjectives, numberOfConstraints);
        this.numberOfBitsPerVariable = bitsPerVariable;
        this.initializeBinaryVariables(JMetalRandom.getInstance());
    }

    public DefaultBinarySolution(DefaultBinarySolution solution) {
        super(solution.variables().size(), solution.objectives().length, solution.constraints().length);
        this.numberOfBitsPerVariable = solution.numberOfBitsPerVariable;
        for (int i2 = 0; i2 < this.variables().size(); ++i2) {
            this.variables().set(i2, (BinarySet)((BinarySet)solution.variables().get(i2)).clone());
        }
        Arrays.setAll(this.objectives(), i -> solution.objectives()[i]);
        Arrays.setAll(this.constraints(), i -> solution.constraints()[i]);
        this.attributes = new HashMap(solution.attributes);
    }

    private static BinarySet createNewBinarySet(int numberOfBits, JMetalRandom randomGenerator) {
        BinarySet bitSet = new BinarySet(numberOfBits);
        for (int i = 0; i < numberOfBits; ++i) {
            double rnd = randomGenerator.nextDouble();
            if (rnd < 0.5) {
                bitSet.set(i);
                continue;
            }
            bitSet.clear(i);
        }
        return bitSet;
    }

    @Override
    public List<Integer> numberOfBitsPerVariable() {
        return this.numberOfBitsPerVariable;
    }

    public DefaultBinarySolution copy() {
        return new DefaultBinarySolution(this);
    }

    @Override
    public int totalNumberOfBits() {
        int sum = 0;
        for (int i = 0; i < this.variables().size(); ++i) {
            sum += ((BinarySet)this.variables().get(i)).getBinarySetLength();
        }
        return sum;
    }

    private void initializeBinaryVariables(JMetalRandom randomGenerator) {
        for (int i = 0; i < this.variables().size(); ++i) {
            this.variables().set(i, DefaultBinarySolution.createNewBinarySet(this.numberOfBitsPerVariable.get(i), randomGenerator));
        }
    }
}

