/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import org.uma.jmetal.util.distance.Distance;
import org.uma.jmetal.util.distance.impl.EuclideanDistanceBetweenVectors;
import org.uma.jmetal.util.errorchecking.Check;

public class VectorUtils {
    public static int dominanceTest(double[] vector1, double[] vector2) {
        int bestIsOne = 0;
        int bestIsTwo = 0;
        for (int i = 0; i < vector1.length; ++i) {
            double value1 = vector1[i];
            double value2 = vector2[i];
            if (value1 == value2) continue;
            if (value1 < value2) {
                bestIsOne = 1;
            }
            if (!(value2 < value1)) continue;
            bestIsTwo = 1;
        }
        int result = Integer.compare(bestIsTwo, bestIsOne);
        return result;
    }

    public static double[][] readVectors(String filePath, String separator) throws IOException {
        String path = filePath;
        URL url = VectorUtils.class.getClassLoader().getResource(filePath);
        if (url != null) {
            try {
                path = Paths.get(url.toURI()).toString();
            }
            catch (URISyntaxException e2) {
                e2.printStackTrace();
            }
        }
        List<String> vectorStrList = Files.readAllLines(Paths.get(path, new String[0]));
        double[][] referenceVectors = new double[vectorStrList.size()][];
        for (int i = 0; i < vectorStrList.size(); ++i) {
            String vectorStr = vectorStrList.get(i);
            String[] objectArray = vectorStr.split(separator);
            referenceVectors[i] = new double[objectArray.length];
            for (int j = 0; j < objectArray.length; ++j) {
                referenceVectors[i][j] = Double.parseDouble(objectArray[j]);
            }
        }
        return referenceVectors;
    }

    public static double[][] readVectors(String filePath) throws IOException {
        return VectorUtils.readVectors(filePath, "\\s+");
    }

    public static boolean isVectorDominatedByAFront(double[] vector, double[][] front) {
        boolean result = false;
        for (int i = 0; !result && i < front.length; ++i) {
            if (VectorUtils.dominanceTest(vector, front[i]) != 1) continue;
            result = true;
        }
        return result;
    }

    public static double distanceToClosestVector(double[] vector, double[][] front) {
        return VectorUtils.distanceToClosestVector(vector, front, new EuclideanDistanceBetweenVectors());
    }

    public static double distanceToClosestVector(double[] vector, double[][] front, Distance<double[], double[]> distance) {
        Check.notNull(vector);
        Check.notNull(front);
        Check.that(front.length > 0, "The front is empty");
        double minDistance = distance.compute(vector, front[0]);
        for (int i = 1; i < front.length; ++i) {
            double aux = distance.compute(vector, front[i]);
            if (!(aux < minDistance)) continue;
            minDistance = aux;
        }
        return minDistance;
    }

    public static double distanceToNearestVector(double[] vector, double[][] front) {
        return VectorUtils.distanceToNearestVector(vector, front, new EuclideanDistanceBetweenVectors());
    }

    public static double distanceToNearestVector(double[] vector, double[][] front, Distance<double[], double[]> distance) {
        Check.notNull(vector);
        Check.notNull(front);
        Check.that(front.length > 0, "The front is empty");
        double minDistance = Double.MAX_VALUE;
        for (double[] value : front) {
            double aux = distance.compute(vector, value);
            if (!(aux < minDistance) || !(aux > 0.0)) continue;
            minDistance = aux;
        }
        return minDistance;
    }

    public static double[][] getInvertedFront(double[][] front) {
        Check.notNull(front);
        Check.that(front.length > 0, "The front is empty");
        int numberOfDimensions = front[0].length;
        double[][] invertedFront = new double[front.length][numberOfDimensions];
        for (int i = 0; i < front.length; ++i) {
            for (int j = 0; j < numberOfDimensions; ++j) {
                if (front[i][j] <= 1.0 && front[i][j] >= 0.0) {
                    invertedFront[i][j] = 1.0 - front[i][j];
                    continue;
                }
                if (front[i][j] > 1.0) {
                    invertedFront[i][j] = 0.0;
                    continue;
                }
                if (!(front[i][j] < 0.0)) continue;
                invertedFront[i][j] = 1.0;
            }
        }
        return invertedFront;
    }

    public static double[] toArray(List<Double> list) {
        return list.stream().mapToDouble(v -> v).toArray();
    }
}

