/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.fileoutput;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class SolutionListOutput {
    private FileOutputContext varFileContext = new DefaultFileOutputContext(this.varFileName);
    private FileOutputContext funFileContext = new DefaultFileOutputContext(this.funFileName);
    private String varFileName = "VAR";
    private String funFileName = "FUN";
    private List<? extends Solution<?>> solutionList;
    private List<Boolean> isObjectiveToBeMinimized;

    public SolutionListOutput(List<? extends Solution<?>> solutionList) {
        this.solutionList = solutionList;
        this.isObjectiveToBeMinimized = null;
    }

    public SolutionListOutput setVarFileOutputContext(FileOutputContext fileContext) {
        this.varFileContext = fileContext;
        return this;
    }

    public SolutionListOutput setFunFileOutputContext(FileOutputContext fileContext) {
        this.funFileContext = fileContext;
        return this;
    }

    public SolutionListOutput setObjectiveMinimizingObjectiveList(List<Boolean> isObjectiveToBeMinimized) {
        this.isObjectiveToBeMinimized = isObjectiveToBeMinimized;
        return this;
    }

    public void print() {
        if (this.isObjectiveToBeMinimized == null) {
            this.printObjectivesToFile(this.funFileContext, this.solutionList);
        } else {
            this.printObjectivesToFile(this.funFileContext, this.solutionList, this.isObjectiveToBeMinimized);
        }
        this.printVariablesToFile(this.varFileContext, this.solutionList);
    }

    public void printVariablesToFile(FileOutputContext context, List<? extends Solution<?>> solutionList) {
        BufferedWriter bufferedWriter = context.getFileWriter();
        try {
            if (solutionList.size() > 0) {
                int numberOfVariables = solutionList.get(0).variables().size();
                for (int i = 0; i < solutionList.size(); ++i) {
                    for (int j = 0; j < numberOfVariables - 1; ++j) {
                        bufferedWriter.write(String.valueOf(solutionList.get(i).variables().get(j)) + context.getSeparator());
                    }
                    bufferedWriter.write(String.valueOf(solutionList.get(i).variables().get(numberOfVariables - 1)));
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.close();
        }
        catch (IOException e2) {
            throw new JMetalException("Error writing data ", e2);
        }
    }

    public void printObjectivesToFile(FileOutputContext context, List<? extends Solution<?>> solutionList) {
        BufferedWriter bufferedWriter = context.getFileWriter();
        try {
            if (solutionList.size() > 0) {
                int numberOfObjectives = solutionList.get(0).objectives().length;
                for (int i = 0; i < solutionList.size(); ++i) {
                    for (int j = 0; j < numberOfObjectives - 1; ++j) {
                        bufferedWriter.write(solutionList.get(i).objectives()[j] + context.getSeparator());
                    }
                    bufferedWriter.write("" + solutionList.get(i).objectives()[numberOfObjectives - 1]);
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.close();
        }
        catch (IOException e2) {
            throw new JMetalException("Error printing objectives to file: ", e2);
        }
    }

    public void printObjectivesToFile(FileOutputContext context, List<? extends Solution<?>> solutionList, List<Boolean> minimizeObjective) {
        BufferedWriter bufferedWriter = context.getFileWriter();
        try {
            if (solutionList.size() > 0) {
                int numberOfObjectives = solutionList.get(0).objectives().length;
                if (numberOfObjectives != minimizeObjective.size()) {
                    throw new JMetalException("The size of list minimizeObjective is not correct: " + minimizeObjective.size());
                }
                for (int i = 0; i < solutionList.size(); ++i) {
                    for (int j = 0; j < numberOfObjectives - 1; ++j) {
                        if (minimizeObjective.get(j).booleanValue()) {
                            bufferedWriter.write(String.valueOf(solutionList.get(i).variables().get(j)) + context.getSeparator());
                            continue;
                        }
                        bufferedWriter.write(-1.0 * solutionList.get(i).objectives()[j] + context.getSeparator());
                    }
                    bufferedWriter.write("" + -1.0 * solutionList.get(i).objectives()[numberOfObjectives - 1]);
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.close();
        }
        catch (IOException e2) {
            throw new JMetalException("Error printing objecives to file: ", e2);
        }
    }

    public void printObjectivesToFile(String fileName) {
        this.printObjectivesToFile(new DefaultFileOutputContext(fileName), this.solutionList);
    }

    public void printObjectivesToFile(String fileName, String separator) {
        this.printObjectivesToFile(new DefaultFileOutputContext(fileName, separator), this.solutionList);
    }

    public void printObjectivesToFile(String fileName, List<Boolean> minimizeObjective) {
        this.printObjectivesToFile(new DefaultFileOutputContext(fileName), this.solutionList, minimizeObjective);
    }

    public void printObjectivesToFile(String fileName, List<Boolean> minimizeObjective, String separator) {
        this.printObjectivesToFile(new DefaultFileOutputContext(fileName, separator), this.solutionList, minimizeObjective);
    }

    public void printVariablesToFile(String fileName) {
        this.printVariablesToFile(new DefaultFileOutputContext(fileName), this.solutionList);
    }

    public void printVariablesToFile(String fileName, String separator) {
        this.printVariablesToFile(new DefaultFileOutputContext(fileName, separator), this.solutionList);
    }
}

