/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.legacy.front.impl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.legacy.front.Front;
import org.uma.jmetal.util.point.Point;
import org.uma.jmetal.util.point.impl.ArrayPoint;

public class ArrayFront
implements Front {
    protected Point[] points;
    protected int numberOfPoints;
    private int pointDimensions;

    public ArrayFront() {
        this.points = null;
        this.numberOfPoints = 0;
        this.pointDimensions = 0;
    }

    public ArrayFront(List<? extends Solution<?>> solutionList) {
        if (solutionList == null) {
            throw new JMetalException("The list of solutions is null");
        }
        if (solutionList.size() == 0) {
            throw new JMetalException("The list of solutions is empty");
        }
        this.numberOfPoints = solutionList.size();
        this.pointDimensions = solutionList.get(0).objectives().length;
        this.points = new Point[this.numberOfPoints];
        this.points = new Point[this.numberOfPoints];
        for (int i = 0; i < this.numberOfPoints; ++i) {
            ArrayPoint point = new ArrayPoint(this.pointDimensions);
            for (int j = 0; j < this.pointDimensions; ++j) {
                point.value(j, solutionList.get(i).objectives()[j]);
            }
            this.points[i] = point;
        }
    }

    public ArrayFront(Front front) {
        if (front == null) {
            throw new JMetalException("The front is null");
        }
        if (front.getNumberOfPoints() == 0) {
            throw new JMetalException("The front is empty");
        }
        this.numberOfPoints = front.getNumberOfPoints();
        this.pointDimensions = front.getPoint(0).dimension();
        this.points = new Point[this.numberOfPoints];
        this.points = new Point[this.numberOfPoints];
        for (int i = 0; i < this.numberOfPoints; ++i) {
            this.points[i] = new ArrayPoint(front.getPoint(i));
        }
    }

    public ArrayFront(int numberOfPoints, int dimensions) {
        this.numberOfPoints = numberOfPoints;
        this.pointDimensions = dimensions;
        this.points = new Point[this.numberOfPoints];
        for (int i = 0; i < this.numberOfPoints; ++i) {
            ArrayPoint point = new ArrayPoint(this.pointDimensions);
            for (int j = 0; j < this.pointDimensions; ++j) {
                point.value(j, 0.0);
            }
            this.points[i] = point;
        }
    }

    public ArrayFront(String fileName, String separator) throws FileNotFoundException {
        this();
        InputStream inputStream = this.createInputStream(fileName);
        InputStreamReader isr = new InputStreamReader(inputStream);
        BufferedReader br = new BufferedReader(isr);
        ArrayList<ArrayPoint> list = new ArrayList<ArrayPoint>();
        int numberOfObjectives = 0;
        try {
            String line = br.readLine();
            while (line != null) {
                String[] stringValues = line.split(separator);
                double[] values = new double[stringValues.length];
                for (int i = 0; i < stringValues.length; ++i) {
                    values[i] = Double.valueOf(stringValues[i]);
                }
                if (numberOfObjectives == 0) {
                    numberOfObjectives = stringValues.length;
                } else {
                    Check.that(numberOfObjectives == stringValues.length, "\"Invalid number of points read. \"\n                  + \"Expected: \"\n                  + numberOfObjectives\n                  + \", received: \"\n                  + values.length");
                }
                ArrayPoint point = new ArrayPoint(values);
                list.add(point);
                line = br.readLine();
            }
            br.close();
        }
        catch (IOException e2) {
            throw new JMetalException("Error reading file", e2);
        }
        catch (NumberFormatException e3) {
            throw new JMetalException("Format number exception when reading file", e3);
        }
        this.numberOfPoints = list.size();
        this.points = new Point[list.size()];
        this.points = list.toArray(this.points);
        this.pointDimensions = this.numberOfPoints == 0 ? 0 : this.points[0].dimension();
        for (int i = 0; i < this.numberOfPoints; ++i) {
            this.points[i] = (Point)list.get(i);
        }
    }

    public ArrayFront(String fileName) throws FileNotFoundException {
        this(fileName, ",");
    }

    public InputStream createInputStream(String fileName) throws FileNotFoundException {
        InputStream inputStream = this.getClass().getResourceAsStream(fileName);
        if (inputStream == null) {
            inputStream = new FileInputStream(fileName);
        }
        return inputStream;
    }

    @Override
    public int getNumberOfPoints() {
        return this.numberOfPoints;
    }

    @Override
    public int getPointDimensions() {
        return this.pointDimensions;
    }

    @Override
    public Point getPoint(int index) {
        if (index < 0) {
            throw new JMetalException("The index value is negative");
        }
        if (index >= this.numberOfPoints) {
            throw new JMetalException("The index value (" + index + ") is greater than the number of points (" + this.numberOfPoints + ")");
        }
        return this.points[index];
    }

    @Override
    public void setPoint(int index, Point point) {
        if (index < 0) {
            throw new JMetalException("The index value is negative");
        }
        if (index >= this.numberOfPoints) {
            throw new JMetalException("The index value (" + index + ") is greater than the number of points (" + this.numberOfPoints + ")");
        }
        if (point == null) {
            throw new JMetalException("The point is null");
        }
        this.points[index] = point;
    }

    @Override
    public void sort(Comparator<Point> comparator) {
        Arrays.sort(this.points, 0, this.numberOfPoints, comparator);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayFront that = (ArrayFront)o;
        if (this.numberOfPoints != that.numberOfPoints) {
            return false;
        }
        if (this.pointDimensions != that.pointDimensions) {
            return false;
        }
        return Arrays.equals(this.points, that.points);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.points);
        result = 31 * result + this.numberOfPoints;
        result = 31 * result + this.pointDimensions;
        return result;
    }

    public String toString() {
        return Arrays.toString(this.points);
    }

    @Override
    public double[][] getMatrix() {
        double[][] matrix = new double[this.getNumberOfPoints()][];
        for (int i = 0; i < this.getNumberOfPoints(); ++i) {
            matrix[i] = this.points[i].values();
        }
        return matrix;
    }
}

