/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.neighborhood.impl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.neighborhood.Neighborhood;

public class WeightVectorNeighborhood<S extends Solution<?>>
implements Neighborhood<S> {
    private int numberOfWeightVectors;
    private int weightVectorSize;
    private int[][] neighborhood;
    private double[][] weightVector;
    private int neighborhoodSize;

    public WeightVectorNeighborhood(int numberOfWeightVectors, int neighborhoodSize) {
        this.numberOfWeightVectors = numberOfWeightVectors;
        this.weightVectorSize = 2;
        this.neighborhoodSize = neighborhoodSize;
        this.neighborhood = new int[numberOfWeightVectors][neighborhoodSize];
        this.weightVector = new double[numberOfWeightVectors][this.weightVectorSize];
        for (int n = 0; n < numberOfWeightVectors; ++n) {
            double a2;
            this.weightVector[n][0] = a2 = 1.0 * (double)n / (double)(numberOfWeightVectors - 1);
            this.weightVector[n][1] = 1.0 - a2;
        }
        this.initializeNeighborhood();
    }

    public WeightVectorNeighborhood(int numberOfWeightVectors, int weightVectorSize, int neighborhoodSize, String vectorDirectoryName) throws FileNotFoundException {
        this.numberOfWeightVectors = numberOfWeightVectors;
        this.weightVectorSize = weightVectorSize;
        this.neighborhoodSize = neighborhoodSize;
        this.neighborhood = new int[numberOfWeightVectors][neighborhoodSize];
        this.weightVector = new double[numberOfWeightVectors][weightVectorSize];
        String weightVectorFileName = vectorDirectoryName + "/W" + weightVectorSize + "D_" + numberOfWeightVectors + ".dat";
        this.readWeightsFromFile(weightVectorFileName);
        this.initializeNeighborhood();
    }

    private void readWeightsFromFile(String vectorFileName) throws FileNotFoundException {
        InputStream inputStream = this.getClass().getResourceAsStream(vectorFileName);
        if (null == inputStream) {
            inputStream = new FileInputStream(vectorFileName);
        }
        InputStreamReader isr = new InputStreamReader(inputStream);
        try (BufferedReader br = new BufferedReader(isr);){
            int i = 0;
            String aux = br.readLine();
            while (aux != null) {
                StringTokenizer st = new StringTokenizer(aux);
                int j = 0;
                while (st.hasMoreTokens()) {
                    double value;
                    this.weightVector[i][j] = value = Double.valueOf(st.nextToken()).doubleValue();
                    ++j;
                }
                aux = br.readLine();
                ++i;
            }
        }
        catch (IOException e2) {
            throw new JMetalException("readWeightsFromFile: failed when reading for file: " + vectorFileName, e2);
        }
    }

    private void initializeNeighborhood() {
        EuclideanDistance euclideanDistance = new EuclideanDistance();
        double[] x = new double[this.numberOfWeightVectors];
        int[] idx = new int[this.numberOfWeightVectors];
        for (int i = 0; i < this.numberOfWeightVectors; ++i) {
            for (int j = 0; j < this.numberOfWeightVectors; ++j) {
                x[j] = euclideanDistance.compute(this.weightVector[i], this.weightVector[j]);
                idx[j] = j;
            }
            this.minFastSort(x, idx, this.numberOfWeightVectors, this.neighborhoodSize);
            System.arraycopy(idx, 0, this.neighborhood[i], 0, this.neighborhoodSize);
        }
    }

    private void minFastSort(double[] x, int[] idx, int n, int m) {
        for (int i = 0; i < m; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (!(x[i] > x[j])) continue;
                double temp = x[i];
                x[i] = x[j];
                x[j] = temp;
                int id = idx[i];
                idx[i] = idx[j];
                idx[j] = id;
            }
        }
    }

    @Override
    public List<S> getNeighbors(List<S> solutionList, int solutionIndex) {
        ArrayList<Solution> neighbourSolutions = new ArrayList<Solution>();
        for (int neighborIndex : this.neighborhood[solutionIndex]) {
            neighbourSolutions.add((Solution)solutionList.get(neighborIndex));
        }
        return neighbourSolutions;
    }

    public int getNumberOfWeightVectors() {
        return this.numberOfWeightVectors;
    }

    public int getWeightVectorSize() {
        return this.weightVectorSize;
    }

    public int[][] getNeighborhood() {
        return this.neighborhood;
    }

    public double[][] getWeightVector() {
        return this.weightVector;
    }

    public int neighborhoodSize() {
        return this.neighborhoodSize;
    }
}

