/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.ranking.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.ConstraintHandling;
import org.uma.jmetal.util.comparator.constraintcomparator.impl.OverallConstraintViolationDegreeComparator;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.ranking.Ranking;
import ru.ifmo.nds.JensenFortinBuzdalov;
import ru.ifmo.nds.NonDominatedSorting;

public class ExperimentalFastNonDominanceRanking<S extends Solution<?>>
implements Ranking<S> {
    private final String attributeId = this.getClass().getName();
    private final List<List<S>> subFronts = new ArrayList<List<S>>();
    private final OverallConstraintViolationDegreeComparator<S> constraintViolationComparator = new OverallConstraintViolationDegreeComparator();
    private NonDominatedSorting sortingInstance = null;

    @Override
    public Ranking<S> compute(List<S> solutionList) {
        this.subFronts.clear();
        int nSolutions = solutionList.size();
        if (nSolutions == 0) {
            return this;
        }
        Solution first = (Solution)solutionList.get(0);
        int nObjectives = first.objectives().length;
        boolean hasConstraintViolation = this.getConstraint(first) < 0.0;
        for (int i = 1; i < nSolutions; ++i) {
            Solution current = (Solution)solutionList.get(i);
            if (nObjectives != current.objectives().length) {
                throw new IllegalArgumentException("Solutions have different numbers of objectives");
            }
            hasConstraintViolation |= this.getConstraint(current) < 0.0;
        }
        if (!hasConstraintViolation) {
            this.runSorting(solutionList, 0, nSolutions, nObjectives, 0);
        } else {
            ArrayList<S> defensiveCopy = new ArrayList<S>(solutionList);
            defensiveCopy.sort(this.constraintViolationComparator);
            int rankOffset = 0;
            int lastSpanStart = 0;
            double lastConstraint = this.getConstraint((Solution)defensiveCopy.get(0));
            for (int i = 1; i < nSolutions; ++i) {
                double currConstraint = this.getConstraint((Solution)defensiveCopy.get(i));
                if (lastConstraint == currConstraint) continue;
                lastConstraint = currConstraint;
                rankOffset = 1 + this.runSorting(defensiveCopy, lastSpanStart, i, nObjectives, rankOffset);
                lastSpanStart = i;
            }
            this.runSorting(defensiveCopy, lastSpanStart, nSolutions, nObjectives, rankOffset);
        }
        return this;
    }

    private int runSorting(List<S> solutions, int from, int until, int dimension, int rankOffset) {
        this.ensureEnoughSpace(until - from, dimension);
        double[][] points = new double[until - from][];
        int[] ranks = new int[until - from];
        for (int i = from; i < until; ++i) {
            points[i - from] = ((Solution)solutions.get(i)).objectives();
        }
        this.sortingInstance.sort(points, ranks, until - from);
        int maxRank = 0;
        for (int i = from; i < until; ++i) {
            Solution current = (Solution)solutions.get(i);
            int rank = ranks[i - from] + rankOffset;
            maxRank = Math.max(maxRank, rank);
            current.attributes().put(this.attributeId, rank);
            while (this.subFronts.size() <= rank) {
                this.subFronts.add(new ArrayList());
            }
            this.subFronts.get(rank).add(current);
        }
        return maxRank;
    }

    private void ensureEnoughSpace(int nPoints, int dimension) {
        if (this.sortingInstance == null || this.sortingInstance.getMaximumPoints() < nPoints || this.sortingInstance.getMaximumDimension() < dimension) {
            this.sortingInstance = JensenFortinBuzdalov.getRedBlackTreeSweepHybridENSImplementation(1).getInstance(nPoints, dimension);
        }
    }

    private double getConstraint(S solution) {
        return ConstraintHandling.overallConstraintViolationDegree(solution);
    }

    @Override
    public List<S> getSubFront(int rank) {
        return this.subFronts.get(rank);
    }

    @Override
    public int getNumberOfSubFronts() {
        return this.subFronts.size();
    }

    @Override
    public Integer getRank(S solution) {
        Check.notNull(solution);
        Integer result = -1;
        if (solution.attributes().get(this.attributeId) != null) {
            result = (Integer)solution.attributes().get(this.attributeId);
        }
        return result;
    }

    @Override
    public Object getAttributedId() {
        return this.attributeId;
    }
}

