/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.utilities;

import java.io.IOException;
import java.util.List;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.qualityindicator.QualityIndicatorUtils;
import org.uma.jmetal.qualityindicator.impl.SetCoverage;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.NormalizeUtils;
import org.uma.jmetal.util.VectorUtils;
import org.uma.jmetal.util.errorchecking.JMetalException;

public class CommandLineQualityIndicatorTool {
    public static void main(String[] args) throws Exception {
        CommandLineQualityIndicatorTool.checkArguments(args);
        CommandLineQualityIndicatorTool.calculateAndPrintIndicators(args);
    }

    private static void checkArguments(String[] args) {
        if (args.length != 3) {
            CommandLineQualityIndicatorTool.printAvailableIndicators();
            throw new JMetalException("Invalid arguments");
        }
    }

    private static void printAvailableIndicators() {
        JMetalLogger.logger.info("Parameters: indicatorName referenceFrontFile frontFile \nWhere indicatorValue can be one of these:\nEP   - Additive epsilon\nGD   - Generational distance\nIGD  - Inverted generational distance\nIGD+ - Inverted generational distance plus \nHV   - Hypervolume \nER   - Error ratio \nSP   - Spread (two objectives)\nGSPREAD - Generalized Spread (more than two objectives)\nSC   - Set coverage\n");
    }

    private static void calculateAndPrintIndicators(String[] args) throws IOException {
        double[][] referenceFront = VectorUtils.readVectors(args[1], ",");
        double[][] front = VectorUtils.readVectors(args[2], ",");
        double[][] normalizedReferenceFront = NormalizeUtils.normalize(referenceFront);
        double[][] normalizedFront = NormalizeUtils.normalize(front, NormalizeUtils.getMinValuesOfTheColumnsOfAMatrix(referenceFront), NormalizeUtils.getMaxValuesOfTheColumnsOfAMatrix(referenceFront));
        JMetalLogger.logger.info("The fronts are normalized before computing the indicators");
        List<QualityIndicator> indicatorList = QualityIndicatorUtils.getAvailableIndicators(normalizedReferenceFront);
        if (!args[0].equals("ALL")) {
            QualityIndicator indicator = QualityIndicatorUtils.getIndicatorFromName(args[0], indicatorList);
            JMetalLogger.logger.info(() -> "" + indicator.compute(normalizedFront));
        } else {
            for (QualityIndicator indicator : indicatorList) {
                JMetalLogger.logger.info(() -> indicator.name() + ": " + indicator.compute(normalizedFront));
            }
            SetCoverage sc = new SetCoverage();
            JMetalLogger.logger.info(() -> "SC(refFront, front): " + sc.compute(normalizedReferenceFront, normalizedFront));
            JMetalLogger.logger.info(() -> "SC(front, refFront): " + sc.compute(normalizedFront, normalizedReferenceFront));
        }
    }
}

