/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.utilities;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.uma.jmetal.solution.pointsolution.PointSolution;
import org.uma.jmetal.util.StoredSolutionsUtils;
import org.uma.jmetal.util.archive.impl.NonDominatedSolutionListArchive;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class GenerateReferenceFrontFromFile {
    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            throw new JMetalException("Wrong number of arguments: two file names are required.");
        }
        String inputFileName = args[0];
        String outputFileName = args[1];
        NonDominatedSolutionListArchive<PointSolution> archive = new NonDominatedSolutionListArchive<PointSolution>();
        ArrayList<String> fileNameList = new ArrayList<String>();
        if (Files.isRegularFile(Paths.get(inputFileName, new String[0]), new LinkOption[0])) {
            fileNameList.add(inputFileName);
        } else if (Files.isDirectory(Paths.get(inputFileName, new String[0]), new LinkOption[0])) {
            fileNameList.addAll(Files.list(Paths.get(inputFileName, new String[0])).map(s -> s.toString()).collect(Collectors.toList()));
        } else {
            throw new JMetalException("Error opening file/directory");
        }
        int numberOfObjectives = GenerateReferenceFrontFromFile.determineNumberOfObjectives((String)fileNameList.get(0));
        for (String fileName : fileNameList) {
            System.out.println(fileName);
            archive.addAll(StoredSolutionsUtils.readSolutionsFromFile(fileName, numberOfObjectives));
        }
        StoredSolutionsUtils.writeToOutput(archive.solutions(), new DefaultFileOutputContext(outputFileName));
    }

    private static int determineNumberOfObjectives(String inputFileName) {
        Stream<String> lines;
        try {
            lines = Files.lines(Paths.get(inputFileName, new String[0]), Charset.defaultCharset());
        }
        catch (IOException e2) {
            throw new JMetalException(e2);
        }
        int numberOfObjectives = lines.findFirst().get().split(" ").length;
        lines.close();
        return numberOfObjectives;
    }
}

