/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds;

import java.util.Arrays;
import ru.ifmo.nds.NonDominatedSorting;
import ru.ifmo.nds.NonDominatedSortingFactory;
import ru.ifmo.nds.util.ArrayHelper;
import ru.ifmo.nds.util.DominanceHelper;

public final class DeductiveSort {
    private static final NonDominatedSortingFactory INSTANCE = (n, n2) -> new NonDominatedSorting(n, n2){

        @Override
        public String getName() {
            return "Deductive Sort";
        }

        @Override
        protected void closeImpl() {
        }

        @Override
        protected void sortChecked(double[][] dArray, int[] nArray, int n) {
            int[] nArray2 = this.indices;
            int n2 = dArray.length;
            int n3 = dArray[0].length;
            ArrayHelper.fillIdentity(nArray2, n2);
            Arrays.fill(nArray, n + 1);
            int n4 = 0;
            for (int i = 0; n4 < n2 && i <= n; ++i) {
                int n5 = n4;
                int n6 = n2;
                while (n5 < n6) {
                    int n7 = nArray2[n5];
                    double[] dArray2 = dArray[n7];
                    int n8 = n5 + 1;
                    boolean bl = false;
                    while (n8 < n6) {
                        int n9 = nArray2[n8];
                        int n10 = DominanceHelper.dominanceComparison(dArray2, dArray[n9], n3);
                        if (n10 < 0) {
                            nArray2[n8] = nArray2[--n6];
                            nArray2[n6] = n9;
                            continue;
                        }
                        if (n10 > 0) {
                            bl = true;
                            nArray2[n5] = nArray2[--n6];
                            nArray2[n6] = n7;
                            break;
                        }
                        ++n8;
                    }
                    if (bl) continue;
                    nArray[n7] = i;
                    ++n5;
                }
                n4 = n6;
            }
        }
    };

    private DeductiveSort() {
    }

    public static NonDominatedSortingFactory getInstance() {
        return INSTANCE;
    }
}

