/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds;

import java.util.Arrays;
import ru.ifmo.nds.NonDominatedSorting;
import ru.ifmo.nds.NonDominatedSortingFactory;
import ru.ifmo.nds.util.ArrayHelper;
import ru.ifmo.nds.util.ArraySorter;
import ru.ifmo.nds.util.DominanceHelper;

public final class FilterSort {
    private static final NonDominatedSortingFactory INSTANCE = (n, n2) -> new NonDominatedSorting(n, n2){
        private double[][] points;
        private int[][] orderByObjective;
        private int[][] indexInObjective;
        private int[] bestObjective;
        private int[] worstObjective;
        private int[] ranks;
        private int[] sumOfIndices;
        private int[] orderBySumOfIndices;
        private int[] startOrderByObjective;
        private boolean[] alive;
        private boolean[] isCandidate;
        private int[] candidates;
        {
            super(n5, n22);
            this.points = new double[n][];
            this.orderByObjective = new int[n2][n];
            this.indexInObjective = new int[n2][];
            this.bestObjective = new int[n];
            this.worstObjective = new int[n];
            this.ranks = new int[n];
            this.sumOfIndices = new int[n];
            this.orderBySumOfIndices = new int[n];
            this.startOrderByObjective = new int[n2];
            this.alive = new boolean[n];
            this.isCandidate = new boolean[n];
            this.candidates = new int[n];
            if (n2 > 0) {
                this.indexInObjective[0] = this.orderByObjective[0];
                for (int i = 1; i < n2; ++i) {
                    this.indexInObjective[i] = new int[n];
                }
            }
        }

        @Override
        public String getName() {
            return "Filter Sort";
        }

        @Override
        protected void closeImpl() {
            this.points = null;
            this.orderByObjective = null;
            this.indexInObjective = null;
            this.bestObjective = null;
            this.worstObjective = null;
            this.ranks = null;
            this.sumOfIndices = null;
            this.orderBySumOfIndices = null;
            this.alive = null;
            this.isCandidate = null;
            this.candidates = null;
        }

        private void initializeObjectiveIndices(int n6, int n22) {
            Arrays.fill(this.bestObjective, 0, n6, 0);
            Arrays.fill(this.worstObjective, 0, n6, 0);
            ArrayHelper.fillIdentity(this.sumOfIndices, n6);
            ArrayHelper.fillIdentity(this.orderByObjective[0], n6);
            for (int i = 1; i < n22; ++i) {
                int n3;
                int[] nArray = this.orderByObjective[i];
                ArrayHelper.fillIdentity(nArray, n6);
                this.sorter.sortComparingByIndicesIfEqual(this.points, nArray, 0, n6, i);
                int[] nArray2 = this.indexInObjective[i];
                for (n3 = 0; n3 < n6; ++n3) {
                    nArray2[nArray[n3]] = n3;
                }
                n3 = 0;
                while (n3 < n6) {
                    int n4 = nArray2[n3];
                    if (n4 < this.indexInObjective[this.bestObjective[n3]][n3]) {
                        this.bestObjective[n3] = i;
                    }
                    if (n4 > this.indexInObjective[this.worstObjective[n3]][n3]) {
                        this.worstObjective[n3] = i;
                    }
                    int n5 = n3++;
                    this.sumOfIndices[n5] = this.sumOfIndices[n5] + n4;
                }
            }
            ArrayHelper.fillIdentity(this.orderBySumOfIndices, n6);
            ArraySorter.sortIndicesByValues(this.orderBySumOfIndices, this.sumOfIndices, 0, n6);
        }

        private int populateCandidates(int n8, int n22, int n3) {
            int n4 = this.startOrderByObjective[n22];
            int[] nArray = this.orderByObjective[n22];
            int n5 = n4;
            while (nArray[n5] != n8) {
                ++n5;
            }
            int n6 = n5;
            while (--n5 >= n4) {
                int n7 = nArray[n5];
                if (!this.alive[n7]) continue;
                if (!this.isCandidate[n7]) {
                    this.isCandidate[n7] = true;
                    this.candidates[n3] = n7;
                    ++n3;
                }
                nArray[--n6] = n7;
            }
            this.startOrderByObjective[n22] = n6;
            return n3;
        }

        private boolean isCandidateGood(int n7, int n22) {
            int n3;
            double[] dArray = this.points[n7];
            int n4 = this.worstObjective[n7];
            double d2 = dArray[n4];
            int n5 = this.bestObjective[n7];
            int[] nArray = this.orderByObjective[n5];
            int n6 = this.startOrderByObjective[n5];
            while ((n3 = nArray[n6]) != n7) {
                double[] dArray2;
                if (this.alive[n3] && (dArray2 = this.points[n3])[n4] <= d2 && DominanceHelper.strictlyDominatesAssumingNotEqual(dArray2, dArray, n22)) {
                    return false;
                }
                ++n6;
            }
            return true;
        }

        private void runSorting(int n10, int n22, int n3) {
            Arrays.fill(this.alive, 0, n10, true);
            Arrays.fill(this.ranks, n3 + 1);
            int n4 = n10;
            int n5 = 0;
            Arrays.fill(this.startOrderByObjective, 0, n22 + 1, 0);
            for (int i = 0; i <= n3 && n4 > 0; ++i) {
                int n6;
                int n7;
                int n8;
                do {
                    n8 = this.orderBySumOfIndices[n5];
                    ++n5;
                } while (!this.alive[n8]);
                this.ranks[n8] = i;
                this.alive[n8] = false;
                if (--n4 == 0) break;
                int n9 = 0;
                for (n7 = 0; n7 <= n22; ++n7) {
                    n9 = this.populateCandidates(n8, n7, n9);
                }
                for (n7 = 0; n7 < n9; ++n7) {
                    n6 = this.candidates[n7];
                    this.isCandidate[n6] = false;
                    if (!this.isCandidateGood(n6, n22)) continue;
                    this.ranks[n6] = i;
                }
                for (n7 = 0; n7 < n9; ++n7) {
                    n6 = this.candidates[n7];
                    if (this.ranks[n6] != i) continue;
                    this.alive[n6] = false;
                    --n4;
                }
            }
        }

        @Override
        protected void sortChecked(double[][] dArray, int[] nArray, int n5) {
            int n22 = dArray.length;
            int n3 = dArray[0].length;
            ArrayHelper.fillIdentity(this.indices, n22);
            this.sorter.lexicographicalSort(dArray, this.indices, 0, n22, n3);
            int n4 = ArraySorter.retainUniquePoints(dArray, this.indices, this.points, nArray);
            this.initializeObjectiveIndices(n4, n3);
            this.runSorting(n4, n3 - 1, n5);
            for (int i = 0; i < n22; ++i) {
                nArray[i] = this.ranks[nArray[i]];
                this.points[i] = null;
            }
        }
    };

    private FilterSort() {
    }

    public static NonDominatedSortingFactory getInstance() {
        return INSTANCE;
    }
}

