/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds.bos;

import java.util.Arrays;
import ru.ifmo.nds.NonDominatedSorting;
import ru.ifmo.nds.util.ArrayHelper;
import ru.ifmo.nds.util.ArraySorter;
import ru.ifmo.nds.util.DominanceHelper;

public class Improved
extends NonDominatedSorting {
    private int[][] objectiveIndices;
    private double[][] points;
    private int[] ranks;
    private int[][] lastFrontIndex;
    private int[][] prevFrontIndex;
    private int[] indexNeededCount;

    public Improved(int n, int n2) {
        super(n, n2);
        this.objectiveIndices = new int[n2][n];
        this.lastFrontIndex = new int[n2][n];
        this.prevFrontIndex = new int[n2][n];
        this.indexNeededCount = new int[n];
        this.points = new double[n][];
        this.ranks = new int[n];
    }

    @Override
    public String getName() {
        return "Best Order Sort (improved implementation)";
    }

    @Override
    protected void closeImpl() {
        this.objectiveIndices = null;
        this.lastFrontIndex = null;
        this.prevFrontIndex = null;
        this.indexNeededCount = null;
        this.points = null;
        this.ranks = null;
    }

    private void initializeObjectiveIndices(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            int[] nArray = this.objectiveIndices[i];
            ArrayHelper.fillIdentity(nArray, n);
            if (i <= 0) continue;
            this.sorter.sortComparingByIndicesIfEqual(this.points, nArray, 0, n, i);
        }
    }

    private void rankPoint(int n, int[] nArray, int[] nArray2, int n2, int n3) {
        int n4;
        double[] dArray = this.points[n];
        int n5 = dArray.length - 1;
        for (n4 = n2; n4 <= n3; ++n4) {
            int n6 = nArray2[n4];
            boolean bl = false;
            while (n6 != -1) {
                if (n6 < n && DominanceHelper.strictlyDominatesAssumingLexicographicallySmaller(this.points[n6], dArray, n5)) {
                    bl = true;
                    break;
                }
                n6 = nArray[n6];
            }
            if (!bl) break;
        }
        this.ranks[n] = n4;
    }

    @Override
    protected void sortChecked(double[][] dArray, int[] nArray, int n) {
        int n2;
        int n3;
        int n4 = nArray.length;
        int n5 = dArray[0].length;
        ArrayHelper.fillIdentity(this.indices, n4);
        this.sorter.lexicographicalSort(dArray, this.indices, 0, n4, n5);
        int n6 = ArraySorter.retainUniquePoints(dArray, this.indices, this.points, nArray);
        this.initializeObjectiveIndices(n6, n5);
        n = Math.min(n, n6 - 1);
        Arrays.fill(this.ranks, 0, n6, -1);
        Arrays.fill(this.indexNeededCount, 0, n6, n5);
        for (n3 = 0; n3 < n5; ++n3) {
            Arrays.fill(this.lastFrontIndex[n3], 0, n6, -1);
            Arrays.fill(this.prevFrontIndex[n3], 0, n6, -1);
        }
        n3 = 0;
        int n7 = 0;
        block1: for (n2 = 0; n2 < n6 && n3 <= n && n7 < n6; ++n2) {
            for (int i = 0; i < n5; ++i) {
                int n8;
                int n9 = this.objectiveIndices[i][n2];
                int[] nArray2 = this.prevFrontIndex[i];
                int[] nArray3 = this.lastFrontIndex[i];
                if (this.ranks[n9] == -1) {
                    this.rankPoint(n9, nArray2, nArray3, n3, n);
                    ++n7;
                }
                if ((n8 = this.ranks[n9]) <= n) {
                    nArray2[n9] = nArray3[n8];
                    nArray3[n8] = n9;
                }
                int n10 = n9;
                this.indexNeededCount[n10] = this.indexNeededCount[n10] - 1;
                if (this.indexNeededCount[n10] == 0 && n3 <= n8 && (n3 = n8 + 1) > n) continue block1;
            }
        }
        if (n3 > n) {
            for (n2 = 0; n2 < n6; ++n2) {
                if (this.ranks[n2] != -1) continue;
                this.ranks[n2] = n + 1;
            }
        }
        Arrays.fill((Object[])this.points, 0, n4, null);
        for (n2 = 0; n2 < n4; ++n2) {
            nArray[n2] = this.ranks[nArray[n2]];
        }
    }
}

