/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds.dcns;

import ru.ifmo.nds.NonDominatedSorting;
import ru.ifmo.nds.util.ArrayHelper;
import ru.ifmo.nds.util.ArraySorter;
import ru.ifmo.nds.util.DominanceHelper;
import ru.ifmo.nds.util.MathEx;

public abstract class DCNSBase
extends NonDominatedSorting {
    private double[][] points;
    private int[] next;
    private int[] firstIndex;
    private int[] ranks;
    private int[] parents;
    private int[] temp;

    DCNSBase(int n, int n2) {
        super(n, n2);
        this.points = new double[n][];
        this.next = new int[n];
        this.firstIndex = new int[n];
        this.ranks = new int[n];
        this.parents = new int[n];
        this.temp = new int[n];
    }

    @Override
    protected void closeImpl() {
        this.points = null;
        this.next = null;
        this.firstIndex = null;
        this.ranks = null;
        this.parents = null;
        this.temp = null;
    }

    final boolean checkIfDoesNotDominate(int n, int n2) {
        int n3 = this.firstIndex[n];
        double[] dArray = this.points[n2];
        int n4 = dArray.length - 1;
        while (n3 != -1) {
            if (DominanceHelper.strictlyDominatesAssumingNotEqual(this.points[n3], dArray, n4)) {
                this.parents[n2] = n3;
                return false;
            }
            n3 = this.next[n3];
        }
        return true;
    }

    abstract int findRank(int var1, int var2, int var3);

    private int writeOutAndFindRanksWithoutParentChecking(int n, int n2, int n3, int n4) {
        int n5 = n;
        while (n5 != -1) {
            this.ranks[n5] = this.findRank(n3, n4, n5);
            this.temp[n2] = n5;
            n5 = this.next[n5];
            ++n2;
        }
        return n2;
    }

    private int writeOutAndFindRanksWithParentChecking(int n, int n2, int n3) {
        int n4 = n;
        while (n4 != -1) {
            int n5 = this.ranks[this.parents[n4]] + 1;
            this.ranks[n4] = n5 == n3 ? n5 : this.findRank(n5, n3, n4);
            this.temp[n2] = n4;
            n4 = this.next[n4];
            ++n2;
        }
        return n2;
    }

    private int putToFronts(int n, int n2, int n3) {
        boolean bl = false;
        boolean bl2 = true;
        while (--n >= n2) {
            int n4 = this.temp[n];
            int n5 = this.ranks[n4];
            int n6 = n3 - n5;
            if (n6 == 0) {
                bl = true;
                this.next[n4] = -1;
                ++n3;
            } else {
                bl2 &= bl && n6 == 1;
                this.next[n4] = this.firstIndex[n5];
            }
            this.firstIndex[n5] = n4;
        }
        return (bl ? 1 : 0) ^ (bl2 ? 2 : 0);
    }

    private void merge(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = Math.min(n3, n2 + n2 - n);
        for (n5 = n; n5 < n2 && this.firstIndex[n5] != -1; ++n5) {
        }
        int n7 = n2;
        int n8 = this.firstIndex[n7];
        int n9 = this.writeOutAndFindRanksWithoutParentChecking(n8, n2, n, n5);
        int n10 = this.putToFronts(n9, n2, n5);
        n5 += n10 & 1;
        ++n7;
        if (n10 <= 1) {
            while (n7 < n6 && (n8 = this.firstIndex[n7]) != -1) {
                n4 = this.writeOutAndFindRanksWithParentChecking(n8, n2, n5);
                int n11 = this.putToFronts(n4, n2, n5);
                n5 += n11 & 1;
                ++n7;
                if (n11 <= 1) continue;
                break;
            }
        }
        if (n7 == n5) {
            while (n7 < n6 && this.firstIndex[n7] != -1) {
                ++n7;
                ++n5;
            }
        } else {
            while (n7 < n6 && (n8 = this.firstIndex[n7]) != -1) {
                this.firstIndex[n5] = n8;
                n4 = n8;
                while (n4 != -1) {
                    this.ranks[n4] = n5;
                    n4 = this.next[n4];
                }
                ++n7;
                ++n5;
            }
        }
        if (n5 < n6) {
            this.firstIndex[n5] = -1;
        }
    }

    private void merge0(int n, int n2) {
        for (int i = 1; i < n; i += 2) {
            int n3 = i - 1;
            if (DominanceHelper.strictlyDominatesAssumingLexicographicallySmaller(this.points[n3], this.points[i], n2)) {
                this.parents[i] = n3;
                continue;
            }
            this.next[i] = n3;
            this.firstIndex[n3] = i;
            this.firstIndex[i] = -1;
            this.ranks[i] = n3;
        }
    }

    @Override
    protected void sortChecked(double[][] dArray, int[] nArray, int n) {
        int n2;
        int n3;
        int n4 = dArray.length;
        int n5 = dArray[0].length - 1;
        ArrayHelper.fillIdentity(this.indices, n4);
        this.sorter.lexicographicalSort(dArray, this.indices, 0, n4, n5 + 1);
        int n6 = ArraySorter.retainUniquePoints(dArray, this.indices, this.points, nArray);
        for (n3 = 0; n3 < n6; ++n3) {
            this.ranks[n3] = n3;
            this.firstIndex[n3] = n3;
            this.next[n3] = -1;
            this.parents[n3] = -1;
        }
        n3 = MathEx.log2up(n6);
        this.merge0(n6, n5);
        for (n2 = 1; n2 < n3; ++n2) {
            int n7 = 1 << n2;
            int n8 = n7 + n7;
            for (int i = n7; i < n6; i += n8) {
                this.merge(i - n7, i, n6);
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            nArray[n2] = this.ranks[nArray[n2]];
            this.points[n2] = null;
        }
    }
}

