/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds.ndt;

import java.util.Arrays;
import ru.ifmo.nds.NonDominatedSorting;
import ru.ifmo.nds.ndt.Split;
import ru.ifmo.nds.ndt.SplitBuilder;
import ru.ifmo.nds.util.ArrayHelper;
import ru.ifmo.nds.util.ArraySorter;
import ru.ifmo.nds.util.DominanceHelper;

public class ENS_NDT_Arrays
extends NonDominatedSorting {
    private SplitBuilder splitBuilder;
    private int[] ranks;
    private double[][] transposedPoints;
    private double[][] points;
    private int[] nodeArray;
    private int nNodes;

    public ENS_NDT_Arrays(int n, int n2) {
        super(n, n2);
        this.ranks = new int[n];
        this.transposedPoints = new double[n2][];
        for (int i = 1; i < n2; ++i) {
            this.transposedPoints[i] = new double[n];
        }
        this.splitBuilder = new SplitBuilder(this.transposedPoints, n, 2);
        this.points = new double[n][];
        this.nodeArray = new int[n * 6];
    }

    @Override
    public String getName() {
        return "ENS-NDT (Arrays)";
    }

    @Override
    protected void closeImpl() {
        this.splitBuilder = null;
        this.ranks = null;
        this.transposedPoints = null;
        this.points = null;
        this.nodeArray = null;
    }

    private void add(int n, int n2, Split split) {
        double[] dArray = this.points[n2];
        while (true) {
            int n3 = this.nodeArray[n];
            int n4 = this.nodeArray[n + 1];
            if (n3 >= 0) {
                if (n3 == 0) {
                    this.nodeArray[n] = n2 + 1;
                    break;
                }
                if (n4 == 0) {
                    this.nodeArray[n + 1] = n2 + 1;
                    break;
                }
                int n5 = 2 * this.nNodes;
                int n6 = 2 * ++this.nNodes;
                ++this.nNodes;
                this.nodeArray[n5] = 0;
                this.nodeArray[n5 + 1] = 0;
                this.nodeArray[n6] = 0;
                this.nodeArray[n6 + 1] = 0;
                int n7 = split.coordinate;
                double d2 = split.value;
                if (this.points[--n3][n7] < d2) {
                    this.add(n5, n3, split.good);
                } else {
                    this.add(n6, n3, split.weak);
                }
                --n4;
                if (this.points[n4][n7] < d2) {
                    this.add(n5, n4, split.good);
                } else {
                    this.add(n6, n4, split.weak);
                }
                this.nodeArray[n] = -n5 - 1;
                this.nodeArray[n + 1] = -n6 - 1;
                if (dArray[n7] < d2) {
                    n = n5;
                    split = split.good;
                    continue;
                }
                n = n6;
                split = split.weak;
                continue;
            }
            if (dArray[split.coordinate] < split.value) {
                n = -n3 - 1;
                split = split.good;
                continue;
            }
            n = -n4 - 1;
            split = split.weak;
        }
    }

    private boolean dominates(int n, double[] dArray, Split split) {
        int n2 = this.nodeArray[n];
        int n3 = this.nodeArray[n + 1];
        if (n2 < 0) {
            return this.dominates(-n2 - 1, dArray, split.good) || dArray[split.coordinate] >= split.value && this.dominates(-n3 - 1, dArray, split.weak);
        }
        if (n2 == 0) {
            return false;
        }
        int n4 = dArray.length - 1;
        if (DominanceHelper.strictlyDominatesAssumingLexicographicallySmaller(this.points[n2 - 1], dArray, n4)) {
            return true;
        }
        return n3 > 0 && DominanceHelper.strictlyDominatesAssumingLexicographicallySmaller(this.points[n3 - 1], dArray, n4);
    }

    @Override
    protected void sortChecked(double[][] dArray, int[] nArray, int n) {
        int n2;
        int n3;
        int n4 = dArray.length;
        int n5 = dArray[0].length;
        ArrayHelper.fillIdentity(this.indices, n4);
        this.sorter.lexicographicalSort(dArray, this.indices, 0, n4, n5);
        int n6 = ArraySorter.retainUniquePoints(dArray, this.indices, this.points, nArray);
        Arrays.fill(this.ranks, 0, n6, 0);
        Arrays.fill(this.nodeArray, 0, 2 * n6, 0);
        for (int i = 0; i < n6; ++i) {
            for (n3 = 1; n3 < n5; ++n3) {
                this.transposedPoints[n3][i] = this.points[i][n3];
            }
        }
        Split split = this.splitBuilder.result(n6, n5);
        n3 = 1;
        this.nNodes = n6;
        this.add(0, 0, split);
        for (n2 = 1; n2 < n6; ++n2) {
            double[] dArray2 = this.points[n2];
            if (this.dominates(0, dArray2, split)) {
                int n7;
                int n8 = 0;
                int n9 = n3;
                while (n9 - n8 > 1) {
                    n7 = n8 + n9 >>> 1;
                    if (this.dominates(n7 << 1, dArray2, split)) {
                        n8 = n7;
                        continue;
                    }
                    n9 = n7;
                }
                this.ranks[n2] = n7 = n8 + 1;
                if (n7 > n) continue;
                this.add(n7 << 1, n2, split);
                if (n7 != n3) continue;
                ++n3;
                continue;
            }
            this.add(0, n2, split);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            nArray[n2] = this.ranks[nArray[n2]];
            this.points[n2] = null;
        }
    }
}

