/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds.ndt;

import ru.ifmo.nds.ndt.Split;
import ru.ifmo.nds.util.DominanceHelper;

public abstract class TreeRankNode {
    public static final TreeRankNode EMPTY = new EmptyRankNode();
    public static final TreeRankNode EMPTY_1 = new EmptyRankNode1();

    public abstract TreeRankNode add(double[] var1, int var2, Split var3, int var4);

    public abstract int evaluateRank(double[] var1, int var2, Split var3, int var4);

    private static class BranchingRankNode
    extends TreeRankNode {
        private TreeRankNode good;
        private TreeRankNode weak;
        private int maxRank;

        private BranchingRankNode(TreeRankNode treeRankNode, TreeRankNode treeRankNode2, int n) {
            this.weak = treeRankNode2;
            this.good = treeRankNode;
            this.maxRank = n;
        }

        @Override
        public TreeRankNode add(double[] dArray, int n, Split split, int n2) {
            this.maxRank = Math.max(n, this.maxRank);
            if (dArray[split.coordinate] >= split.value) {
                this.weak = this.weak.add(dArray, n, split.weak, n2);
            } else {
                this.good = this.good.add(dArray, n, split.good, n2);
            }
            return this;
        }

        @Override
        public int evaluateRank(double[] dArray, int n, Split split, int n2) {
            if (this.maxRank < n) {
                return n;
            }
            if (this.weak != null && dArray[split.coordinate] >= split.value) {
                n = this.weak.evaluateRank(dArray, n, split.weak, n2);
            }
            if (this.good != null) {
                n = this.good.evaluateRank(dArray, n, split.good, n2);
            }
            return n;
        }
    }

    private static class TerminalRankNode1
    extends TreeRankNode {
        private double[] point = null;
        private int rank = -1;

        private TerminalRankNode1() {
        }

        @Override
        public TreeRankNode add(double[] dArray, int n, Split split, int n2) {
            if (split == Split.NULL_MAX_DEPTH) {
                this.point = dArray;
                this.rank = Math.max(this.rank, n);
                return this;
            }
            if (this.point != null) {
                int n3 = this.rank;
                TerminalRankNode1 terminalRankNode1 = new TerminalRankNode1();
                Split split2 = split.good;
                int n4 = split.coordinate;
                double d2 = split.value;
                if (this.point[n4] < d2) {
                    terminalRankNode1.add(this.point, this.rank, split2, n2);
                    this.point = null;
                    this.rank = -1;
                }
                return new BranchingRankNode(terminalRankNode1, this, n3).add(dArray, n, split, n2);
            }
            this.point = dArray;
            this.rank = n;
            return this;
        }

        @Override
        public int evaluateRank(double[] dArray, int n, Split split, int n2) {
            if (this.rank >= n && DominanceHelper.strictlyDominatesAssumingLexicographicallySmaller(this.point, dArray, n2)) {
                return this.rank + 1;
            }
            return n;
        }
    }

    private static class TerminalRankNode
    extends TreeRankNode {
        private int size = 0;
        private double[][] points = null;
        private int[] ranks = null;
        int maxRank;

        private TerminalRankNode() {
        }

        @Override
        public TreeRankNode add(double[] dArray, int n, Split split, int n2) {
            if (split == Split.NULL_MAX_DEPTH) {
                if (this.points == null) {
                    this.points = new double[1][];
                    this.ranks = new int[1];
                }
                this.points[0] = dArray;
                this.ranks[0] = this.maxRank = Math.max(this.maxRank, n);
                this.size = 1;
                return this;
            }
            if (this.points == null) {
                this.points = new double[n2][];
                this.ranks = new int[n2];
            }
            if (this.size == this.points.length) {
                int n3 = this.maxRank;
                TerminalRankNode terminalRankNode = new TerminalRankNode();
                Split split2 = split.weak;
                Split split3 = split.good;
                int n4 = split.coordinate;
                double d2 = split.value;
                int n5 = this.size;
                this.maxRank = 0;
                this.size = 0;
                if (split2 == Split.NULL_MAX_DEPTH) {
                    double[] dArray2 = null;
                    for (int i = 0; i < n5; ++i) {
                        double[] dArray3 = this.points[i];
                        int n6 = this.ranks[i];
                        this.points[i] = null;
                        if (dArray3[n4] < d2) {
                            terminalRankNode.add(dArray3, n6, split3, n2);
                            continue;
                        }
                        this.size = 1;
                        dArray2 = dArray3;
                        this.maxRank = Math.max(this.maxRank, n6);
                    }
                    this.points[0] = dArray2;
                    this.ranks[0] = this.maxRank;
                } else {
                    for (int i = 0; i < n5; ++i) {
                        double[] dArray4 = this.points[i];
                        int n7 = this.ranks[i];
                        this.points[i] = null;
                        if (dArray4[n4] < d2) {
                            terminalRankNode.add(dArray4, n7, split3, n2);
                            continue;
                        }
                        this.points[this.size] = dArray4;
                        this.ranks[this.size] = n7;
                        this.maxRank = Math.max(this.maxRank, n7);
                        ++this.size;
                    }
                }
                return new BranchingRankNode(terminalRankNode, this, n3).add(dArray, n, split, n2);
            }
            for (int i = this.size; i >= 0; --i) {
                if (i == 0 || this.ranks[i - 1] <= n) {
                    this.points[i] = dArray;
                    this.ranks[i] = n;
                    break;
                }
                this.points[i] = this.points[i - 1];
                this.ranks[i] = this.ranks[i - 1];
            }
            ++this.size;
            this.maxRank = Math.max(this.maxRank, n);
            return this;
        }

        @Override
        public int evaluateRank(double[] dArray, int n, Split split, int n2) {
            if (this.maxRank < n) {
                return n;
            }
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.ranks[i] < n) {
                    return n;
                }
                if (!DominanceHelper.strictlyDominatesAssumingLexicographicallySmaller(this.points[i], dArray, n2)) continue;
                return this.ranks[i] + 1;
            }
            return n;
        }
    }

    private static class EmptyRankNode1
    extends TreeRankNode {
        private EmptyRankNode1() {
        }

        @Override
        public TreeRankNode add(double[] dArray, int n, Split split, int n2) {
            return new TerminalRankNode1().add(dArray, n, split, n2);
        }

        @Override
        public int evaluateRank(double[] dArray, int n, Split split, int n2) {
            return n;
        }
    }

    private static class EmptyRankNode
    extends TreeRankNode {
        private EmptyRankNode() {
        }

        @Override
        public TreeRankNode add(double[] dArray, int n, Split split, int n2) {
            return new TerminalRankNode().add(dArray, n, split, n2);
        }

        @Override
        public int evaluateRank(double[] dArray, int n, Split split, int n2) {
            return n;
        }
    }
}

