/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds.util;

import java.util.Arrays;
import ru.ifmo.nds.util.ArrayHelper;

public final class ArraySorter {
    private final double[] scratch;
    private double[][] points = null;
    private int[] indices = null;
    private int coordinate = -1;
    private int maxCoordinate = -1;
    private static final int INDICES_BY_VALUES_INSERTION_THRESHOLD = 47;
    private static final int INDICES_BY_VALUES_INSERTION_THRESHOLD_ENTRY = 160;
    private static final int INSERTION_LEX_SORT_THRESHOLD = 42;

    public ArraySorter(int n) {
        this.scratch = new double[n];
    }

    private static long split(double[] dArray, int[] nArray, int n, int n2) {
        double d2 = dArray[n + n2 >>> 1];
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            double d3;
            double d4;
            while (true) {
                double d5;
                d4 = dArray[n3];
                if (!(d5 < d2)) break;
                ++n3;
            }
            while (true) {
                double d6;
                d3 = dArray[n4];
                if (!(d6 > d2)) break;
                --n4;
            }
            if (n3 > n4) continue;
            ArrayHelper.swap(nArray, n3, n4);
            dArray[n3] = d3;
            dArray[n4] = d4;
            ++n3;
            --n4;
        }
        return (long)n4 << 32 ^ (long)n3;
    }

    private static void insertionSort(double[] dArray, int[] nArray, int n, int n2) {
        int n3;
        int n4 = n2 - 1;
        int n5 = n3 = n;
        while (n3 < n4) {
            double d2 = dArray[++n3];
            int n6 = nArray[n3];
            do {
                double d3;
                double d4 = dArray[n5];
                if (!(d2 < d3)) break;
                dArray[n5 + 1] = d4;
                nArray[n5 + 1] = nArray[n5];
            } while (--n5 >= n);
            dArray[++n5] = d2;
            nArray[n5] = n6;
            n5 = n3;
        }
    }

    private void sortImplInside(int n, int n2) {
        if (n + 42 >= n2) {
            ArraySorter.insertionSort(this.scratch, this.indices, n, n2);
        } else {
            long l = ArraySorter.split(this.scratch, this.indices, n, n2);
            int n3 = (int)l;
            int n4 = (int)(l >> 32);
            if (n < n4) {
                this.sortImplInside(n, n4 + 1);
            }
            if (n3 + 1 < n2) {
                this.sortImplInside(n3, n2);
            }
        }
    }

    private void sortImpl(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            this.scratch[i] = this.points[this.indices[i]][this.coordinate];
        }
        this.sortImplInside(n, n2);
    }

    private void lexSortImpl(int n, int n2, int n3) {
        this.coordinate = n3;
        this.sortImpl(n, n2);
        if (n3 + 1 < this.maxCoordinate) {
            int n4 = n;
            double d2 = this.scratch[n];
            for (int i = n + 1; i < n2; ++i) {
                double d3 = this.scratch[i];
                if (d3 == d2) continue;
                if (n4 + 1 < i) {
                    this.lexSortImpl(n4, i, n3 + 1);
                }
                n4 = i;
                d2 = d3;
            }
            if (n4 + 1 < n2) {
                this.lexSortImpl(n4, n2, n3 + 1);
            }
        }
    }

    private void checkSize(int n, int n2) {
        if (n2 > this.scratch.length) {
            throw new IllegalArgumentException("The internal scratch array length is " + this.scratch.length + ", but you requested from = " + n + " until = " + n2 + " which is " + (n2 - n));
        }
    }

    public void compressCoordinates(double[] dArray, int[] nArray, int[] nArray2, int n, int n2) {
        this.checkSize(n, n2);
        System.arraycopy(dArray, n, this.scratch, n, n2 - n);
        for (int i = n; i < n2; ++i) {
            nArray[i] = i;
        }
        this.indices = nArray;
        this.sortImplInside(n, n2);
        this.indices = null;
        double d2 = Double.NaN;
        int n3 = -1;
        for (int i = n; i < n2; ++i) {
            int n4 = nArray[i];
            double d3 = this.scratch[i];
            if (d2 != d3) {
                d2 = d3;
            }
            nArray2[n4] = ++n3;
        }
    }

    public void sort(double[][] dArray, int[] nArray, int n, int n2, int n3) {
        this.checkSize(n, n2);
        this.points = dArray;
        this.indices = nArray;
        this.coordinate = n3;
        this.sortImpl(n, n2);
        this.points = null;
        this.indices = null;
        this.coordinate = -1;
    }

    public void lexicographicalSort(double[][] dArray, int[] nArray, int n, int n2, int n3) {
        this.checkSize(n, n2);
        this.points = dArray;
        this.indices = nArray;
        this.maxCoordinate = n3;
        this.lexSortImpl(n, n2, 0);
        this.points = null;
        this.indices = null;
        this.maxCoordinate = -1;
    }

    private void sortComparingByIndicesIfEqualImpl(int n, int n2) {
        this.sortImpl(n, n2);
        int n3 = n;
        double d2 = this.scratch[n];
        for (int i = n + 1; i < n2; ++i) {
            double d3 = this.scratch[i];
            if (d3 == d2) continue;
            if (n3 + 1 < i) {
                Arrays.sort(this.indices, n3, i);
            }
            n3 = i;
            d2 = d3;
        }
        if (n3 + 1 < n2) {
            Arrays.sort(this.indices, n3, n2);
        }
    }

    public void sortComparingByIndicesIfEqual(double[][] dArray, int[] nArray, int n, int n2, int n3) {
        this.checkSize(n, n2);
        this.points = dArray;
        this.indices = nArray;
        this.coordinate = n3;
        this.sortComparingByIndicesIfEqualImpl(n, n2);
        this.points = null;
        this.indices = null;
        this.coordinate = -1;
    }

    public static int retainUniquePoints(double[][] dArray, int[] nArray, double[][] dArray2, int[] nArray2) {
        int n = 1;
        int n2 = 0;
        int n3 = nArray[0];
        double[] dArray3 = dArray[n3];
        dArray2[0] = dArray3;
        int n4 = dArray3.length;
        nArray2[n3] = n2;
        int n5 = dArray.length;
        for (int i = 1; i < n5; ++i) {
            int n6 = nArray[i];
            double[] dArray4 = dArray[n6];
            if (!ArrayHelper.equal(dArray3, dArray4, n4)) {
                dArray2[n] = dArray4;
                dArray3 = dArray4;
                n2 = n++;
            }
            nArray2[n6] = n2;
        }
        return n;
    }

    private static long splitIndicesByRanks(int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = n;
        int n4 = n2 - 1;
        int n5 = nArray2[nArray[n + n2 >>> 1]];
        while (n3 <= n4) {
            int n6;
            int n7;
            while (nArray2[n7 = nArray[n3]] < n5) {
                ++n3;
            }
            while (nArray2[n6 = nArray[n4]] > n5) {
                --n4;
            }
            if (n3 > n4) continue;
            nArray[n3] = n6;
            nArray[n4] = n7;
            ++n3;
            --n4;
        }
        return (long)n4 << 32 ^ (long)n3;
    }

    private static void insertionSortIndicesByValues(int[] nArray, int[] nArray2, int n, int n2) {
        int n3;
        int n4 = n3 = n;
        while (n3 < n2) {
            int n5;
            int n6 = nArray[++n3];
            int n7 = nArray2[n6];
            while (n7 < nArray2[n5 = nArray[n4]]) {
                nArray[n4 + 1] = n5;
                if (--n4 >= n) continue;
            }
            nArray[n4 + 1] = n6;
            n4 = n3;
        }
    }

    private static void sortIndicesByValuesImpl(int[] nArray, int[] nArray2, int n, int n2) {
        if (n + 47 > n2) {
            ArraySorter.insertionSortIndicesByValues(nArray, nArray2, n, n2 - 1);
        } else {
            long l = ArraySorter.splitIndicesByRanks(nArray, nArray2, n, n2);
            int n3 = (int)l;
            int n4 = (int)(l >> 32);
            if (n < n4) {
                ArraySorter.sortIndicesByValuesImpl(nArray, nArray2, n, n4 + 1);
            }
            if (n3 + 1 < n2) {
                ArraySorter.sortIndicesByValuesImpl(nArray, nArray2, n3, n2);
            }
        }
    }

    public static void sortIndicesByValues(int[] nArray, int[] nArray2, int n, int n2) {
        if (n + 160 > n2) {
            ArraySorter.insertionSortIndicesByValues(nArray, nArray2, n, n2 - 1);
        } else {
            ArraySorter.sortIndicesByValuesImpl(nArray, nArray2, n, n2);
        }
    }
}

