/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds.util;

import java.util.Arrays;
import ru.ifmo.nds.util.RankQueryStructureInt;

public final class FenwickRankQueryStructureInt
extends RankQueryStructureInt {
    private final int[] keys;
    private final int[] values;

    public FenwickRankQueryStructureInt(int n) {
        this.keys = new int[n];
        this.values = new int[n];
    }

    @Override
    public String getName() {
        return "Fenwick Tree for compressed coordinates";
    }

    @Override
    public int maximumPoints() {
        return this.keys.length;
    }

    @Override
    public boolean supportsMultipleThreads() {
        return true;
    }

    @Override
    public RankQueryStructureInt.RangeHandle createHandle(int n, int n2, int n3, int[] nArray, int[] nArray2) {
        return new RangeHandleImpl(n, n2, n3, nArray, nArray2);
    }

    private final class RangeHandleImpl
    extends RankQueryStructureInt.RangeHandle {
        private final int size;
        private final int offset;

        private RangeHandleImpl(int n, int n2, int n3, int[] nArray, int[] nArray2) {
            this.offset = n;
            int n4 = n2;
            int n5 = this.offset;
            while (n4 < n3) {
                ((FenwickRankQueryStructureInt)FenwickRankQueryStructureInt.this).keys[n5] = nArray2[nArray[n4]];
                ++n4;
                ++n5;
            }
            n4 = n + n3 - n2;
            Arrays.sort(FenwickRankQueryStructureInt.this.keys, n, n4);
            n5 = this.offset + 1;
            int n6 = FenwickRankQueryStructureInt.this.keys[this.offset];
            for (int i = n + 1; i < n4; ++i) {
                int n7 = FenwickRankQueryStructureInt.this.keys[i];
                if (n7 == n6) continue;
                ((FenwickRankQueryStructureInt)FenwickRankQueryStructureInt.this).keys[n5] = n6 = n7;
                ++n5;
            }
            Arrays.fill(FenwickRankQueryStructureInt.this.values, this.offset, n5, -1);
            this.size = n5 - this.offset;
        }

        private int indexFor(int n) {
            int n2 = this.offset - 1;
            int n3 = this.offset + this.size;
            while (n3 - n2 > 1) {
                int n4 = n2 + n3 >>> 1;
                if (FenwickRankQueryStructureInt.this.keys[n4] <= n) {
                    n2 = n4;
                    continue;
                }
                n3 = n4;
            }
            return n2 - this.offset;
        }

        @Override
        public RankQueryStructureInt.RangeHandle put(int n, int n2) {
            for (int i = this.indexFor(n); i < this.size; i |= i + 1) {
                int n3 = this.offset + i;
                ((FenwickRankQueryStructureInt)FenwickRankQueryStructureInt.this).values[n3] = Math.max(FenwickRankQueryStructureInt.this.values[n3], n2);
            }
            return this;
        }

        @Override
        public int getMaximumWithKeyAtMost(int n, int n2) {
            int n3 = this.indexFor(n);
            int n4 = -1;
            while (n3 >= 0) {
                n4 = Math.max(n4, FenwickRankQueryStructureInt.this.values[this.offset + n3]);
                n3 = (n3 & n3 + 1) - 1;
            }
            return n4;
        }
    }
}

