/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.Serializable;
import weka.core.Attribute;

public abstract class Item
implements Serializable,
Comparable<Item> {
    private static final long serialVersionUID = -430198211081183575L;
    protected int m_frequency;
    protected Attribute m_attribute;

    public Item(Attribute att) {
        this.m_attribute = att;
    }

    public void increaseFrequency(int f) {
        this.m_frequency += f;
    }

    public void decreaseFrequency(int f) {
        this.m_frequency -= f;
    }

    public void increaseFrequency() {
        ++this.m_frequency;
    }

    public void decreaseFrequency() {
        --this.m_frequency;
    }

    public int getFrequency() {
        return this.m_frequency;
    }

    public Attribute getAttribute() {
        return this.m_attribute;
    }

    public abstract String getItemValueAsString();

    public abstract String getComparisonAsString();

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean freq) {
        String result = this.m_attribute.name();
        if (freq) {
            result = result + ":" + this.m_frequency;
        }
        return result;
    }

    @Override
    public int compareTo(Item comp) {
        if (this.m_frequency == comp.getFrequency()) {
            return -1 * this.m_attribute.name().compareTo(comp.getAttribute().name());
        }
        if (comp.getFrequency() < this.m_frequency) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object compareTo) {
        if (!(compareTo instanceof Item)) {
            return false;
        }
        Item b2 = (Item)compareTo;
        return this.m_attribute.equals(b2.getAttribute());
    }

    public int hashCode() {
        return (this.m_attribute.name().hashCode() ^ this.m_attribute.numValues()) * this.m_frequency;
    }
}

