/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes;

import weka.classifiers.UpdateableClassifier;
import weka.classifiers.bayes.NaiveBayesMultinomial;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class NaiveBayesMultinomialUpdateable
extends NaiveBayesMultinomial
implements UpdateableClassifier {
    static final long serialVersionUID = -7204398796974263186L;
    protected double[] m_wordsPerClass;

    @Override
    public String globalInfo() {
        return "Class for building and using an updateable multinomial Naive Bayes classifier. For more information see,\n\n" + this.getTechnicalInformation().toString() + "\n\nThe core equation for this classifier:\n\nP[Ci|D] = (P[D|Ci] x P[Ci]) / P[D] (Bayes' rule)\n\nwhere Ci is class i and D is a document.";
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        this.initializeClassifier(instances);
        this.m_wordsPerClass = new double[this.m_numClasses];
        for (int i = 0; i < this.m_numClasses; ++i) {
            this.m_wordsPerClass[i] = this.m_numAttributes - 1;
        }
        for (Instance instance : instances) {
            this.updateClassifier(instance);
        }
    }

    @Override
    public void updateClassifier(Instance instance) throws Exception {
        double classValue = instance.value(instance.classIndex());
        if (!Utils.isMissingValue(classValue)) {
            int classIndex;
            int n = classIndex = (int)classValue;
            this.m_probOfClass[n] = this.m_probOfClass[n] + instance.weight();
            for (int a2 = 0; a2 < instance.numValues(); ++a2) {
                if (instance.index(a2) == instance.classIndex() || instance.isMissingSparse(a2)) continue;
                double numOccurrences = instance.valueSparse(a2) * instance.weight();
                if (numOccurrences < 0.0) {
                    throw new Exception("Numeric attribute values must all be greater or equal to zero.");
                }
                int n2 = classIndex;
                this.m_wordsPerClass[n2] = this.m_wordsPerClass[n2] + numOccurrences;
                double[] dArray = this.m_probOfWordGivenClass[classIndex];
                int n3 = instance.index(a2);
                dArray[n3] = dArray[n3] + numOccurrences;
            }
        }
    }

    @Override
    protected double probOfDocGivenClass(Instance inst, int classIndex) {
        double answer = 0.0;
        for (int i = 0; i < inst.numValues(); ++i) {
            if (inst.index(i) == inst.classIndex()) continue;
            answer += inst.valueSparse(i) * (Math.log(this.m_probOfWordGivenClass[classIndex][inst.index(i)]) - Math.log(this.m_wordsPerClass[classIndex]));
        }
        return answer;
    }

    @Override
    public String toString() {
        int c2;
        StringBuffer result = new StringBuffer("The class counts (including Laplace correction)\n-----------------------------------------------\n");
        for (c2 = 0; c2 < this.m_numClasses; ++c2) {
            result.append(this.m_headerInfo.classAttribute().value(c2)).append("\t").append(Utils.doubleToString(this.m_probOfClass[c2], this.getNumDecimalPlaces())).append("\n");
        }
        result.append("\nThe probability of a word given the class\n-----------------------------------------\n\t");
        for (c2 = 0; c2 < this.m_numClasses; ++c2) {
            result.append(this.m_headerInfo.classAttribute().value(c2)).append("\t");
        }
        result.append("\n");
        for (int w = 0; w < this.m_numAttributes; ++w) {
            if (w == this.m_headerInfo.classIndex()) continue;
            result.append(this.m_headerInfo.attribute(w).name()).append("\t");
            for (int c3 = 0; c3 < this.m_numClasses; ++c3) {
                result.append(Utils.doubleToString(this.m_probOfWordGivenClass[c3][w] / this.m_wordsPerClass[c3], this.getNumDecimalPlaces())).append("\t");
            }
            result.append("\n");
        }
        return result.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 14252 $");
    }

    public static void main(String[] argv) {
        NaiveBayesMultinomialUpdateable.runClassifier(new NaiveBayesMultinomialUpdateable(), argv);
    }
}

