/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation.output.prediction;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weka.classifiers.Classifier;
import weka.classifiers.evaluation.NominalPrediction;
import weka.classifiers.evaluation.NumericPrediction;
import weka.classifiers.evaluation.Prediction;
import weka.classifiers.evaluation.output.prediction.AbstractOutput;
import weka.core.Attribute;
import weka.core.Instance;

public class InMemory
extends AbstractOutput {
    private static final long serialVersionUID = 3401604538169573720L;
    protected List<PredictionContainer> m_Predictions;

    @Override
    public String globalInfo() {
        return "Stores the predictions in memory for programmatic retrieval.\nStores the instance, a prediction object and a map of attribute names with their associated values if an attribute was defined in a container per prediction.\nThe list of predictions can get retrieved using the getPredictions() method.\nFile output is disabled and buffer doesn't need to be supplied.";
    }

    @Override
    public String getDisplay() {
        return "InMemory";
    }

    @Override
    public void setOutputFile(File value) {
        super.setOutputFile(new File("."));
    }

    @Override
    protected String checkHeader() {
        if (this.m_Buffer == null) {
            this.m_Buffer = new StringBuffer();
        }
        return super.checkHeader();
    }

    @Override
    protected void doPrintHeader() {
        this.m_Predictions = new ArrayList<PredictionContainer>();
    }

    protected Map<String, Object> attributeValuesToMap(Instance instance) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.m_Attributes.setUpper(instance.numAttributes() - 1);
        block4: for (int i = 0; i < instance.numAttributes(); ++i) {
            if (!this.m_Attributes.isInRange(i) || i == instance.classIndex()) continue;
            switch (instance.attribute(i).type()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    result.put(instance.attribute(i).name(), instance.stringValue(i));
                    continue block4;
                }
                case 0: {
                    result.put(instance.attribute(i).name(), instance.value(i));
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("Unhandled attribute type for attribute '" + instance.attribute(i).name() + ": " + Attribute.typeToString(instance.attribute(i).type()));
                }
            }
        }
        return result;
    }

    @Override
    protected void doPrintClassification(double[] dist, Instance inst, int index) throws Exception {
        PredictionContainer cont = new PredictionContainer();
        cont.instance = inst;
        cont.prediction = inst.classAttribute().isNominal() ? new NominalPrediction(inst.classValue(), dist, inst.weight()) : new NumericPrediction(inst.classValue(), dist[0], inst.weight());
        cont.attributeValues.putAll(this.attributeValuesToMap(inst));
        this.m_Predictions.add(cont);
    }

    @Override
    protected void doPrintClassification(Classifier classifier, Instance inst, int index) throws Exception {
        double[] d2 = classifier.distributionForInstance(inst);
        this.doPrintClassification(d2, inst, index);
    }

    @Override
    protected void doPrintFooter() {
    }

    public List<PredictionContainer> getPredictions() {
        return this.m_Predictions;
    }

    public static class PredictionContainer {
        public Instance instance = null;
        public Prediction prediction = null;
        public Map<String, Object> attributeValues = new HashMap<String, Object>();

        public String toString() {
            return this.instance + " - " + this.prediction + " - " + this.attributeValues;
        }
    }
}

