/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.ht;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weka.classifiers.trees.ht.ConditionalSufficientStats;
import weka.classifiers.trees.ht.GaussianConditionalSufficientStats;
import weka.classifiers.trees.ht.LeafNode;
import weka.classifiers.trees.ht.LearningNode;
import weka.classifiers.trees.ht.NominalConditionalSufficientStats;
import weka.classifiers.trees.ht.SplitCandidate;
import weka.classifiers.trees.ht.SplitMetric;
import weka.classifiers.trees.ht.WeightMass;
import weka.core.Attribute;
import weka.core.Instance;

public class ActiveHNode
extends LeafNode
implements LearningNode,
Serializable {
    private static final long serialVersionUID = 3284585939739561683L;
    public double m_weightSeenAtLastSplitEval = 0.0;
    protected Map<String, ConditionalSufficientStats> m_nodeStats = new HashMap<String, ConditionalSufficientStats>();

    @Override
    public void updateNode(Instance inst) throws Exception {
        super.updateDistribution(inst);
        for (int i = 0; i < inst.numAttributes(); ++i) {
            Attribute a2 = inst.attribute(i);
            if (i == inst.classIndex()) continue;
            ConditionalSufficientStats stats = this.m_nodeStats.get(a2.name());
            if (stats == null) {
                stats = a2.isNumeric() ? new GaussianConditionalSufficientStats() : new NominalConditionalSufficientStats();
                this.m_nodeStats.put(a2.name(), stats);
            }
            stats.update(inst.value(a2), inst.classAttribute().value((int)inst.classValue()), inst.weight());
        }
    }

    public List<SplitCandidate> getPossibleSplits(SplitMetric splitMetric) {
        ArrayList<SplitCandidate> splits = new ArrayList<SplitCandidate>();
        ArrayList<Map<String, WeightMass>> nullDist = new ArrayList<Map<String, WeightMass>>();
        nullDist.add(this.m_classDistribution);
        SplitCandidate nullSplit = new SplitCandidate(null, nullDist, splitMetric.evaluateSplit(this.m_classDistribution, nullDist));
        splits.add(nullSplit);
        for (Map.Entry<String, ConditionalSufficientStats> e2 : this.m_nodeStats.entrySet()) {
            ConditionalSufficientStats stat = e2.getValue();
            SplitCandidate splitCandidate = stat.bestSplit(splitMetric, this.m_classDistribution, e2.getKey());
            if (splitCandidate == null) continue;
            splits.add(splitCandidate);
        }
        return splits;
    }
}

