/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import weka.Run;
import weka.core.EnvironmentProperties;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.WekaPackageClassLoaderManager;
import weka.core.WekaPackageManager;

public class ResourceUtils {
    public static Object forName(Class<?> classType, String className, String[] options) throws Exception {
        if (System.getProperty("weka.test.maventest", "").equalsIgnoreCase("true")) {
            return ResourceUtils.forNameNoSchemeMatch(classType, className, options);
        }
        List<String> matches = Run.findSchemeMatch(classType, className, false, true);
        if (matches.size() == 0) {
            Class<?> c2 = WekaPackageClassLoaderManager.forName(className);
            if (c2.isArray() && (classType == null || classType.isAssignableFrom(c2))) {
                return Array.newInstance(c2.getComponentType(), 0);
            }
            throw new Exception("Can't find a permissible class called: " + className);
        }
        if (matches.size() > 1) {
            StringBuffer sb = new StringBuffer("More than one possibility matched '" + className + "':\n");
            for (String s : matches) {
                sb.append("  " + s + '\n');
            }
            throw new Exception(sb.toString());
        }
        className = matches.get(0);
        Class<?> c3 = null;
        try {
            c3 = WekaPackageClassLoaderManager.forName(className);
        }
        catch (Exception ex) {
            throw new Exception("Can't find a permissible class called: " + className);
        }
        Object o = c3.newInstance();
        if (o instanceof OptionHandler && options != null) {
            ((OptionHandler)o).setOptions(options);
            Utils.checkForRemainingOptions(options);
        }
        return o;
    }

    protected static Object forNameNoSchemeMatch(Class classType, String className, String[] options) throws Exception {
        Class<?> c2 = null;
        try {
            c2 = WekaPackageClassLoaderManager.forName(className);
        }
        catch (Exception ex) {
            throw new Exception("Can't find class called: " + className);
        }
        if (classType != null && !classType.isAssignableFrom(c2)) {
            throw new Exception(classType.getName() + " is not assignable from " + className);
        }
        Object o = c2.newInstance();
        if (o instanceof OptionHandler && options != null) {
            ((OptionHandler)o).setOptions(options);
            Utils.checkForRemainingOptions(options);
        }
        return o;
    }

    public static Properties readProperties(String resourceName) throws Exception {
        Utils utils = new Utils();
        return ResourceUtils.readProperties(resourceName, utils.getClass().getClassLoader());
    }

    public static Properties readProperties(String resourceName, ClassLoader loader) throws Exception {
        File propFile;
        Properties defaultProps = new Properties();
        try {
            Enumeration<URL> urls = loader.getResources(resourceName);
            boolean first = true;
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (first) {
                    defaultProps.load(url.openStream());
                    first = false;
                    continue;
                }
                Properties props = new Properties(defaultProps);
                props.load(url.openStream());
                defaultProps = props;
            }
        }
        catch (Exception ex) {
            System.err.println("Warning, unable to load properties file(s) from system resource (Utils.java): " + resourceName);
        }
        int slInd = resourceName.lastIndexOf(47);
        if (slInd != -1) {
            resourceName = resourceName.substring(slInd + 1);
        }
        Properties userProps = new Properties(defaultProps);
        if (!WekaPackageManager.PROPERTIES_DIR.exists()) {
            WekaPackageManager.PROPERTIES_DIR.mkdir();
        }
        if ((propFile = new File(WekaPackageManager.PROPERTIES_DIR.toString() + File.separator + resourceName)).exists()) {
            try {
                userProps.load(new FileInputStream(propFile));
            }
            catch (Exception ex) {
                throw new Exception("Problem reading user properties: " + propFile);
            }
        }
        Properties localProps = new Properties(userProps);
        propFile = new File(resourceName);
        if (propFile.exists()) {
            try {
                localProps.load(new FileInputStream(propFile));
            }
            catch (Exception ex) {
                throw new Exception("Problem reading local properties: " + propFile);
            }
        }
        return new EnvironmentProperties(localProps);
    }

    public static File getWekaHome() {
        return WekaPackageManager.WEKA_HOME;
    }
}

