/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weka.core.Defaults;
import weka.core.EnumHelper;
import weka.core.Environment;
import weka.core.FileHelper;
import weka.core.FontHelper;
import weka.core.metastore.XMLFileBasedMetaStore;
import weka.knowledgeflow.LoggingLevel;

public class Settings
implements Serializable {
    private static final long serialVersionUID = -4005372566372478008L;
    protected Map<String, Map<SettingKey, Object>> m_settings = new LinkedHashMap<String, Map<SettingKey, Object>>();
    protected String m_storeName = "";
    protected String m_ID = "";

    public void loadSettings() throws IOException {
        XMLFileBasedMetaStore store = new XMLFileBasedMetaStore();
        Map loaded = (Map)store.getEntry(this.m_storeName, this.m_ID, Map.class);
        if (loaded != null) {
            this.m_settings = loaded;
        }
        for (Map<SettingKey, Object> s : this.m_settings.values()) {
            for (Map.Entry<SettingKey, Object> e2 : s.entrySet()) {
                Serializable f;
                SettingKey key;
                if (e2.getValue() instanceof EnumHelper) {
                    key = e2.getKey();
                    EnumHelper eHelper = (EnumHelper)e2.getValue();
                    try {
                        Object actualValue = EnumHelper.valueFromString(eHelper.getEnumClass(), eHelper.getSelectedEnumValue());
                        s.put(key, actualValue);
                        continue;
                    }
                    catch (Exception ex) {
                        throw new IOException(ex);
                    }
                }
                if (e2.getValue() instanceof FontHelper) {
                    key = e2.getKey();
                    FontHelper fHelper = (FontHelper)e2.getValue();
                    f = fHelper.getFont();
                    s.put(key, f);
                    continue;
                }
                if (!(e2.getValue() instanceof FileHelper)) continue;
                key = e2.getKey();
                FileHelper fileHelper = (FileHelper)e2.getValue();
                f = fileHelper.getFile();
                s.put(key, f);
            }
        }
    }

    public Settings(String storeName, String ID2) {
        this.m_storeName = storeName;
        this.m_ID = ID2;
        try {
            this.loadSettings();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String getID() {
        return this.m_ID;
    }

    public String getStoreName() {
        return this.m_storeName;
    }

    public void applyDefaults(Defaults defaults) {
        if (defaults == null) {
            return;
        }
        Map<SettingKey, Object> settingsForID = this.m_settings.get(defaults.getID());
        if (settingsForID == null) {
            settingsForID = new LinkedHashMap<SettingKey, Object>();
            this.m_settings.put(defaults.getID(), settingsForID);
        }
        for (Map.Entry<SettingKey, Object> e2 : defaults.getDefaults().entrySet()) {
            if (settingsForID.containsKey(e2.getKey())) continue;
            settingsForID.put(e2.getKey(), e2.getValue());
        }
    }

    public Map<SettingKey, Object> getSettings(String settingsID) {
        return this.m_settings.get(settingsID);
    }

    public Set<String> getSettingsIDs() {
        return this.m_settings.keySet();
    }

    public <T> T getSetting(String ID2, String key, T defaultValue, Environment env) {
        SettingKey tempKey = new SettingKey(key, "", "");
        return this.getSetting(ID2, tempKey, defaultValue, env);
    }

    public <T> T getSetting(String ID2, SettingKey key, T defaultValue) {
        return this.getSetting(ID2, key, defaultValue, Environment.getSystemWide());
    }

    public <T> T getSetting(String ID2, SettingKey key, T defaultValue, Environment env) {
        String val;
        Map<SettingKey, Object> settingsForID = this.m_settings.get(ID2);
        Object value = null;
        if (settingsForID != null && settingsForID.size() > 0 && (value = settingsForID.get(key)) instanceof String) {
            try {
                value = env.substitute((String)value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (value == null && env != null && (val = env.getVariableValue(key.getKey())) != null) {
            value = Settings.stringToT(val, defaultValue);
        }
        if (value == null && (val = System.getProperty(key.getKey())) != null) {
            value = Settings.stringToT(val, defaultValue);
        }
        return (T)(value != null ? value : defaultValue);
    }

    public void setSetting(String ID2, SettingKey propName, Object value) {
        Map<SettingKey, Object> settingsForID = this.m_settings.get(ID2);
        if (settingsForID == null) {
            settingsForID = new LinkedHashMap<SettingKey, Object>();
            this.m_settings.put(ID2, settingsForID);
        }
        settingsForID.put(propName, value);
    }

    public boolean hasSettings(String settingsID) {
        return this.m_settings.containsKey(settingsID);
    }

    public boolean hasSetting(String settingsID, String propName) {
        if (!this.hasSettings(settingsID)) {
            return false;
        }
        return this.m_settings.get(settingsID).containsKey(propName);
    }

    public void saveSettings() throws IOException {
        LinkedHashMap settingsCopy = new LinkedHashMap();
        for (Map.Entry<String, Map<SettingKey, Object>> e2 : this.m_settings.entrySet()) {
            LinkedHashMap<SettingKey, Object> s = new LinkedHashMap<SettingKey, Object>();
            settingsCopy.put(e2.getKey(), s);
            for (Map.Entry<SettingKey, Object> ee : e2.getValue().entrySet()) {
                Object wrapper;
                if (ee.getValue() instanceof Enum) {
                    wrapper = new EnumHelper((Enum)ee.getValue());
                    s.put(ee.getKey(), wrapper);
                    continue;
                }
                if (ee.getValue() instanceof Font) {
                    wrapper = new FontHelper((Font)ee.getValue());
                    s.put(ee.getKey(), wrapper);
                    continue;
                }
                if (ee.getValue() instanceof File) {
                    wrapper = new FileHelper((File)ee.getValue());
                    s.put(ee.getKey(), wrapper);
                    continue;
                }
                s.put(ee.getKey(), ee.getValue());
            }
        }
        XMLFileBasedMetaStore store = new XMLFileBasedMetaStore();
        if (this.m_settings.size() > 0) {
            store.storeEntry(this.m_storeName, this.m_ID, settingsCopy);
        }
    }

    protected static <T> T stringToT(String propVal, T defaultVal) {
        if (defaultVal instanceof String) {
            return (T)propVal;
        }
        if (defaultVal instanceof Boolean) {
            return (T)Boolean.valueOf(propVal);
        }
        if (defaultVal instanceof Double) {
            return (T)Double.valueOf(propVal);
        }
        if (defaultVal instanceof Integer) {
            return (T)Integer.valueOf(propVal);
        }
        if (defaultVal instanceof Long) {
            return (T)Long.valueOf(propVal);
        }
        if (defaultVal instanceof LoggingLevel) {
            return (T)((Object)LoggingLevel.stringToLevel(propVal));
        }
        return null;
    }

    public static class SettingKey
    implements Serializable {
        protected String m_key;
        protected String m_description;
        protected String m_toolTip;
        protected List<String> m_pickList;
        protected Map<String, String> m_meta;

        public SettingKey() {
            this("", "", "");
        }

        public SettingKey(String key, String description, String toolTip) {
            this(key, description, toolTip, null);
        }

        public SettingKey(String key, String description, String toolTip, List<String> pickList) {
            this.m_key = key;
            this.m_description = description;
            this.m_toolTip = toolTip;
            this.m_pickList = pickList;
        }

        public void setKey(String key) {
            this.m_key = key;
        }

        public String getKey() {
            return this.m_key;
        }

        public void setDescription(String description) {
            this.m_description = description;
        }

        public String getDescription() {
            return this.m_description;
        }

        public void setToolTip(String toolTip) {
            this.m_toolTip = toolTip;
        }

        public String getToolTip() {
            return this.m_toolTip;
        }

        public void setMetadataElement(String key, String value) {
            if (this.m_meta == null) {
                this.m_meta = new HashMap<String, String>();
            }
            this.m_meta.put(key, value);
        }

        public String getMetadataElement(String key) {
            if (this.m_meta == null) {
                return null;
            }
            return this.m_meta.get(key);
        }

        public String getMetadataElement(String key, String defaultValue) {
            String result = this.getMetadataElement(key);
            return result == null ? defaultValue : result;
        }

        public void setMetadata(Map<String, String> metadata) {
            this.m_meta = metadata;
        }

        public Map<String, String> getMetadata() {
            return this.m_meta;
        }

        public List<String> getPickList() {
            return this.m_pickList;
        }

        public void setPickList(List<String> pickList) {
            this.m_pickList = pickList;
        }

        public int hashCode() {
            return this.m_key.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof SettingKey)) {
                return false;
            }
            return this.m_key.equals(((SettingKey)other).getKey());
        }

        public String toString() {
            return this.m_description;
        }
    }
}

