/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class Tee
extends PrintStream
implements RevisionHandler {
    protected Vector<PrintStream> m_Streams = new Vector();
    protected Vector<Boolean> m_Timestamps = new Vector();
    protected Vector<String> m_Prefixes = new Vector();
    protected PrintStream m_Default = null;

    public Tee() {
        this(System.out);
    }

    public Tee(PrintStream def) {
        super(def);
        this.m_Default = def;
        this.clear();
    }

    public void clear() {
        this.m_Streams.clear();
        this.m_Timestamps.clear();
        this.m_Prefixes.clear();
        if (this.getDefault() != null) {
            this.add(this.getDefault());
        }
    }

    public PrintStream getDefault() {
        return this.m_Default;
    }

    public void add(PrintStream p) {
        this.add(p, false);
    }

    public void add(PrintStream p, boolean timestamp) {
        this.add(p, timestamp, "");
    }

    public void add(PrintStream p, boolean timestamp, String prefix) {
        if (this.m_Streams.contains(p)) {
            this.remove(p);
        }
        if (prefix == null) {
            prefix = "";
        }
        this.m_Streams.add(p);
        this.m_Timestamps.add(new Boolean(timestamp));
        this.m_Prefixes.add(prefix);
    }

    public PrintStream get(int index) {
        if (index >= 0 && index < this.size()) {
            return this.m_Streams.get(index);
        }
        return null;
    }

    public PrintStream remove(PrintStream p) {
        int index = this.m_Streams.indexOf(p);
        if (index != -1) {
            this.m_Timestamps.remove(index);
            this.m_Prefixes.remove(index);
            return this.m_Streams.remove(index);
        }
        return null;
    }

    public PrintStream remove(int index) {
        if (index >= 0 && index < this.size()) {
            this.m_Timestamps.remove(index);
            this.m_Prefixes.remove(index);
            return this.m_Streams.remove(index);
        }
        return null;
    }

    public boolean contains(PrintStream p) {
        return this.m_Streams.contains(p);
    }

    public int size() {
        return this.m_Streams.size();
    }

    private void printHeader() {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.m_Prefixes.get(i).equals("")) {
                this.m_Streams.get(i).print("[" + this.m_Prefixes.get(i) + "]\t");
            }
            if (!this.m_Timestamps.get(i).booleanValue()) continue;
            this.m_Streams.get(i).print("[" + new Date() + "]\t");
        }
    }

    @Override
    public void flush() {
        for (int i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).flush();
        }
    }

    @Override
    public void print(int x) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).print(x);
        }
        this.flush();
    }

    @Override
    public void print(long x) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).print(x);
        }
        this.flush();
    }

    @Override
    public void print(float x) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).print(x);
        }
        this.flush();
    }

    @Override
    public void print(double x) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).print(x);
        }
        this.flush();
    }

    @Override
    public void print(boolean x) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).print(x);
        }
        this.flush();
    }

    @Override
    public void print(char x) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).print(x);
        }
        this.flush();
    }

    @Override
    public void print(char[] x) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).print(x);
        }
        this.flush();
    }

    @Override
    public void print(String x) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).print(x);
        }
        this.flush();
    }

    @Override
    public void print(Object x) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).print(x);
        }
        this.flush();
    }

    @Override
    public void println() {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).println();
        }
        this.flush();
    }

    @Override
    public void println(int x) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).println(x);
        }
        this.flush();
    }

    @Override
    public void println(long x) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).println(x);
        }
        this.flush();
    }

    @Override
    public void println(float x) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).println(x);
        }
        this.flush();
    }

    @Override
    public void println(double x) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).println(x);
        }
        this.flush();
    }

    @Override
    public void println(boolean x) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).println(x);
        }
        this.flush();
    }

    @Override
    public void println(char x) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).println(x);
        }
        this.flush();
    }

    @Override
    public void println(char[] x) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).println(x);
        }
        this.flush();
    }

    @Override
    public void println(String x) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).println(x);
        }
        this.flush();
    }

    @Override
    public void println(Object x) {
        int i;
        if (x instanceof Throwable) {
            Throwable t = (Throwable)x;
            StackTraceElement[] trace = t.getStackTrace();
            String line = t.toString() + "\n";
            for (i = 0; i < trace.length; ++i) {
                line = line + "\t" + trace[i].toString() + "\n";
            }
            x = line;
        }
        this.printHeader();
        for (i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).println(x);
        }
        this.flush();
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).write(buf, off, len);
        }
        this.flush();
    }

    @Override
    public void write(int b2) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).write(b2);
        }
        this.flush();
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).write(b2);
        }
        this.flush();
    }

    @Override
    public PrintStream printf(String format, Object ... args) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).printf(format, args);
        }
        this.flush();
        return this;
    }

    @Override
    public PrintStream printf(Locale l, String format, Object ... args) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).printf(l, format, args);
        }
        this.flush();
        return this;
    }

    @Override
    public PrintStream append(char c2) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).append(c2);
        }
        this.flush();
        return this;
    }

    @Override
    public PrintStream append(CharSequence csq) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).append(csq);
        }
        this.flush();
        return this;
    }

    @Override
    public PrintStream append(CharSequence csq, int start, int end) {
        this.printHeader();
        for (int i = 0; i < this.size(); ++i) {
            this.m_Streams.get(i).append(csq, start, end);
        }
        this.flush();
        return this;
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.m_Streams.size();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 15287 $");
    }
}

