/*
 * Decompiled with CFR 0.152.
 */
package weka.core.matrix;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.matrix.ExponentialFormat;
import weka.core.matrix.FloatingPointFormat;

public class FlexibleDecimalFormat
extends DecimalFormat
implements RevisionHandler {
    private static final long serialVersionUID = 110912192794064140L;
    private DecimalFormat nf = null;
    private int digits = 7;
    private boolean exp = false;
    private int intDigits = 1;
    private int decimalDigits = 0;
    private int expDecimalDigits = 0;
    private int power = 2;
    private boolean trailing = false;
    private boolean grouping = false;
    private boolean sign = false;

    public FlexibleDecimalFormat() {
        this(5);
    }

    public FlexibleDecimalFormat(int digits) {
        if (digits < 1) {
            throw new IllegalArgumentException("digits < 1");
        }
        this.digits = digits;
        this.intDigits = 1;
    }

    public FlexibleDecimalFormat(int digits, boolean trailing) {
        this(digits);
        this.trailing = trailing;
    }

    public FlexibleDecimalFormat(int digits, boolean exp, boolean trailing, boolean grouping) {
        this.trailing = trailing;
        this.exp = exp;
        this.digits = digits;
        this.grouping = grouping;
        if (exp) {
            this.intDigits = 1;
            this.decimalDigits = digits - this.intDigits;
        } else {
            this.intDigits = Math.max(1, digits - this.decimalDigits);
        }
    }

    public FlexibleDecimalFormat(double d2) {
        this.newFormat(d2);
    }

    private void newFormat(double d2) {
        if (this.needExponentialFormat(d2)) {
            this.exp = true;
            this.intDigits = 1;
            this.expDecimalDigits = this.decimalDigits(d2, true);
            this.sign = d2 < 0.0;
        } else {
            this.exp = false;
            this.intDigits = Math.max(1, FlexibleDecimalFormat.intDigits(d2));
            this.decimalDigits = this.decimalDigits(d2, false);
            this.sign = d2 < 0.0;
        }
    }

    public void update(double d2) {
        if (Math.abs(FlexibleDecimalFormat.intDigits(d2) - 1) > 99) {
            this.power = 3;
        }
        this.expDecimalDigits = Math.max(this.expDecimalDigits, this.decimalDigits(d2, true));
        if (d2 < 0.0) {
            this.sign = true;
        }
        if (this.needExponentialFormat(d2) || this.exp) {
            this.exp = true;
        } else {
            this.intDigits = Math.max(this.intDigits, FlexibleDecimalFormat.intDigits(d2));
            this.decimalDigits = Math.max(this.decimalDigits, this.decimalDigits(d2, false));
            if (d2 < 0.0) {
                this.sign = true;
            }
        }
    }

    private static int intDigits(double d2) {
        return (int)Math.floor(Math.log(Math.abs(d2 * 1.00000000000001)) / Math.log(10.0)) + 1;
    }

    private int decimalDigits(double d2, boolean expo) {
        int dD;
        if (d2 == 0.0) {
            return 0;
        }
        d2 = Math.abs(d2);
        int e2 = FlexibleDecimalFormat.intDigits(d2);
        if (expo) {
            d2 /= Math.pow(10.0, e2 - 1);
            e2 = 1;
        }
        if (e2 >= this.digits) {
            return 0;
        }
        int iD = Math.max(1, e2);
        if (!this.trailing && dD > 0) {
            FloatingPointFormat f = new FloatingPointFormat(iD + 1 + dD, dD, true);
            String dString = f.nf.format(d2);
            for (dD = this.digits - e2; dD > 0 && dString.charAt(iD + 1 + dD - 1) == '0'; --dD) {
            }
        }
        return dD;
    }

    public boolean needExponentialFormat(double d2) {
        if (d2 == 0.0) {
            return false;
        }
        int e2 = FlexibleDecimalFormat.intDigits(d2);
        return e2 > this.digits + 5 || e2 < -3;
    }

    public void grouping(boolean grouping) {
        this.grouping = grouping;
    }

    private void setFormat() {
        int dot = 1;
        if (this.decimalDigits == 0) {
            dot = 0;
        }
        if (this.exp) {
            this.nf = new ExponentialFormat(1 + this.expDecimalDigits, this.power, this.sign, this.grouping || this.trailing);
        } else {
            int s = this.sign ? 1 : 0;
            this.nf = new FloatingPointFormat(s + this.intDigits + dot + this.decimalDigits, this.decimalDigits, this.grouping || this.trailing);
        }
    }

    private void setFormat(double d2) {
        this.newFormat(d2);
        this.setFormat();
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        if (this.grouping) {
            if (this.nf == null) {
                this.setFormat();
            }
        } else {
            this.setFormat(number);
        }
        return toAppendTo.append(this.nf.format(number));
    }

    public int width() {
        if (!this.trailing && !this.grouping) {
            throw new RuntimeException("flexible width");
        }
        return this.format(0.0).length();
    }

    public StringBuffer formatString(String str) {
        int i;
        int w = this.width();
        int h = (w - str.length()) / 2;
        StringBuffer text = new StringBuffer();
        for (i = 0; i < h; ++i) {
            text.append(' ');
        }
        text.append(str);
        for (i = 0; i < w - h - str.length(); ++i) {
            text.append(' ');
        }
        return text;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10835 $");
    }
}

