/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import weka.core.Instances;

public class AttributeListPanel
extends JPanel {
    private static final long serialVersionUID = -2030706987910400362L;
    protected JTable m_Table = new JTable();
    protected AttributeTableModel m_Model;

    public AttributeListPanel() {
        this.m_Table.setSelectionMode(0);
        this.m_Table.setColumnSelectionAllowed(false);
        this.m_Table.setPreferredScrollableViewportSize(new Dimension(250, 150));
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.m_Table), "Center");
    }

    public void setInstances(Instances newInstances) {
        if (this.m_Model == null) {
            this.m_Model = new AttributeTableModel(newInstances);
            this.m_Table.setModel(this.m_Model);
            TableColumnModel tcm = this.m_Table.getColumnModel();
            tcm.getColumn(0).setMaxWidth(60);
            tcm.getColumn(1).setMinWidth(100);
        } else {
            this.m_Model.setInstances(newInstances);
        }
        this.m_Table.sizeColumnsToFit(-1);
        this.m_Table.revalidate();
        this.m_Table.repaint();
    }

    public ListSelectionModel getSelectionModel() {
        return this.m_Table.getSelectionModel();
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                throw new Exception("supply the name of an arff file");
            }
            Instances i = new Instances(new BufferedReader(new FileReader(args[0])));
            AttributeListPanel asp = new AttributeListPanel();
            final JFrame jf = new JFrame("Attribute List Panel");
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)asp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e2) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
            asp.setInstances(i);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    class AttributeTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -7345701953670327707L;
        protected Instances m_Instances;

        public AttributeTableModel(Instances instances) {
            this.setInstances(instances);
        }

        public void setInstances(Instances instances) {
            this.m_Instances = instances;
        }

        @Override
        public int getRowCount() {
            return this.m_Instances.numAttributes();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return new Integer(row + 1);
                }
                case 1: {
                    return this.m_Instances.attribute(row).name();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return new String("No.");
                }
                case 1: {
                    return new String("Name");
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return this.getValueAt(0, col).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

