/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ETable
extends JTable {
    private static final long serialVersionUID = -3028630226368293049L;
    private final Color MAC_FOCUSED_SELECTED_CELL_HORIZONTAL_LINE_COLOR = new Color(8235754);
    private final Color MAC_UNFOCUSED_SELECTED_CELL_HORIZONTAL_LINE_COLOR = new Color(0xE0E0E0);
    private final Color MAC_UNFOCUSED_SELECTED_CELL_BACKGROUND_COLOR = new Color(0xC0C0C0);
    private final Color MAC_FOCUSED_UNSELECTED_VERTICAL_LINE_COLOR = new Color(0xD9D9D9);
    private final Color MAC_FOCUSED_SELECTED_VERTICAL_LINE_COLOR = new Color(3435966);
    private final Color MAC_UNFOCUSED_UNSELECTED_VERTICAL_LINE_COLOR = new Color(0xD9D9D9);
    private final Color MAC_UNFOCUSED_SELECTED_VERTICAL_LINE_COLOR = new Color(0xACACAC);
    private final Color MAC_OS_ALTERNATE_ROW_COLOR = new Color(0.92f, 0.95f, 0.99f);

    public ETable() {
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension());
        this.getTableHeader().setReorderingAllowed(false);
        if (System.getProperty("os.name").contains("Mac")) {
            ((JLabel)JLabel.class.cast(this.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(10);
            this.setShowHorizontalLines(false);
            this.setShowVerticalLines(true);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.paintEmptyRows(g);
    }

    protected void paintEmptyRows(Graphics g) {
        int rowCount = this.getRowCount();
        Rectangle clip = g.getClipBounds();
        int height = clip.y + clip.height;
        if (rowCount * this.rowHeight < height) {
            for (int i = rowCount; i <= height / this.rowHeight; ++i) {
                g.setColor(this.colorForRow(i));
                g.fillRect(clip.x, i * this.rowHeight, clip.width, this.rowHeight);
            }
            if (System.getProperty("os.name").contains("Mac") && this.getShowVerticalLines()) {
                g.setColor(this.MAC_UNFOCUSED_UNSELECTED_VERTICAL_LINE_COLOR);
                TableColumnModel columnModel = this.getColumnModel();
                int x = 0;
                for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                    TableColumn column = columnModel.getColumn(i);
                    g.drawLine((x += column.getWidth()) - 1, rowCount * this.rowHeight, x - 1, height);
                }
            }
        }
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            JViewport parent = (JViewport)this.getParent();
            return parent.getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    protected Color colorForRow(int row) {
        return row % 2 == 0 ? this.alternateRowColor() : this.getBackground();
    }

    private Color alternateRowColor() {
        return UIManager.getLookAndFeel().getClass().getName().contains("GTK") ? Color.WHITE : this.MAC_OS_ALTERNATE_ROW_COLOR;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c2 = super.prepareRenderer(renderer, row, column);
        boolean focused = this.hasFocus();
        boolean selected = this.isCellSelected(row, column);
        if (selected) {
            if (System.getProperty("os.name").contains("Mac") && !focused) {
                c2.setBackground(this.MAC_UNFOCUSED_SELECTED_CELL_BACKGROUND_COLOR);
                c2.setForeground(UIManager.getColor("Table.foreground"));
            } else {
                c2.setBackground(UIManager.getColor("Table.selectionBackground"));
                c2.setForeground(UIManager.getColor("Table.selectionForeground"));
            }
        } else {
            c2.setBackground(this.colorForRow(row));
            c2.setForeground(UIManager.getColor("Table.foreground"));
        }
        if (c2 instanceof JComponent) {
            JComponent jc = (JComponent)c2;
            if (UIManager.getLookAndFeel().getClass().getName().contains("GTK") && c2 instanceof JCheckBox) {
                jc.setOpaque(true);
            }
            if (!this.getCellSelectionEnabled() && !this.isEditing()) {
                if (System.getProperty("os.name").contains("Mac")) {
                    this.fixMacOsCellRendererBorder(jc, selected, focused);
                } else {
                    jc.setBorder(null);
                }
            }
            this.initToolTip(jc, row, column);
        }
        return c2;
    }

    private void fixMacOsCellRendererBorder(JComponent renderer, boolean selected, boolean focused) {
        Border border = selected ? BorderFactory.createMatteBorder(0, 0, 1, 0, focused ? this.MAC_FOCUSED_SELECTED_CELL_HORIZONTAL_LINE_COLOR : this.MAC_UNFOCUSED_SELECTED_CELL_HORIZONTAL_LINE_COLOR) : BorderFactory.createEmptyBorder(0, 0, 1, 0);
        if (this.getShowVerticalLines()) {
            Color verticalLineColor = focused ? (selected ? this.MAC_FOCUSED_SELECTED_VERTICAL_LINE_COLOR : this.MAC_FOCUSED_UNSELECTED_VERTICAL_LINE_COLOR) : (selected ? this.MAC_UNFOCUSED_SELECTED_VERTICAL_LINE_COLOR : this.MAC_UNFOCUSED_UNSELECTED_VERTICAL_LINE_COLOR);
            MatteBorder verticalBorder = BorderFactory.createMatteBorder(0, 0, 0, 1, verticalLineColor);
            border = BorderFactory.createCompoundBorder(border, verticalBorder);
        }
        renderer.setBorder(border);
    }

    private void initToolTip(JComponent c2, int row, int column) {
        String toolTipText = null;
        if (c2.getPreferredSize().width > this.getCellRect((int)row, (int)column, (boolean)false).width) {
            toolTipText = this.getValueAt(row, column).toString();
        }
        c2.setToolTipText(toolTipText);
    }

    @Override
    public Point getToolTipLocation(MouseEvent e2) {
        if (this.getToolTipText(e2) == null) {
            return null;
        }
        int row = this.rowAtPoint(e2.getPoint());
        int column = this.columnAtPoint(e2.getPoint());
        if (row == -1 || column == -1) {
            return null;
        }
        return this.getCellRect(row, column, false).getLocation();
    }

    @Override
    protected void configureEnclosingScrollPane() {
        Container gp;
        super.configureEnclosingScrollPane();
        if (!System.getProperty("os.name").contains("Mac")) {
            return;
        }
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            Component renderer = new JTableHeader().getDefaultRenderer().getTableCellRendererComponent(null, "", false, false, -1, 0);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add(renderer, "Center");
            scrollPane.setCorner("UPPER_RIGHT_CORNER", panel);
        }
    }
}

