/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.lang.reflect.Array;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.core.SerializedObject;
import weka.filters.Filter;
import weka.gui.FileEditor;
import weka.gui.GenericObjectEditor;
import weka.gui.JListHelper;
import weka.gui.PropertyDialog;
import weka.gui.PropertyPanel;
import weka.gui.PropertyText;
import weka.gui.PropertyValueSelector;

public class GenericArrayEditor
implements PropertyEditor {
    private final CustomEditor m_customEditor = new CustomEditor();

    @Override
    public void setValue(Object o) {
        this.m_customEditor.updateEditorType(o);
    }

    @Override
    public Object getValue() {
        if (this.m_customEditor.m_ListModel == null) {
            return null;
        }
        int length = this.m_customEditor.m_ListModel.getSize();
        Object result = Array.newInstance(this.m_customEditor.m_ElementClass, length);
        for (int i = 0; i < length; ++i) {
            Array.set(result, i, this.m_customEditor.m_ListModel.elementAt(i));
        }
        return result;
    }

    @Override
    public String getJavaInitializationString() {
        return "null";
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        String rep = this.m_customEditor.m_ListModel.getSize() + " " + this.m_customEditor.m_ElementClass.getName();
        gfx.drawString(rep, 2, fm.getAscent() + vpad + 2);
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public void setAsText(String text) {
        throw new IllegalArgumentException(text);
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return this.m_customEditor;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_customEditor.m_Support.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_customEditor.m_Support.removePropertyChangeListener(l);
    }

    public static Object makeCopy(Object source) {
        Object result;
        try {
            result = GenericObjectEditor.makeCopy(source);
        }
        catch (Exception e2) {
            result = null;
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            GenericObjectEditor.registerEditors();
            GenericArrayEditor ce = new GenericArrayEditor();
            Filter[] initial = new Filter[]{};
            PropertyDialog pd = new PropertyDialog((Frame)null, (PropertyEditor)ce, 100, 100);
            pd.setSize(200, 200);
            pd.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e2) {
                    System.exit(0);
                }
            });
            ce.setValue(initial);
            pd.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    private class CustomEditor
    extends JPanel {
        private static final long serialVersionUID = 3914616975334750480L;
        private final PropertyChangeSupport m_Support;
        private final JLabel m_Label;
        private final JList m_ElementList;
        private Class<?> m_ElementClass;
        private DefaultListModel m_ListModel;
        private PropertyEditor m_ElementEditor;
        private final JButton m_DeleteBut;
        private final JButton m_EditBut;
        private final JButton m_UpBut;
        private final JButton m_DownBut;
        private final JButton m_AddBut;
        private PropertyEditor m_Editor;
        private PropertyDialog m_PD;
        private final ActionListener m_InnerActionListener;
        private final ListSelectionListener m_InnerSelectionListener;
        private final MouseListener m_InnerMouseListener;

        public CustomEditor() {
            this.m_Support = new PropertyChangeSupport(GenericArrayEditor.this);
            this.m_Label = new JLabel("Can't edit", 0);
            this.m_ElementList = new JList();
            this.m_ElementClass = String.class;
            this.m_DeleteBut = new JButton("Delete");
            this.m_EditBut = new JButton("Edit");
            this.m_UpBut = new JButton("Up");
            this.m_DownBut = new JButton("Down");
            this.m_AddBut = new JButton("Add");
            this.m_Editor = new GenericObjectEditor();
            this.m_InnerActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    if (e2.getSource() == CustomEditor.this.m_DeleteBut) {
                        int[] selected = CustomEditor.this.m_ElementList.getSelectedIndices();
                        if (selected != null) {
                            for (int i = selected.length - 1; i >= 0; --i) {
                                int current = selected[i];
                                CustomEditor.this.m_ListModel.removeElementAt(current);
                                if (CustomEditor.this.m_ListModel.size() <= current) continue;
                                CustomEditor.this.m_ElementList.setSelectedIndex(current);
                            }
                            CustomEditor.this.m_Support.firePropertyChange("", null, null);
                        }
                    } else if (e2.getSource() == CustomEditor.this.m_EditBut) {
                        if (CustomEditor.this.m_Editor instanceof GenericObjectEditor) {
                            ((GenericObjectEditor)CustomEditor.this.m_Editor).setClassType(CustomEditor.this.m_ElementClass);
                        }
                        try {
                            CustomEditor.this.m_Editor.setValue(GenericObjectEditor.makeCopy(CustomEditor.this.m_ElementList.getSelectedValue()));
                        }
                        catch (Exception ex) {
                            CustomEditor.this.m_Editor.setValue(CustomEditor.this.m_ElementList.getSelectedValue());
                        }
                        if (CustomEditor.this.m_Editor.getValue() != null) {
                            if (PropertyDialog.getParentDialog(CustomEditor.this) != null) {
                                CustomEditor.this.m_PD = new PropertyDialog(PropertyDialog.getParentDialog(CustomEditor.this), CustomEditor.this.m_Editor, -1, -1);
                            } else {
                                CustomEditor.this.m_PD = new PropertyDialog(PropertyDialog.getParentFrame(CustomEditor.this), CustomEditor.this.m_Editor, -1, -1);
                            }
                            CustomEditor.this.m_PD.setVisible(true);
                            if (!(CustomEditor.this.m_Editor instanceof GenericObjectEditor) || !((GenericObjectEditor)CustomEditor.this.m_Editor).wasCancelPressed()) {
                                CustomEditor.this.m_ListModel.set(CustomEditor.this.m_ElementList.getSelectedIndex(), CustomEditor.this.m_Editor.getValue());
                                CustomEditor.this.m_Support.firePropertyChange("", null, null);
                            }
                        }
                    } else if (e2.getSource() == CustomEditor.this.m_UpBut) {
                        JListHelper.moveUp(CustomEditor.this.m_ElementList);
                        CustomEditor.this.m_Support.firePropertyChange("", null, null);
                    } else if (e2.getSource() == CustomEditor.this.m_DownBut) {
                        JListHelper.moveDown(CustomEditor.this.m_ElementList);
                        CustomEditor.this.m_Support.firePropertyChange("", null, null);
                    } else if (e2.getSource() == CustomEditor.this.m_AddBut) {
                        int selected = CustomEditor.this.m_ElementList.getSelectedIndex();
                        Object addObj = CustomEditor.this.m_ElementEditor.getValue();
                        try {
                            SerializedObject so = new SerializedObject(addObj);
                            addObj = so.getObject();
                            if (selected != -1) {
                                CustomEditor.this.m_ListModel.insertElementAt(addObj, selected);
                            } else {
                                CustomEditor.this.m_ListModel.addElement(addObj);
                            }
                            CustomEditor.this.m_Support.firePropertyChange("", null, null);
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(CustomEditor.this, "Could not create an object copy", null, 0);
                        }
                    }
                }
            };
            this.m_InnerSelectionListener = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e2) {
                    if (e2.getSource() == CustomEditor.this.m_ElementList) {
                        if (CustomEditor.this.m_ElementList.getSelectedIndex() != -1) {
                            CustomEditor.this.m_DeleteBut.setEnabled(true);
                            CustomEditor.this.m_EditBut.setEnabled(CustomEditor.this.m_ElementList.getSelectedIndices().length == 1);
                            CustomEditor.this.m_UpBut.setEnabled(JListHelper.canMoveUp(CustomEditor.this.m_ElementList));
                            CustomEditor.this.m_DownBut.setEnabled(JListHelper.canMoveDown(CustomEditor.this.m_ElementList));
                        } else {
                            CustomEditor.this.m_DeleteBut.setEnabled(false);
                            CustomEditor.this.m_EditBut.setEnabled(false);
                            CustomEditor.this.m_UpBut.setEnabled(false);
                            CustomEditor.this.m_DownBut.setEnabled(false);
                        }
                    }
                }
            };
            this.m_InnerMouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e2) {
                    int index;
                    if (e2.getSource() == CustomEditor.this.m_ElementList && e2.getClickCount() == 2 && (index = CustomEditor.this.m_ElementList.locationToIndex(e2.getPoint())) > -1) {
                        CustomEditor.this.m_InnerActionListener.actionPerformed(new ActionEvent(CustomEditor.this.m_EditBut, 0, ""));
                    }
                }
            };
            this.setLayout(new BorderLayout());
            this.add((Component)this.m_Label, "Center");
            this.m_DeleteBut.addActionListener(this.m_InnerActionListener);
            this.m_EditBut.addActionListener(this.m_InnerActionListener);
            this.m_UpBut.addActionListener(this.m_InnerActionListener);
            this.m_DownBut.addActionListener(this.m_InnerActionListener);
            this.m_AddBut.addActionListener(this.m_InnerActionListener);
            this.m_ElementList.addListSelectionListener(this.m_InnerSelectionListener);
            this.m_ElementList.addMouseListener(this.m_InnerMouseListener);
            this.m_AddBut.setToolTipText("Add the current item to the list");
            this.m_DeleteBut.setToolTipText("Delete the selected list item");
            this.m_EditBut.setToolTipText("Edit the selected list item");
            this.m_UpBut.setToolTipText("Move the selected item(s) one up");
            this.m_DownBut.setToolTipText("Move the selected item(s) one down");
        }

        private void updateEditorType(Object o) {
            if (o != null && o.getClass().isArray()) {
                Class<?> elementClass = o.getClass().getComponentType();
                PropertyEditor editor = PropertyEditorManager.findEditor(elementClass);
                JComponent view = null;
                ListCellRenderer<Object> lcr = new DefaultListCellRenderer();
                if (editor != null) {
                    if (editor instanceof GenericObjectEditor) {
                        ((GenericObjectEditor)editor).setClassType(elementClass);
                    }
                    if (Array.getLength(o) > 0) {
                        editor.setValue(GenericArrayEditor.makeCopy(Array.get(o, 0)));
                    } else if (editor instanceof GenericObjectEditor) {
                        ((GenericObjectEditor)editor).setDefaultValue();
                    } else {
                        try {
                            if (editor instanceof FileEditor) {
                                editor.setValue(new File("-NONE-"));
                            } else {
                                editor.setValue(elementClass.newInstance());
                            }
                        }
                        catch (Exception ex) {
                            this.m_ElementEditor = null;
                            this.m_ListModel = null;
                            this.removeAll();
                            System.err.println(ex.getMessage());
                            this.add((Component)this.m_Label, "Center");
                            this.m_Support.firePropertyChange("", null, null);
                            this.validate();
                            return;
                        }
                    }
                    if (editor.isPaintable() && editor.supportsCustomEditor()) {
                        view = new PropertyPanel(editor);
                        lcr = new EditorListCellRenderer(editor.getClass(), elementClass);
                    } else if (editor.getTags() != null) {
                        view = new PropertyValueSelector(editor);
                    } else if (editor.getAsText() != null) {
                        view = new PropertyText(editor);
                    }
                }
                if (view == null) {
                    JOptionPane.showMessageDialog(this, "No property editor for class: " + elementClass.getName(), "Error...", 0);
                    return;
                }
                this.removeAll();
                this.m_ElementEditor = editor;
                try {
                    this.m_Editor = (PropertyEditor)editor.getClass().newInstance();
                }
                catch (InstantiationException e1) {
                    e1.printStackTrace();
                }
                catch (IllegalAccessException e1) {
                    e1.printStackTrace();
                }
                this.m_ListModel = new DefaultListModel();
                this.m_ElementClass = elementClass;
                for (int i = 0; i < Array.getLength(o); ++i) {
                    this.m_ListModel.addElement(Array.get(o, i));
                }
                this.m_ElementList.setCellRenderer(lcr);
                this.m_ElementList.setModel(this.m_ListModel);
                if (this.m_ListModel.getSize() > 0) {
                    this.m_ElementList.setSelectedIndex(0);
                } else {
                    this.m_DeleteBut.setEnabled(false);
                    this.m_EditBut.setEnabled(false);
                }
                this.m_UpBut.setEnabled(JListHelper.canMoveDown(this.m_ElementList));
                this.m_DownBut.setEnabled(JListHelper.canMoveDown(this.m_ElementList));
                JPanel panel = new JPanel();
                panel.setLayout(new BorderLayout());
                panel.add((Component)view, "Center");
                panel.add((Component)this.m_AddBut, "East");
                this.add((Component)panel, "North");
                this.add((Component)new JScrollPane(this.m_ElementList), "Center");
                JPanel panel2 = new JPanel();
                panel2.setLayout(new GridLayout(1, 4));
                panel2.add(this.m_DeleteBut);
                panel2.add(this.m_EditBut);
                panel2.add(this.m_UpBut);
                panel2.add(this.m_DownBut);
                this.add((Component)panel2, "South");
                this.m_ElementEditor.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e2) {
                        CustomEditor.this.repaint();
                    }
                });
            }
            if (this.m_ElementEditor == null) {
                this.add((Component)this.m_Label, "Center");
            }
            this.m_Support.firePropertyChange("", null, null);
            this.validate();
        }

        private class EditorListCellRenderer
        implements ListCellRenderer {
            private final Class<?> m_EditorClass;
            private final Class<?> m_ValueClass;

            public EditorListCellRenderer(Class<?> editorClass, Class<?> valueClass) {
                this.m_EditorClass = editorClass;
                this.m_ValueClass = valueClass;
            }

            public Component getListCellRendererComponent(final JList list, Object value, int index, final boolean isSelected, boolean cellHasFocus) {
                try {
                    final PropertyEditor e2 = (PropertyEditor)this.m_EditorClass.newInstance();
                    if (e2 instanceof GenericObjectEditor) {
                        ((GenericObjectEditor)e2).setClassType(this.m_ValueClass);
                    }
                    e2.setValue(value);
                    return new JPanel(){
                        private static final long serialVersionUID = -3124434678426673334L;

                        @Override
                        public void paintComponent(Graphics g) {
                            Insets i = this.getInsets();
                            Rectangle box = new Rectangle(i.left, i.top, this.getWidth() - i.right, this.getHeight() - i.bottom);
                            g.setColor(isSelected ? list.getSelectionBackground() : list.getBackground());
                            g.fillRect(0, 0, this.getWidth(), this.getHeight());
                            g.setColor(isSelected ? list.getSelectionForeground() : list.getForeground());
                            e2.paintValue(g, box);
                        }

                        @Override
                        public Dimension getPreferredSize() {
                            Font f = this.getFont();
                            FontMetrics fm = this.getFontMetrics(f);
                            return new Dimension(0, fm.getHeight());
                        }
                    };
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }
    }
}

