/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.Timer;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanConnection;
import weka.gui.beans.BeanInstance;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.Startable;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;

public class MetaBean
extends JPanel
implements BeanCommon,
Visible,
EventConstraints,
Serializable,
UserRequestAcceptor,
Startable {
    private static final long serialVersionUID = -6582768902038027077L;
    protected BeanVisual m_visual = new BeanVisual("Group", "weka/gui/beans/icons/DiamondPlain.gif", "weka/gui/beans/icons/DiamondPlain.gif");
    private transient Logger m_log = null;
    private transient JWindow m_previewWindow = null;
    private transient Timer m_previewTimer = null;
    protected Vector<Object> m_subFlow = new Vector();
    protected Vector<Object> m_inputs = new Vector();
    protected Vector<Object> m_outputs = new Vector();
    protected Vector<BeanConnection> m_associatedConnections = new Vector();
    protected ImageIcon m_subFlowPreview = null;
    protected int m_xCreate = 0;
    protected int m_yCreate = 0;
    protected int m_xDrop = 0;
    protected int m_yDrop = 0;
    private Vector<Point> m_originalCoords;

    public MetaBean() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    public void setAssociatedConnections(Vector<BeanConnection> ac) {
        this.m_associatedConnections = ac;
    }

    public Vector<BeanConnection> getAssociatedConnections() {
        return this.m_associatedConnections;
    }

    public void setSubFlow(Vector<Object> sub) {
        this.m_subFlow = sub;
    }

    public Vector<Object> getSubFlow() {
        return this.m_subFlow;
    }

    public void setInputs(Vector<Object> inputs) {
        this.m_inputs = inputs;
    }

    public Vector<Object> getInputs() {
        return this.m_inputs;
    }

    public void setOutputs(Vector<Object> outputs) {
        this.m_outputs = outputs;
    }

    public Vector<Object> getOutputs() {
        return this.m_outputs;
    }

    private Vector<Object> getBeans(Vector<Object> beans, int type) {
        Vector<Object> comps = new Vector<Object>();
        for (int i = 0; i < beans.size(); ++i) {
            BeanInstance temp = (BeanInstance)beans.elementAt(i);
            if (temp.getBean() instanceof MetaBean) {
                switch (type) {
                    case 0: {
                        comps.addAll(((MetaBean)temp.getBean()).getBeansInSubFlow());
                        break;
                    }
                    case 1: {
                        comps.addAll(((MetaBean)temp.getBean()).getBeansInInputs());
                        break;
                    }
                    case 2: {
                        comps.addAll(((MetaBean)temp.getBean()).getBeansInOutputs());
                    }
                }
                continue;
            }
            comps.add(temp);
        }
        return comps;
    }

    private boolean beanSetContains(Vector<Object> set, BeanInstance toCheck) {
        boolean ok = false;
        for (int i = 0; i < set.size(); ++i) {
            BeanInstance temp = (BeanInstance)set.elementAt(i);
            if (toCheck != temp) continue;
            ok = true;
            break;
        }
        return ok;
    }

    public boolean subFlowContains(BeanInstance toCheck) {
        return this.beanSetContains(this.m_subFlow, toCheck);
    }

    public boolean inputsContains(BeanInstance toCheck) {
        return this.beanSetContains(this.m_inputs, toCheck);
    }

    public boolean outputsContains(BeanInstance toCheck) {
        return this.beanSetContains(this.m_outputs, toCheck);
    }

    public Vector<Object> getBeansInSubFlow() {
        return this.getBeans(this.m_subFlow, 0);
    }

    public Vector<Object> getBeansInInputs() {
        return this.getBeans(this.m_inputs, 1);
    }

    public Vector<Object> getBeansInOutputs() {
        return this.getBeans(this.m_outputs, 2);
    }

    private Vector<BeanInfo> getBeanInfos(Vector<Object> beans, int type) {
        Vector<BeanInfo> infos = new Vector<BeanInfo>();
        for (int i = 0; i < beans.size(); ++i) {
            BeanInstance temp = (BeanInstance)beans.elementAt(i);
            if (temp.getBean() instanceof MetaBean) {
                switch (type) {
                    case 0: {
                        infos.addAll(((MetaBean)temp.getBean()).getBeanInfoSubFlow());
                        break;
                    }
                    case 1: {
                        infos.addAll(((MetaBean)temp.getBean()).getBeanInfoInputs());
                        break;
                    }
                    case 2: {
                        infos.addAll(((MetaBean)temp.getBean()).getBeanInfoOutputs());
                    }
                }
                continue;
            }
            try {
                infos.add(Introspector.getBeanInfo(temp.getBean().getClass()));
                continue;
            }
            catch (IntrospectionException ex) {
                ex.printStackTrace();
            }
        }
        return infos;
    }

    public Vector<BeanInfo> getBeanInfoSubFlow() {
        return this.getBeanInfos(this.m_subFlow, 0);
    }

    public Vector<BeanInfo> getBeanInfoInputs() {
        return this.getBeanInfos(this.m_inputs, 1);
    }

    public Vector<BeanInfo> getBeanInfoOutputs() {
        return this.getBeanInfos(this.m_outputs, 2);
    }

    public Vector<Point> getOriginalCoords() {
        return this.m_originalCoords;
    }

    public void setOriginalCoords(Vector<Point> value) {
        this.m_originalCoords = value;
    }

    public void shiftBeans(BeanInstance toShiftTo, boolean save) {
        if (save) {
            this.m_originalCoords = new Vector();
        }
        int targetX = toShiftTo.getX();
        int targetY = toShiftTo.getY();
        for (int i = 0; i < this.m_subFlow.size(); ++i) {
            BeanInstance temp = (BeanInstance)this.m_subFlow.elementAt(i);
            if (save) {
                Point p = new Point(temp.getX() - targetX, temp.getY() - targetY);
                this.m_originalCoords.add(p);
            }
            temp.setX(targetX);
            temp.setY(targetY);
        }
    }

    public void restoreBeans(int x, int y) {
        for (int i = 0; i < this.m_subFlow.size(); ++i) {
            BeanInstance temp = (BeanInstance)this.m_subFlow.elementAt(i);
            Point p = this.m_originalCoords.elementAt(i);
            JComponent c2 = (JComponent)temp.getBean();
            c2.getPreferredSize();
            temp.setX(x + (int)p.getX());
            temp.setY(y + (int)p.getY());
        }
    }

    public boolean eventGeneratable(EventSetDescriptor esd) {
        String eventName = esd.getName();
        return this.eventGeneratable(eventName);
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        for (int i = 0; i < this.m_subFlow.size(); ++i) {
            BeanInstance output = (BeanInstance)this.m_subFlow.elementAt(i);
            if (!(output.getBean() instanceof EventConstraints) || !((EventConstraints)output.getBean()).eventGeneratable(eventName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean connectionAllowed(EventSetDescriptor esd) {
        Vector<BeanInstance> targets = this.getSuitableTargets(esd);
        for (int i = 0; i < targets.size(); ++i) {
            BeanInstance input = targets.elementAt(i);
            if (input.getBean() instanceof BeanCommon) {
                if (!((BeanCommon)input.getBean()).connectionAllowed(esd)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean connectionAllowed(String eventName) {
        return false;
    }

    @Override
    public synchronized void connectionNotification(String eventName, Object source) {
    }

    @Override
    public synchronized void disconnectionNotification(String eventName, Object source) {
    }

    @Override
    public void stop() {
        for (int i = 0; i < this.m_subFlow.size(); ++i) {
            Object temp = this.m_subFlow.elementAt(i);
            if (!(temp instanceof BeanCommon)) continue;
            ((BeanCommon)temp).stop();
        }
    }

    @Override
    public boolean isBusy() {
        boolean result = false;
        for (int i = 0; i < this.m_subFlow.size(); ++i) {
            Object temp = this.m_subFlow.elementAt(i);
            if (!(temp instanceof BeanCommon) || !((BeanCommon)temp).isBusy()) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    @Override
    public BeanVisual getVisual() {
        return this.m_visual;
    }

    @Override
    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/DiamondPlain.gif", "weka/gui/beans/icons/DiamondPlain.gif");
    }

    @Override
    public String getStartMessage() {
        String message = "Start loading";
        for (int i = 0; i < this.m_subFlow.size(); ++i) {
            String s;
            BeanInstance temp = (BeanInstance)this.m_subFlow.elementAt(i);
            if (!(temp.getBean() instanceof Startable) || !(s = ((Startable)temp.getBean()).getStartMessage()).startsWith("$")) continue;
            message = "$" + message;
            break;
        }
        return message;
    }

    @Override
    public void start() {
        TreeMap<Integer, Startable> startables = new TreeMap<Integer, Startable>();
        for (int i = 0; i < this.m_subFlow.size(); ++i) {
            String beanName;
            BeanInstance temp = (BeanInstance)this.m_subFlow.elementAt(i);
            if (!(temp.getBean() instanceof Startable)) continue;
            Startable s = (Startable)temp.getBean();
            String customName = beanName = s.getClass().getName();
            boolean ok = false;
            Integer position = null;
            boolean launch = true;
            if (s instanceof BeanCommon) {
                beanName = customName = ((BeanCommon)((Object)s)).getCustomName();
                if (customName.indexOf(58) > 0) {
                    if (customName.substring(0, customName.indexOf(58)).startsWith("!")) {
                        launch = false;
                    } else {
                        String startPos = customName.substring(0, customName.indexOf(58));
                        try {
                            position = new Integer(startPos);
                            ok = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (!ok && launch) {
                if (startables.size() == 0) {
                    position = new Integer(0);
                } else {
                    int newPos = (Integer)startables.lastKey();
                    position = new Integer(++newPos);
                }
            }
            if (s.getStartMessage().charAt(0) == '$' || !launch) continue;
            if (this.m_log != null) {
                this.m_log.logMessage(this.statusMessagePrefix() + "adding start point " + beanName + " to the execution list (position " + position + ")");
            }
            startables.put(position, s);
        }
        if (startables.size() > 0) {
            if (this.m_log != null) {
                this.m_log.logMessage(this.statusMessagePrefix() + "Starting " + startables.size() + " sub-flow start points sequentially.");
            }
            Set s = startables.keySet();
            for (Integer i : s) {
                try {
                    Startable startPoint = (Startable)startables.get(i);
                    String bN = startPoint.getClass().getName();
                    if (startPoint instanceof BeanCommon) {
                        bN = ((BeanCommon)((Object)startPoint)).getCustomName();
                    }
                    if (this.m_log != null) {
                        this.m_log.statusMessage(this.statusMessagePrefix() + "Starting sub-flow start point: " + bN);
                        this.m_log.logMessage(this.statusMessagePrefix() + "Starting sub-flow start point: " + bN);
                    }
                    startPoint.start();
                    Thread.sleep(500L);
                    while (this.isBusy()) {
                        Thread.sleep(2000L);
                    }
                }
                catch (Exception ex) {
                    if (this.m_log != null) {
                        this.m_log.logMessage(this.statusMessagePrefix() + "A problem occurred when launching start points in sub-flow: " + ex.getMessage());
                    }
                    this.stop();
                    if (this.m_log == null) continue;
                    this.m_log.statusMessage(this.statusMessagePrefix() + "ERROR (see log for details)");
                }
            }
            if (this.m_log != null) {
                this.m_log.statusMessage(this.statusMessagePrefix() + "Finished.");
            }
        }
    }

    @Override
    public Enumeration<String> enumerateRequests() {
        Vector<String> newVector = new Vector<String>();
        if (this.m_subFlowPreview != null) {
            String text = "Show preview";
            if (this.m_previewWindow != null) {
                text = "$" + text;
            }
            newVector.addElement(text);
        }
        for (int i = 0; i < this.m_subFlow.size(); ++i) {
            String prefix;
            BeanInstance temp = (BeanInstance)this.m_subFlow.elementAt(i);
            if (temp.getBean() instanceof UserRequestAcceptor) {
                prefix = "";
                if (temp.getBean() instanceof BeanCommon) {
                    prefix = ((BeanCommon)temp.getBean()).getCustomName();
                } else {
                    prefix = temp.getBean().getClass().getName();
                    prefix = prefix.substring(prefix.lastIndexOf(46) + 1, prefix.length());
                }
                prefix = "" + (i + 1) + ": (" + prefix + ")";
                Enumeration<String> en = ((UserRequestAcceptor)temp.getBean()).enumerateRequests();
                while (en.hasMoreElements()) {
                    String req = en.nextElement();
                    if (req.charAt(0) == '$') {
                        prefix = '$' + prefix;
                        req = req.substring(1, req.length());
                    }
                    if (req.charAt(0) == '?') {
                        prefix = '?' + prefix;
                        req = req.substring(1, req.length());
                    }
                    newVector.add(prefix + " " + req);
                }
                continue;
            }
            if (!(temp.getBean() instanceof Startable)) continue;
            prefix = "";
            if (temp.getBean() instanceof BeanCommon) {
                prefix = ((BeanCommon)temp.getBean()).getCustomName();
            } else {
                prefix = temp.getBean().getClass().getName();
                prefix = prefix.substring(prefix.lastIndexOf(46) + 1, prefix.length());
            }
            prefix = "" + (i + 1) + ": (" + prefix + ")";
            String startMessage = ((Startable)temp.getBean()).getStartMessage();
            if (startMessage.charAt(0) == '$') {
                prefix = '$' + prefix;
                startMessage = startMessage.substring(1, startMessage.length());
            }
            newVector.add(prefix + " " + startMessage);
        }
        return newVector.elements();
    }

    public void setSubFlowPreview(ImageIcon sfp) {
        this.m_subFlowPreview = sfp;
    }

    private void showPreview() {
        if (this.m_previewWindow == null) {
            JLabel jl = new JLabel(this.m_subFlowPreview);
            jl.setLocation(0, 0);
            this.m_previewWindow = new JWindow();
            this.m_previewWindow.getContentPane().add(jl);
            this.m_previewWindow.validate();
            this.m_previewWindow.setSize(this.m_subFlowPreview.getIconWidth(), this.m_subFlowPreview.getIconHeight());
            this.m_previewWindow.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e2) {
                    MetaBean.this.m_previewWindow.dispose();
                    MetaBean.this.m_previewWindow = null;
                }
            });
            this.m_previewWindow.setLocation(this.getParent().getLocationOnScreen().x + this.getX() + this.getWidth() / 2 - this.m_subFlowPreview.getIconWidth() / 2, this.getParent().getLocationOnScreen().y + this.getY() + this.getHeight() / 2 - this.m_subFlowPreview.getIconHeight() / 2);
            this.m_previewWindow.setVisible(true);
            this.m_previewTimer = new Timer(8000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    if (MetaBean.this.m_previewWindow != null) {
                        MetaBean.this.m_previewWindow.dispose();
                        MetaBean.this.m_previewWindow = null;
                        MetaBean.this.m_previewTimer = null;
                    }
                }
            });
            this.m_previewTimer.setRepeats(false);
            this.m_previewTimer.start();
        }
    }

    @Override
    public void performRequest(String request) {
        Object target;
        if (request.compareTo("Show preview") == 0) {
            this.showPreview();
            return;
        }
        if (request.indexOf(":") < 0) {
            return;
        }
        String tempI = request.substring(0, request.indexOf(58));
        int index = Integer.parseInt(tempI);
        String req = request.substring(request.indexOf(41) + 1, request.length()).trim();
        if ((target = ((BeanInstance)this.m_subFlow.elementAt(--index)).getBean()) instanceof Startable && req.equals(((Startable)target).getStartMessage())) {
            try {
                ((Startable)target).start();
            }
            catch (Exception ex) {
                if (this.m_log != null) {
                    String compName = target instanceof BeanCommon ? ((BeanCommon)target).getCustomName() : "";
                    this.m_log.logMessage("Problem starting subcomponent " + compName);
                }
            }
        } else {
            ((UserRequestAcceptor)target).performRequest(req);
        }
    }

    @Override
    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    public void removePropertyChangeListenersSubFlow(PropertyChangeListener pcl) {
        for (int i = 0; i < this.m_subFlow.size(); ++i) {
            BeanInstance temp = (BeanInstance)this.m_subFlow.elementAt(i);
            if (temp.getBean() instanceof Visible) {
                ((Visible)temp.getBean()).getVisual().removePropertyChangeListener(pcl);
            }
            if (!(temp.getBean() instanceof MetaBean)) continue;
            ((MetaBean)temp.getBean()).removePropertyChangeListenersSubFlow(pcl);
        }
    }

    public void addPropertyChangeListenersSubFlow(PropertyChangeListener pcl) {
        for (int i = 0; i < this.m_subFlow.size(); ++i) {
            BeanInstance temp = (BeanInstance)this.m_subFlow.elementAt(i);
            if (temp.getBean() instanceof Visible) {
                ((Visible)temp.getBean()).getVisual().addPropertyChangeListener(pcl);
            }
            if (!(temp.getBean() instanceof MetaBean)) continue;
            ((MetaBean)temp.getBean()).addPropertyChangeListenersSubFlow(pcl);
        }
    }

    public boolean canAcceptConnection(Class<?> listenerClass) {
        for (int i = 0; i < this.m_inputs.size(); ++i) {
            BeanInstance input = (BeanInstance)this.m_inputs.elementAt(i);
            if (!listenerClass.isInstance(input.getBean())) continue;
            return true;
        }
        return false;
    }

    public Vector<BeanInstance> getSuitableTargets(EventSetDescriptor esd) {
        Class<?> listenerClass = esd.getListenerType();
        Vector<BeanInstance> targets = new Vector<BeanInstance>();
        for (int i = 0; i < this.m_inputs.size(); ++i) {
            BeanInstance input = (BeanInstance)this.m_inputs.elementAt(i);
            if (!listenerClass.isInstance(input.getBean())) continue;
            targets.add(input);
        }
        return targets;
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|";
    }
}

