/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instances;
import weka.gui.JListHelper;
import weka.gui.PropertySheetPanel;
import weka.gui.beans.BeanCustomizer;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.EnvironmentField;
import weka.gui.beans.FileEnvironmentField;
import weka.gui.beans.Sorter;

public class SorterCustomizer
extends JPanel
implements BeanCustomizer,
EnvironmentHandler,
CustomizerCloseRequester {
    private static final long serialVersionUID = -4860246697276275408L;
    protected Sorter m_sorter;
    protected Environment m_env = Environment.getSystemWide();
    protected BeanCustomizer.ModifyListener m_modifyL = null;
    protected JComboBox m_attCombo = new JComboBox();
    protected JComboBox m_descending = new JComboBox();
    protected EnvironmentField m_buffSize;
    protected FileEnvironmentField m_tempDir;
    protected Window m_parent;
    protected JList m_list = new JList();
    protected DefaultListModel m_listModel;
    protected JButton m_newBut = new JButton("New");
    protected JButton m_deleteBut = new JButton("Delete");
    protected JButton m_upBut = new JButton("Move up");
    protected JButton m_downBut = new JButton("Move down");
    protected PropertySheetPanel m_tempEditor = new PropertySheetPanel();

    public SorterCustomizer() {
        this.setLayout(new BorderLayout());
    }

    private void setup() {
        JPanel aboutAndControlHolder = new JPanel();
        aboutAndControlHolder.setLayout(new BorderLayout());
        JPanel controlHolder = new JPanel();
        controlHolder.setLayout(new BorderLayout());
        JPanel fieldHolder = new JPanel();
        fieldHolder.setLayout(new GridLayout(0, 2));
        JPanel attListP = new JPanel();
        attListP.setLayout(new BorderLayout());
        attListP.setBorder(BorderFactory.createTitledBorder("Sort on attribute"));
        attListP.add((Component)this.m_attCombo, "Center");
        this.m_attCombo.setEditable(true);
        this.m_attCombo.setToolTipText("<html>Accepts an attribute name, index or <br> the special string \"/first\" and \"/last\"</html>");
        this.m_descending.addItem("No");
        this.m_descending.addItem("Yes");
        JPanel descendingP = new JPanel();
        descendingP.setLayout(new BorderLayout());
        descendingP.setBorder(BorderFactory.createTitledBorder("Sort descending"));
        descendingP.add((Component)this.m_descending, "Center");
        fieldHolder.add(attListP);
        fieldHolder.add(descendingP);
        controlHolder.add((Component)fieldHolder, "North");
        JPanel otherControls = new JPanel();
        otherControls.setLayout(new GridLayout(0, 2));
        JLabel bufferSizeLab = new JLabel("Size of in-mem streaming buffer", 4);
        bufferSizeLab.setToolTipText("<html>Number of instances to sort in memory <br>before writing to a temp file <br>(instance connections only).</html>");
        otherControls.add(bufferSizeLab);
        this.m_buffSize = new EnvironmentField(this.m_env);
        otherControls.add(this.m_buffSize);
        JLabel tempDirLab = new JLabel("Directory for temp files", 4);
        tempDirLab.setToolTipText("Will use system tmp dir if left blank");
        otherControls.add(tempDirLab);
        this.m_tempDir = new FileEnvironmentField("", this.m_env, 0, true);
        this.m_tempDir.resetFileFilters();
        otherControls.add(this.m_tempDir);
        controlHolder.add((Component)otherControls, "South");
        aboutAndControlHolder.add((Component)controlHolder, "South");
        JPanel aboutP = this.m_tempEditor.getAboutPanel();
        aboutAndControlHolder.add((Component)aboutP, "North");
        this.add((Component)aboutAndControlHolder, "North");
        this.m_list.setVisibleRowCount(5);
        this.m_deleteBut.setEnabled(false);
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BorderLayout());
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new GridLayout(1, 0));
        butHolder.add(this.m_newBut);
        butHolder.add(this.m_deleteBut);
        butHolder.add(this.m_upBut);
        butHolder.add(this.m_downBut);
        this.m_upBut.setEnabled(false);
        this.m_downBut.setEnabled(false);
        listPanel.add((Component)butHolder, "North");
        JScrollPane js = new JScrollPane(this.m_list);
        js.setBorder(BorderFactory.createTitledBorder("Sort-by list (rows applied in order)"));
        listPanel.add((Component)js, "Center");
        this.add((Component)listPanel, "Center");
        this.addButtons();
        this.m_list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                if (!e2.getValueIsAdjusting()) {
                    Object entry;
                    if (!SorterCustomizer.this.m_deleteBut.isEnabled()) {
                        SorterCustomizer.this.m_deleteBut.setEnabled(true);
                    }
                    if ((entry = SorterCustomizer.this.m_list.getSelectedValue()) != null) {
                        Sorter.SortRule m = (Sorter.SortRule)entry;
                        SorterCustomizer.this.m_attCombo.setSelectedItem(m.getAttribute());
                        if (m.getDescending()) {
                            SorterCustomizer.this.m_descending.setSelectedIndex(1);
                        } else {
                            SorterCustomizer.this.m_descending.setSelectedIndex(0);
                        }
                    }
                }
            }
        });
        this.m_newBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Sorter.SortRule m = new Sorter.SortRule();
                String att = SorterCustomizer.this.m_attCombo.getSelectedItem() != null ? SorterCustomizer.this.m_attCombo.getSelectedItem().toString() : "";
                m.setAttribute(att);
                m.setDescending(SorterCustomizer.this.m_descending.getSelectedIndex() == 1);
                SorterCustomizer.this.m_listModel.addElement(m);
                if (SorterCustomizer.this.m_listModel.size() > 1) {
                    SorterCustomizer.this.m_upBut.setEnabled(true);
                    SorterCustomizer.this.m_downBut.setEnabled(true);
                }
                SorterCustomizer.this.m_list.setSelectedIndex(SorterCustomizer.this.m_listModel.size() - 1);
            }
        });
        this.m_deleteBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                int selected = SorterCustomizer.this.m_list.getSelectedIndex();
                if (selected >= 0) {
                    SorterCustomizer.this.m_listModel.removeElementAt(selected);
                    if (SorterCustomizer.this.m_listModel.size() <= 1) {
                        SorterCustomizer.this.m_upBut.setEnabled(false);
                        SorterCustomizer.this.m_downBut.setEnabled(false);
                    }
                }
            }
        });
        this.m_upBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JListHelper.moveUp(SorterCustomizer.this.m_list);
            }
        });
        this.m_downBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JListHelper.moveDown(SorterCustomizer.this.m_list);
            }
        });
        this.m_attCombo.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e2) {
                Component theEditor;
                Object m = SorterCustomizer.this.m_list.getSelectedValue();
                String text = "";
                if (SorterCustomizer.this.m_attCombo.getSelectedItem() != null) {
                    text = SorterCustomizer.this.m_attCombo.getSelectedItem().toString();
                }
                if ((theEditor = SorterCustomizer.this.m_attCombo.getEditor().getEditorComponent()) instanceof JTextField) {
                    text = ((JTextField)theEditor).getText();
                }
                if (m != null) {
                    ((Sorter.SortRule)m).setAttribute(text);
                    SorterCustomizer.this.m_list.repaint();
                }
            }
        });
        this.m_attCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Object m = SorterCustomizer.this.m_list.getSelectedValue();
                Object selected = SorterCustomizer.this.m_attCombo.getSelectedItem();
                if (m != null && selected != null) {
                    ((Sorter.SortRule)m).setAttribute(selected.toString());
                    SorterCustomizer.this.m_list.repaint();
                }
            }
        });
        this.m_descending.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Object m = SorterCustomizer.this.m_list.getSelectedValue();
                if (m != null) {
                    ((Sorter.SortRule)m).setDescending(SorterCustomizer.this.m_descending.getSelectedIndex() == 1);
                    SorterCustomizer.this.m_list.repaint();
                }
            }
        });
    }

    private void addButtons() {
        JButton okBut = new JButton("OK");
        JButton cancelBut = new JButton("Cancel");
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new GridLayout(1, 2));
        butHolder.add(okBut);
        butHolder.add(cancelBut);
        this.add((Component)butHolder, "South");
        okBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SorterCustomizer.this.closingOK();
                SorterCustomizer.this.m_parent.dispose();
            }
        });
        cancelBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SorterCustomizer.this.closingCancel();
                SorterCustomizer.this.m_parent.dispose();
            }
        });
    }

    protected void closingOK() {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.m_listModel.size(); ++i) {
            Sorter.SortRule m = (Sorter.SortRule)this.m_listModel.elementAt(i);
            buff.append(m.toStringInternal());
            if (i >= this.m_listModel.size() - 1) continue;
            buff.append("@@sort-rule@@");
        }
        if (this.m_sorter.getSortDetails() != null) {
            if (!this.m_sorter.getSortDetails().equals(buff.toString())) {
                this.m_modifyL.setModifiedStatus(this, true);
            }
        } else {
            this.m_modifyL.setModifiedStatus(this, true);
        }
        this.m_sorter.setSortDetails(buff.toString());
        if (this.m_buffSize.getText() != null && this.m_buffSize.getText().length() > 0) {
            if (this.m_sorter.getBufferSize() != null && !this.m_sorter.getBufferSize().equals(this.m_buffSize.getText())) {
                this.m_modifyL.setModifiedStatus(this, true);
            }
            this.m_sorter.setBufferSize(this.m_buffSize.getText());
        }
        if (this.m_tempDir.getText() != null && this.m_tempDir.getText().length() > 0) {
            if (this.m_sorter.getTempDirectory() != null && !this.m_sorter.getTempDirectory().equals(this.m_tempDir.getText())) {
                this.m_modifyL.setModifiedStatus(this, true);
            }
            this.m_sorter.setTempDirectory(this.m_tempDir.getText());
        }
    }

    protected void closingCancel() {
    }

    protected void initialize() {
        if (this.m_sorter.getBufferSize() != null && this.m_sorter.getBufferSize().length() > 0) {
            this.m_buffSize.setText(this.m_sorter.getBufferSize());
        }
        if (this.m_sorter.getTempDirectory() != null && this.m_sorter.getTempDirectory().length() > 0) {
            this.m_tempDir.setText(this.m_sorter.getTempDirectory());
        }
        String sString = this.m_sorter.getSortDetails();
        this.m_listModel = new DefaultListModel();
        this.m_list.setModel(this.m_listModel);
        if (sString != null && sString.length() > 0) {
            String[] parts = sString.split("@@sort-rule@@");
            if (parts.length > 0) {
                this.m_upBut.setEnabled(true);
                this.m_downBut.setEnabled(true);
                for (String sPart : parts) {
                    Sorter.SortRule s = new Sorter.SortRule(sPart);
                    this.m_listModel.addElement(s);
                }
            }
            this.m_list.repaint();
        }
        if (this.m_sorter.getConnectedFormat() != null) {
            Instances incoming = this.m_sorter.getConnectedFormat();
            this.m_attCombo.removeAllItems();
            for (int i = 0; i < incoming.numAttributes(); ++i) {
                this.m_attCombo.addItem(incoming.attribute(i).name());
            }
        }
    }

    @Override
    public void setObject(Object o) {
        if (o instanceof Sorter) {
            this.m_sorter = (Sorter)o;
            this.m_tempEditor.setTarget(o);
            this.setup();
            this.initialize();
        }
    }

    @Override
    public void setParentWindow(Window parent) {
        this.m_parent = parent;
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    @Override
    public void setModifiedListener(BeanCustomizer.ModifyListener l) {
        this.m_modifyL = l;
    }
}

