/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.core.Utils;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.ConverterUtils;
import weka.experiment.Experiment;
import weka.gui.ConverterFileChooser;
import weka.gui.JListHelper;
import weka.gui.ViewerDialog;
import weka.gui.experiment.ExperimenterDefaults;

public class DatasetListPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 7068857852794405769L;
    protected Experiment m_Exp;
    protected JList m_List;
    protected JButton m_AddBut = new JButton("Add new...");
    protected JButton m_EditBut = new JButton("Edit selected...");
    protected JButton m_DeleteBut = new JButton("Delete selected");
    protected JButton m_UpBut = new JButton("Up");
    protected JButton m_DownBut = new JButton("Down");
    protected JCheckBox m_relativeCheck = new JCheckBox("Use relative paths");
    protected ConverterFileChooser m_FileChooser = new ConverterFileChooser(ExperimenterDefaults.getInitialDatasetsDirectory());

    public DatasetListPanel(Experiment exp) {
        this();
        this.setExperiment(exp);
    }

    public DatasetListPanel() {
        this.m_List = new JList();
        this.m_List.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                DatasetListPanel.this.setButtons(e2);
            }
        });
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                int index;
                if (e2.getClickCount() == 2 && (index = DatasetListPanel.this.m_List.locationToIndex(e2.getPoint())) > -1) {
                    DatasetListPanel.this.actionPerformed(new ActionEvent(DatasetListPanel.this.m_EditBut, 0, ""));
                }
            }
        };
        this.m_List.addMouseListener(mouseListener);
        this.m_FileChooser.setCoreConvertersOnly(true);
        this.m_FileChooser.setMultiSelectionEnabled(true);
        this.m_FileChooser.setFileSelectionMode(2);
        this.m_FileChooser.setAcceptAllFileFilterUsed(false);
        this.m_DeleteBut.setEnabled(false);
        this.m_DeleteBut.addActionListener(this);
        this.m_AddBut.setEnabled(false);
        this.m_AddBut.addActionListener(this);
        this.m_EditBut.setEnabled(false);
        this.m_EditBut.addActionListener(this);
        this.m_UpBut.setEnabled(false);
        this.m_UpBut.addActionListener(this);
        this.m_DownBut.setEnabled(false);
        this.m_DownBut.addActionListener(this);
        this.m_relativeCheck.setSelected(ExperimenterDefaults.getUseRelativePaths());
        this.m_relativeCheck.setToolTipText("Store file paths relative to the start directory");
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Datasets"));
        JPanel topLab = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        topLab.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        topLab.setLayout(gb);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(0, 2, 0, 2);
        topLab.add((Component)this.m_AddBut, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        topLab.add((Component)this.m_EditBut, constraints);
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        topLab.add((Component)this.m_DeleteBut, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(0, 2, 0, 2);
        topLab.add((Component)this.m_relativeCheck, constraints);
        JPanel bottomLab = new JPanel();
        gb = new GridBagLayout();
        constraints = new GridBagConstraints();
        bottomLab.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        bottomLab.setLayout(gb);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(0, 2, 0, 2);
        bottomLab.add((Component)this.m_UpBut, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        bottomLab.add((Component)this.m_DownBut, constraints);
        this.add((Component)topLab, "North");
        this.add((Component)new JScrollPane(this.m_List), "Center");
        this.add((Component)bottomLab, "South");
    }

    private void setButtons(ListSelectionEvent e2) {
        if (e2 == null || e2.getSource() == this.m_List) {
            this.m_DeleteBut.setEnabled(this.m_List.getSelectedIndex() > -1);
            this.m_EditBut.setEnabled(this.m_List.getSelectedIndices().length == 1);
            this.m_UpBut.setEnabled(JListHelper.canMoveUp(this.m_List));
            this.m_DownBut.setEnabled(JListHelper.canMoveDown(this.m_List));
        }
    }

    public void setExperiment(Experiment exp) {
        this.m_Exp = exp;
        this.m_List.setModel(this.m_Exp.getDatasets());
        this.m_AddBut.setEnabled(true);
        this.setButtons(null);
    }

    protected void getFilesRecursively(File directory, Vector<File> files) {
        try {
            String[] currentDirFiles = directory.list();
            for (int i = 0; i < currentDirFiles.length; ++i) {
                currentDirFiles[i] = directory.getCanonicalPath() + File.separator + currentDirFiles[i];
                File current = new File(currentDirFiles[i]);
                if (!this.m_FileChooser.getFileFilter().accept(current)) continue;
                if (current.isDirectory()) {
                    this.getFilesRecursively(current, files);
                    continue;
                }
                files.addElement(current);
            }
        }
        catch (Exception e2) {
            System.err.println("IOError occured when reading list of files");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        boolean useRelativePaths = this.m_relativeCheck.isSelected();
        if (e2.getSource() == this.m_AddBut) {
            int returnVal = this.m_FileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                if (this.m_FileChooser.isMultiSelectionEnabled()) {
                    File[] selected;
                    for (File element : selected = this.m_FileChooser.getSelectedFiles()) {
                        if (element.isDirectory()) {
                            Vector<File> files = new Vector<File>();
                            this.getFilesRecursively(element, files);
                            Collections.sort(files);
                            for (int j = 0; j < files.size(); ++j) {
                                File temp = files.elementAt(j);
                                if (useRelativePaths) {
                                    try {
                                        temp = Utils.convertToRelativePath(temp);
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                }
                                this.m_Exp.getDatasets().addElement(temp);
                            }
                            continue;
                        }
                        File temp = element;
                        if (useRelativePaths) {
                            try {
                                temp = Utils.convertToRelativePath(temp);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        this.m_Exp.getDatasets().addElement(temp);
                    }
                    this.setButtons(null);
                } else {
                    if (this.m_FileChooser.getSelectedFile().isDirectory()) {
                        Vector<File> files = new Vector<File>();
                        this.getFilesRecursively(this.m_FileChooser.getSelectedFile(), files);
                        Collections.sort(files);
                        for (int j = 0; j < files.size(); ++j) {
                            File temp = files.elementAt(j);
                            if (useRelativePaths) {
                                try {
                                    temp = Utils.convertToRelativePath(temp);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                            this.m_Exp.getDatasets().addElement(temp);
                        }
                    } else {
                        File temp = this.m_FileChooser.getSelectedFile();
                        if (useRelativePaths) {
                            try {
                                temp = Utils.convertToRelativePath(temp);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        this.m_Exp.getDatasets().addElement(temp);
                    }
                    this.setButtons(null);
                }
            }
        } else if (e2.getSource() == this.m_DeleteBut) {
            int[] selected = this.m_List.getSelectedIndices();
            if (selected != null) {
                for (int i = selected.length - 1; i >= 0; --i) {
                    int current = selected[i];
                    this.m_Exp.getDatasets().removeElementAt(current);
                    if (this.m_Exp.getDatasets().size() > current) {
                        this.m_List.setSelectedIndex(current);
                        continue;
                    }
                    this.m_List.setSelectedIndex(current - 1);
                }
            }
            this.setButtons(null);
        } else if (e2.getSource() == this.m_EditBut) {
            int selected = this.m_List.getSelectedIndex();
            if (selected != -1) {
                ViewerDialog dialog = new ViewerDialog(null);
                String filename = this.m_List.getSelectedValue().toString();
                try {
                    ConverterUtils.DataSource source = new ConverterUtils.DataSource(filename);
                    int result = dialog.showDialog(source.getDataSet());
                    source = null;
                    System.gc();
                    if (result == 0 && dialog.isChanged() && (result = JOptionPane.showConfirmDialog(this, "File was modified - save changes?")) == 0) {
                        AbstractFileSaver saver = ConverterUtils.getSaverForFile(filename);
                        saver.setFile(new File(filename));
                        saver.setInstances(dialog.getInstances());
                        saver.writeBatch();
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, "Error loading file '" + filename + "':\n" + ex.toString(), "Error loading file", 1);
                }
            }
            this.setButtons(null);
        } else if (e2.getSource() == this.m_UpBut) {
            JListHelper.moveUp(this.m_List);
        } else if (e2.getSource() == this.m_DownBut) {
            JListHelper.moveDown(this.m_List);
        }
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame("Dataset List Editor");
            jf.getContentPane().setLayout(new BorderLayout());
            DatasetListPanel dp = new DatasetListPanel();
            jf.getContentPane().add((Component)dp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e2) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
            System.err.println("Short nap");
            Thread.sleep(3000L);
            System.err.println("Done");
            dp.setExperiment(new Experiment());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

