/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import weka.gui.knowledgeflow.InvisibleNode;
import weka.gui.knowledgeflow.StepTree;

public class DesignPanel
extends JPanel {
    private static final long serialVersionUID = 3324733191950871564L;

    public DesignPanel(final StepTree stepTree) {
        this.setLayout(new BorderLayout());
        JScrollPane treeView = new JScrollPane(stepTree);
        this.setBorder(BorderFactory.createTitledBorder("Design"));
        this.add((Component)treeView, "Center");
        final JTextField searchField = new JTextField();
        this.add((Component)searchField, "North");
        searchField.setToolTipText("Search (clear field to reset)");
        searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e2) {
                String searchTerm = searchField.getText();
                ArrayList<DefaultMutableTreeNode> nonhits = new ArrayList<DefaultMutableTreeNode>();
                ArrayList<DefaultMutableTreeNode> hits = new ArrayList<DefaultMutableTreeNode>();
                DefaultTreeModel model = (DefaultTreeModel)stepTree.getModel();
                model.reload();
                for (Map.Entry<String, DefaultMutableTreeNode> entry : stepTree.getNodeTextIndex().entrySet()) {
                    if (entry.getValue() instanceof InvisibleNode) {
                        ((InvisibleNode)entry.getValue()).setVisible(true);
                    }
                    if (searchTerm == null || searchTerm.length() <= 0) continue;
                    if (entry.getKey().contains(searchTerm.toLowerCase())) {
                        hits.add(entry.getValue());
                        continue;
                    }
                    nonhits.add(entry.getValue());
                }
                if (searchTerm == null || searchTerm.length() == 0) {
                    model.reload();
                }
                if (hits.size() > 0) {
                    for (DefaultMutableTreeNode h : nonhits) {
                        if (!(h instanceof InvisibleNode)) continue;
                        ((InvisibleNode)h).setVisible(false);
                    }
                    model.reload();
                    for (DefaultMutableTreeNode h : hits) {
                        Object[] path = model.getPathToRoot(h);
                        TreePath tpath = new TreePath(path);
                        tpath = tpath.getParentPath();
                        stepTree.expandPath(tpath);
                    }
                }
            }
        });
    }
}

