/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow.steps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import weka.gui.InteractiveTableModel;
import weka.gui.InteractiveTablePanel;
import weka.gui.knowledgeflow.StepEditorDialog;
import weka.knowledgeflow.steps.StorePropertiesInEnvironment;

public class StorePropertiesInEnvironmentStepEditorDialog
extends StepEditorDialog {
    private static final long serialVersionUID = 3797813883697010599L;
    protected DynamicPropertiesPanel m_dpp;

    @Override
    protected void layoutEditor() {
        String internalRep = ((StorePropertiesInEnvironment)this.getStepToEdit()).getPropsInternalRep();
        Map<String, List<String>> props = StorePropertiesInEnvironment.internalDynamicToMap(internalRep);
        this.m_dpp = new DynamicPropertiesPanel(props);
        this.add((Component)this.m_dpp, "Center");
    }

    @Override
    public void okPressed() {
        String dps = this.m_dpp.getPropertiesInternal();
        ((StorePropertiesInEnvironment)this.getStepToEdit()).setPropsInternalRep(dps);
    }

    protected static class DynamicPropertiesPanel
    extends JPanel {
        private static final long serialVersionUID = 5864117781960584665L;
        protected InteractiveTablePanel m_table = new InteractiveTablePanel(new String[]{"Attribute name/index", "Target step", "Property name", "Default property value", ""});

        public DynamicPropertiesPanel(Map<String, List<String>> props) {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createTitledBorder("Properties to set from incoming instances"));
            this.add((Component)this.m_table, "Center");
            int row = 0;
            JTable table = this.m_table.getTable();
            for (Map.Entry<String, List<String>> e2 : props.entrySet()) {
                String attName = e2.getKey();
                String stepName = e2.getValue().get(0);
                String propName = e2.getValue().get(1);
                String defaultVal = e2.getValue().get(2);
                if (stepName == null || stepName.length() <= 0 || attName == null || attName.length() <= 0) continue;
                table.getModel().setValueAt(attName, row, 0);
                table.getModel().setValueAt(stepName, row, 1);
                table.getModel().setValueAt(propName, row, 2);
                table.getModel().setValueAt(defaultVal, row, 3);
                ((InteractiveTableModel)table.getModel()).addEmptyRow();
                ++row;
            }
        }

        public String getPropertiesInternal() {
            StringBuilder b2 = new StringBuilder();
            JTable table = this.m_table.getTable();
            int numRows = table.getModel().getRowCount();
            for (int i = 0; i < numRows; ++i) {
                String attName = table.getValueAt(i, 0).toString();
                String stepName = table.getValueAt(i, 1).toString();
                String propName = table.getValueAt(i, 2).toString();
                String defVal = table.getValueAt(i, 3).toString();
                if (stepName.trim().length() > 0 && attName.trim().length() > 0) {
                    if (propName.length() == 0) {
                        propName = " ";
                    }
                    if (defVal.length() == 0) {
                        defVal = " ";
                    }
                    b2.append(attName).append("@a@a").append(stepName).append("@a@a").append(propName).append("@a@a").append(defVal);
                }
                if (i >= numRows - 1) continue;
                b2.append("@@vv@@");
            }
            return b2.toString();
        }
    }
}

