/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.sql;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import weka.gui.JTableHelper;
import weka.gui.sql.ResultSetTableCellRenderer;
import weka.gui.sql.ResultSetTableModel;

public class ResultSetTable
extends JTable {
    private static final long serialVersionUID = -3391076671854464137L;
    protected String m_Query;
    protected String m_URL;
    protected String m_User;
    protected String m_Password;

    public ResultSetTable(String url, String user, String pw, String query, ResultSetTableModel model) {
        super(model);
        this.m_URL = url;
        this.m_User = user;
        this.m_Password = pw;
        this.m_Query = query;
        this.setAutoResizeMode(0);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            JTableHelper.setOptimalHeaderWidth(this, i);
            this.getColumnModel().getColumn(i).setCellRenderer(new ResultSetTableCellRenderer());
        }
        final ResultSetTable table = this;
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                TableColumnModel columnModel = ResultSetTable.this.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e2.getX());
                int column = ResultSetTable.this.convertColumnIndexToModel(viewColumn);
                if (e2.getButton() == 1 && e2.getClickCount() == 2 && column != -1) {
                    JTableHelper.setOptimalColumnWidth(table, column);
                }
            }
        });
        this.getTableHeader().setToolTipText("double left click on column displays the column with optimal width");
    }

    public String getURL() {
        return this.m_URL;
    }

    public String getUser() {
        return this.m_User;
    }

    public String getPassword() {
        return this.m_Password;
    }

    public String getQuery() {
        return this.m_Query;
    }

    public void finalize() throws Throwable {
        if (this.getModel() != null) {
            ((ResultSetTableModel)this.getModel()).finalize();
        }
        super.finalize();
        System.gc();
    }
}

