/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weka.gui.sql.SqlViewer;
import weka.gui.sql.event.ResultChangedEvent;
import weka.gui.sql.event.ResultChangedListener;

public class SqlViewerDialog
extends JDialog
implements ResultChangedListener {
    private static final long serialVersionUID = -31619864037233099L;
    protected JFrame m_Parent;
    protected SqlViewer m_Viewer;
    protected JPanel m_PanelButtons;
    protected JButton m_ButtonOK = new JButton("OK");
    protected JButton m_ButtonCancel = new JButton("Cancel");
    protected JLabel m_LabelQuery = new JLabel("");
    protected JCheckBox m_CheckBoxSparseData = new JCheckBox("Generate sparse data");
    protected int m_ReturnValue = 2;
    protected String m_URL;
    protected String m_User;
    protected String m_Password;
    protected String m_Query;

    public SqlViewerDialog(JFrame parent) {
        super((Window)parent, "SQL-Viewer", Dialog.ModalityType.DOCUMENT_MODAL);
        this.m_Parent = parent;
        this.m_URL = "";
        this.m_User = "";
        this.m_Password = "";
        this.m_Query = "";
        this.createDialog();
    }

    protected void createDialog() {
        final SqlViewerDialog dialog = this;
        this.setLayout(new BorderLayout());
        this.m_Viewer = new SqlViewer(this.m_Parent);
        this.add((Component)this.m_Viewer, "Center");
        JPanel panel2 = new JPanel(new BorderLayout());
        this.add((Component)panel2, "South");
        JPanel panel = new JPanel(new FlowLayout(2));
        panel2.add((Component)panel, "East");
        this.m_ButtonOK.setMnemonic('O');
        panel.add(this.m_ButtonOK);
        this.m_ButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SqlViewerDialog.this.m_ReturnValue = 0;
                SqlViewerDialog.this.m_Viewer.removeResultChangedListener(dialog);
                SqlViewerDialog.this.m_Viewer.saveSize();
                dialog.dispose();
            }
        });
        this.m_ButtonCancel.setMnemonic('C');
        panel.add(this.m_ButtonCancel);
        this.m_ButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SqlViewerDialog.this.m_ReturnValue = 2;
                SqlViewerDialog.this.m_Viewer.removeResultChangedListener(dialog);
                SqlViewerDialog.this.m_Viewer.saveSize();
                dialog.dispose();
            }
        });
        panel = new JPanel(new FlowLayout(0));
        panel2.add((Component)panel, "West");
        panel.add(this.m_CheckBoxSparseData);
        this.m_CheckBoxSparseData.setMnemonic('s');
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                SqlViewerDialog.this.m_Viewer.saveSize();
            }
        });
        panel = new JPanel(new FlowLayout(1));
        panel2.add((Component)panel, "Center");
        panel.add(this.m_LabelQuery);
        this.pack();
        this.getRootPane().setDefaultButton(this.m_ButtonOK);
        this.setResizable(true);
        this.m_Viewer.addResultChangedListener(this);
    }

    @Override
    public void setVisible(boolean b2) {
        if (b2) {
            this.m_ReturnValue = 2;
        }
        super.setVisible(b2);
        if (b2) {
            this.m_Viewer.clear();
        }
    }

    public int getReturnValue() {
        return this.m_ReturnValue;
    }

    public String getURL() {
        return this.m_URL;
    }

    public String getUser() {
        return this.m_User;
    }

    public String getPassword() {
        return this.m_Password;
    }

    public String getQuery() {
        return this.m_Query;
    }

    public boolean getGenerateSparseData() {
        return this.m_CheckBoxSparseData.isSelected();
    }

    @Override
    public void resultChanged(ResultChangedEvent evt) {
        this.m_URL = evt.getURL();
        this.m_User = evt.getUser();
        this.m_Password = evt.getPassword();
        this.m_Query = evt.getQuery();
        this.m_LabelQuery.setText("Current query: " + this.m_Query);
    }

    public static void main(String[] args) {
        SqlViewerDialog dialog = new SqlViewerDialog(null);
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
        System.out.println("ReturnValue = " + dialog.getReturnValue());
        if (dialog.getReturnValue() == 0) {
            System.out.println("URL      = " + dialog.getURL());
            System.out.println("User     = " + dialog.getUser());
            System.out.println("Password = " + dialog.getPassword().replaceAll(".", "*"));
            System.out.println("Query    = " + dialog.getQuery());
        }
    }
}

