/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.treevisualizer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.io.StringReader;
import java.util.Vector;
import weka.core.Instances;
import weka.gui.treevisualizer.Edge;

public class Node {
    private int m_shape;
    private Color m_color;
    private final String m_label;
    private final Vector<String> m_lines;
    private double m_center;
    private double m_top;
    private boolean m_cVisible;
    private boolean m_visible;
    private boolean m_root;
    private final Vector<Edge> m_parent;
    private final Vector<Edge> m_children;
    private String m_refer;
    private String m_data;
    private Instances m_theData;

    public Node(String label, String refer, int backstyle, int shape, Color color, String d2) {
        this.m_label = label;
        this.m_shape = shape;
        this.m_color = color;
        this.m_refer = refer;
        this.m_center = 0.0;
        this.m_top = 0.0;
        this.m_cVisible = true;
        this.m_visible = true;
        this.m_root = false;
        this.m_parent = new Vector(1, 1);
        this.m_children = new Vector(20, 10);
        this.m_lines = new Vector(4, 2);
        this.breakupLabel();
        this.m_data = d2;
        this.m_theData = null;
    }

    public Instances getInstances() {
        if (this.m_theData == null && this.m_data != null) {
            try {
                this.m_theData = new Instances(new StringReader(this.m_data));
            }
            catch (Exception e2) {
                System.out.println("Error : " + e2);
            }
            this.m_data = null;
        }
        return this.m_theData;
    }

    public boolean getCVisible() {
        return this.m_cVisible;
    }

    private void childVis(Node r) {
        r.setVisible(true);
        if (r.getCVisible()) {
            Edge e2;
            int noa = 0;
            while ((e2 = r.getChild(noa)) != null) {
                this.childVis(e2.getTarget());
                ++noa;
            }
        }
    }

    public void setCVisible(boolean v) {
        this.m_cVisible = v;
        if (v) {
            this.childVis(this);
        } else if (!v) {
            this.childInv(this);
        }
    }

    private void childInv(Node r) {
        Edge e2;
        int noa = 0;
        while ((e2 = r.getChild(noa)) != null) {
            Node s = e2.getTarget();
            s.setVisible(false);
            this.childInv(s);
            ++noa;
        }
    }

    public String getRefer() {
        return this.m_refer;
    }

    public void setRefer(String v) {
        this.m_refer = v;
    }

    public int getShape() {
        return this.m_shape;
    }

    public void setShape(int v) {
        this.m_shape = v;
    }

    public Color getColor() {
        return this.m_color;
    }

    public void setColor(Color v) {
        this.m_color = v;
    }

    public String getLabel() {
        return this.m_label;
    }

    private void breakupLabel() {
        int noa;
        int prev = 0;
        for (noa = 0; noa < this.m_label.length(); ++noa) {
            if (this.m_label.charAt(noa) != '\n') continue;
            this.m_lines.addElement(this.m_label.substring(prev, noa));
            prev = noa + 1;
        }
        this.m_lines.addElement(this.m_label.substring(prev, noa));
    }

    public Dimension stringSize(FontMetrics f) {
        String s;
        Dimension d2 = new Dimension();
        int old = 0;
        int noa = 0;
        while ((s = this.getLine(noa)) != null) {
            ++noa;
            old = f.stringWidth(s);
            if (old <= d2.width) continue;
            d2.width = old;
        }
        d2.height = noa * f.getHeight();
        return d2;
    }

    public String getLine(int n) {
        if (n < this.m_lines.size()) {
            return this.m_lines.elementAt(n);
        }
        return null;
    }

    public double getCenter() {
        return this.m_center;
    }

    public void setCenter(double v) {
        this.m_center = v;
    }

    public void adjustCenter(double v) {
        this.m_center += v;
    }

    public double getTop() {
        return this.m_top;
    }

    public void setTop(double v) {
        this.m_top = v;
    }

    public boolean getVisible() {
        return this.m_visible;
    }

    private void setVisible(boolean v) {
        this.m_visible = v;
    }

    public boolean getRoot() {
        return this.m_root;
    }

    public void setRoot(boolean v) {
        this.m_root = v;
    }

    public Edge getParent(int i) {
        if (i < this.m_parent.size()) {
            return this.m_parent.elementAt(i);
        }
        return null;
    }

    public void setParent(Edge v) {
        this.m_parent.addElement(v);
    }

    public Edge getChild(int i) {
        if (i < this.m_children.size()) {
            return this.m_children.elementAt(i);
        }
        return null;
    }

    public void addChild(Edge v) {
        this.m_children.addElement(v);
    }

    public static int getGCount(Node r, int n) {
        if (r.getChild(0) != null && r.getCVisible()) {
            Edge e2;
            ++n;
            int noa = 0;
            while ((e2 = r.getChild(noa)) != null) {
                n = Node.getGCount(e2.getTarget(), n);
                ++noa;
            }
        }
        return n;
    }

    public static int getTotalGCount(Node r, int n) {
        if (r.getChild(0) != null) {
            Edge e2;
            ++n;
            int noa = 0;
            while ((e2 = r.getChild(noa)) != null) {
                n = Node.getTotalGCount(e2.getTarget(), n);
                ++noa;
            }
        }
        return n;
    }

    public static int getCount(Node r, int n) {
        Edge e2;
        ++n;
        int noa = 0;
        while ((e2 = r.getChild(noa)) != null && r.getCVisible()) {
            n = Node.getCount(e2.getTarget(), n);
            ++noa;
        }
        return n;
    }

    public static int getTotalCount(Node r, int n) {
        Edge e2;
        ++n;
        int noa = 0;
        while ((e2 = r.getChild(noa)) != null) {
            n = Node.getTotalCount(e2.getTarget(), n);
            ++noa;
        }
        return n;
    }

    public static int getHeight(Node r, int l) {
        Edge e2;
        int lev = ++l;
        int temp = 0;
        int noa = 0;
        while ((e2 = r.getChild(noa)) != null && r.getCVisible()) {
            temp = Node.getHeight(e2.getTarget(), l);
            if (temp > lev) {
                lev = temp;
            }
            ++noa;
        }
        return lev;
    }

    public static int getTotalHeight(Node r, int l) {
        Edge e2;
        int lev = ++l;
        int temp = 0;
        int noa = 0;
        while ((e2 = r.getChild(noa)) != null) {
            temp = Node.getTotalHeight(e2.getTarget(), l);
            if (temp > lev) {
                lev = temp;
            }
            ++noa;
        }
        return lev;
    }
}

