/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JComponent;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeBuild;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.JComponentWriter;

public class JPEGWriter
extends JComponentWriter {
    protected float m_Quality;
    protected Color m_Background;

    public JPEGWriter() {
    }

    public JPEGWriter(JComponent c2) {
        super(c2);
    }

    public JPEGWriter(JComponent c2, File f) {
        super(c2, f);
        this.m_Quality = 1.0f;
        this.m_Background = Color.WHITE;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.m_Quality = 1.0f;
        this.m_Background = Color.WHITE;
        this.setScalingEnabled(false);
    }

    @Override
    public String getDescription() {
        return "JPEG-Image";
    }

    @Override
    public String getExtension() {
        return ".jpg";
    }

    public Color getBackground() {
        return this.m_Background;
    }

    public void setBackground(Color c2) {
        this.m_Background = c2;
    }

    public float getQuality() {
        return this.m_Quality;
    }

    public void setQuality(float q) {
        this.m_Quality = q;
    }

    @Override
    public void generateOutput() throws Exception {
        BufferedImage bi = new BufferedImage(this.getComponent().getWidth(), this.getComponent().getHeight(), 1);
        Graphics g = bi.getGraphics();
        g.setPaintMode();
        g.setColor(this.getBackground());
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).scale(this.getXScale(), this.getYScale());
        }
        g.fillRect(0, 0, this.getComponent().getWidth(), this.getComponent().getHeight());
        this.getComponent().printAll(g);
        ImageWriter writer = null;
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(this.getExtension().replace(".", ""));
        if (!iter.hasNext()) {
            throw new Exception("No writer available for " + this.getDescription() + "!");
        }
        writer = iter.next();
        ImageOutputStream ios = ImageIO.createImageOutputStream(this.getFile());
        writer.setOutput(ios);
        JPEGImageWriteParam param = new JPEGImageWriteParam(Locale.getDefault());
        param.setCompressionMode(2);
        param.setCompressionQuality(this.getQuality());
        writer.write(null, new IIOImage(bi, null, null), param);
        ios.flush();
        writer.dispose();
        ios.close();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("building TreeVisualizer...");
        TreeBuild builder = new TreeBuild();
        PlaceNode2 arrange = new PlaceNode2();
        Node top = builder.create(new StringReader("digraph atree { top [label=\"the top\"] a [label=\"the first node\"] b [label=\"the second nodes\"] c [label=\"comes off of first\"] top->a top->b b->c }"));
        TreeVisualizer tv = new TreeVisualizer(null, top, (NodePlace)arrange);
        tv.setSize(800, 600);
        String filename = System.getProperty("java.io.tmpdir") + File.separator + "test.jpg";
        System.out.println("outputting to '" + filename + "'...");
        JPEGWriter.toOutput(new JPEGWriter(), tv, new File(filename));
        System.out.println("done!");
    }
}

