/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import weka.core.EnvironmentHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.WekaException;
import weka.filters.StreamableFilter;
import weka.gui.ProgrammaticProperty;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.KFStep;
import weka.knowledgeflow.steps.WekaAlgorithmWrapper;

@KFStep(name="Filter", category="Filters", toolTipText="Weka filter wrapper", iconPath="")
public class Filter
extends WekaAlgorithmWrapper {
    private static final long serialVersionUID = 6857031910153224479L;
    protected weka.filters.Filter m_filterTemplate;
    protected weka.filters.Filter m_streamingFilter;
    protected boolean m_isReset;
    protected boolean m_streaming;
    protected boolean m_stringAttsPresent;
    protected Map<Integer, weka.filters.Filter> m_filterMap = new HashMap<Integer, weka.filters.Filter>();
    protected Map<Integer, Instances> m_waitingTestData = new HashMap<Integer, Instances>();
    protected Data m_incrementalData;
    protected AtomicInteger m_setCount;

    @Override
    public Class getWrappedAlgorithmClass() {
        return weka.filters.Filter.class;
    }

    @Override
    public void setWrappedAlgorithm(Object algo) {
        super.setWrappedAlgorithm(algo);
        this.m_defaultIconPath = "weka/gui/knowledgeflow/icons/DefaultFilter.gif";
        String iconp = algo.getClass().getCanonicalName().replace("weka.", "") + ".gif";
        this.m_iconPath = "weka/gui/knowledgeflow/icons/" + iconp;
    }

    @ProgrammaticProperty
    public void setFilter(weka.filters.Filter filter) {
        this.setWrappedAlgorithm(filter);
    }

    public weka.filters.Filter getFilter() {
        return (weka.filters.Filter)this.getWrappedAlgorithm();
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        ArrayList<String> result = new ArrayList<String>();
        int numDataset = this.getStepManager().numIncomingConnectionsOfType("dataSet");
        int numTraining = this.getStepManager().numIncomingConnectionsOfType("trainingSet");
        int numTesting = this.getStepManager().numIncomingConnectionsOfType("testSet");
        int numInstance = this.getStepManager().numIncomingConnectionsOfType("instance");
        if (numDataset == 0 && numTraining == 0 && numTesting == 0 && this.getFilter() instanceof StreamableFilter) {
            result.add("instance");
        }
        if (numInstance == 0 && numDataset == 0 && numTraining == 0) {
            result.add("dataSet");
            result.add("trainingSet");
        }
        if (numInstance == 0 && numTesting == 0) {
            result.add("testSet");
        }
        return result;
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        ArrayList<String> result = new ArrayList<String>();
        int numDataset = this.getStepManager().numIncomingConnectionsOfType("dataSet");
        int numTraining = this.getStepManager().numIncomingConnectionsOfType("trainingSet");
        int numTesting = this.getStepManager().numIncomingConnectionsOfType("testSet");
        int numInstance = this.getStepManager().numIncomingConnectionsOfType("instance");
        if (numInstance > 0) {
            result.add("instance");
        }
        if (numDataset > 0) {
            result.add("dataSet");
        }
        if (numTraining > 0) {
            result.add("trainingSet");
        }
        if (numTesting > 0) {
            result.add("testSet");
        }
        result.add("info");
        return result;
    }

    @Override
    public void stepInit() throws WekaException {
        if (!(this.getWrappedAlgorithm() instanceof weka.filters.Filter)) {
            throw new WekaException("Incorrect type of algorithm");
        }
        try {
            this.m_filterTemplate = weka.filters.Filter.makeCopy(this.getFilter());
            if (this.m_filterTemplate instanceof EnvironmentHandler) {
                ((EnvironmentHandler)((Object)this.m_filterTemplate)).setEnvironment(this.getStepManager().getExecutionEnvironment().getEnvironmentVariables());
            }
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
        this.m_incrementalData = new Data("instance");
        this.m_filterMap.clear();
        this.m_waitingTestData.clear();
        this.m_streaming = false;
        this.m_stringAttsPresent = false;
        this.m_isReset = true;
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        Instances d2;
        Integer setNum = (Integer)data.getPayloadElement("aux_set_num");
        Integer maxSetNum = (Integer)data.getPayloadElement("aux_max_set_num");
        if (this.m_isReset) {
            this.m_isReset = false;
            this.m_setCount = new AtomicInteger(maxSetNum != null ? maxSetNum : 1);
            this.getStepManager().processing();
            if (data.getConnectionName().equals("instance")) {
                Instances incomingStructure = ((Instance)data.getPayloadElement("instance")).dataset();
                this.m_streaming = true;
                this.getStepManager().logBasic("Initializing streaming filter");
                try {
                    this.m_streamingFilter = weka.filters.Filter.makeCopy(this.m_filterTemplate);
                    this.m_streamingFilter.setInputFormat(incomingStructure);
                    this.m_stringAttsPresent = this.m_streamingFilter.getOutputFormat().checkForStringAttributes();
                }
                catch (Exception ex) {
                    throw new WekaException(ex);
                }
            }
        }
        if (this.m_streaming) {
            if (this.getStepManager().isStreamFinished(data)) {
                this.checkPendingStreaming();
                this.m_incrementalData.clearPayload();
                this.getStepManager().throughputFinished(this.m_incrementalData);
            } else {
                this.processStreaming(data);
            }
        } else if (data.getConnectionName().equals("trainingSet") || data.getConnectionName().equals("dataSet")) {
            d2 = (Instances)data.getPrimaryPayload();
            this.processFirstBatch(d2, data.getConnectionName(), setNum, maxSetNum);
        } else {
            d2 = (Instances)data.getPrimaryPayload();
            if (this.getStepManager().numIncomingConnectionsOfType("trainingSet") == 0 && this.getStepManager().numIncomingConnectionsOfType("dataSet") == 0) {
                this.processFirstBatch(d2, data.getConnectionName(), setNum, maxSetNum);
            } else {
                this.processSubsequentBatch(d2, data.getConnectionName(), setNum, maxSetNum);
            }
        }
        if (this.isStopRequested()) {
            this.getStepManager().interrupted();
        } else if (!this.m_streaming && this.m_setCount.get() == 0) {
            this.getStepManager().finished();
            this.m_waitingTestData.clear();
            this.m_filterMap.clear();
        }
    }

    protected void processFirstBatch(Instances batch, String conType, Integer setNum, Integer maxSetNum) throws WekaException {
        try {
            weka.filters.Filter filterToUse = weka.filters.Filter.makeCopy(this.m_filterTemplate);
            if (!this.isStopRequested()) {
                filterToUse.setInputFormat(batch);
                String message = "Filtering " + conType + " (" + batch.relationName();
                if (setNum != null && maxSetNum != null) {
                    message = message + ", set " + setNum + " of " + maxSetNum;
                }
                message = message + ")";
                this.getStepManager().statusMessage(message);
                this.getStepManager().logBasic(message);
                this.processBatch(batch, conType, filterToUse, setNum, maxSetNum);
                if (setNum != null) {
                    this.m_filterMap.put(setNum, filterToUse);
                } else {
                    this.m_filterMap.put(-1, filterToUse);
                }
                Instances waitingTest = this.m_waitingTestData.get(setNum);
                if (waitingTest != null) {
                    this.processSubsequentBatch(waitingTest, "testSet", setNum, maxSetNum);
                } else if (this.getStepManager().numIncomingConnections() == 1) {
                    this.m_setCount.decrementAndGet();
                }
            }
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
    }

    protected synchronized void processSubsequentBatch(Instances batch, String conType, Integer setNum, Integer maxSetNum) throws WekaException {
        Integer sN = setNum != null ? setNum : -1;
        weka.filters.Filter filterToUse = this.m_filterMap.get(sN);
        if (filterToUse == null) {
            this.m_waitingTestData.put(setNum, batch);
            return;
        }
        if (!this.isStopRequested()) {
            String message = "Filtering " + conType + " (" + batch.relationName();
            if (setNum != null && maxSetNum != null) {
                message = message + ", set " + setNum + " of " + maxSetNum;
            }
            message = message + ") - batch mode";
            this.getStepManager().statusMessage(message);
            this.getStepManager().logBasic(message);
            this.processBatch(batch, conType, filterToUse, setNum, maxSetNum);
        }
        this.m_setCount.decrementAndGet();
    }

    protected void processBatch(Instances batch, String conType, weka.filters.Filter filterToUse, Integer setNum, Integer maxSetNum) throws WekaException {
        try {
            Instances filtered = weka.filters.Filter.useFilter(batch, filterToUse);
            String title = conType + ": " + filtered.relationName();
            Data output = new Data(conType, filtered);
            if (setNum != null && maxSetNum != null) {
                output.setPayloadElement("aux_set_num", setNum);
                output.setPayloadElement("aux_max_set_num", maxSetNum);
                output.setPayloadElement("aux_textTitle", title);
            }
            this.getStepManager().outputData(output);
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
    }

    protected void processStreaming(Data data) throws WekaException {
        Instance toFilter = (Instance)data.getPrimaryPayload();
        this.getStepManager().throughputUpdateStart();
        try {
            if (this.m_streamingFilter.input(toFilter)) {
                Instance filteredI = this.m_streamingFilter.output();
                if (this.m_stringAttsPresent) {
                    for (int i = 0; i < filteredI.numAttributes(); ++i) {
                        if (!filteredI.dataset().attribute(i).isString() || filteredI.isMissing(i)) continue;
                        String val = filteredI.stringValue(i);
                        filteredI.dataset().attribute(i).setStringValue(val);
                        filteredI.setValue(i, 0.0);
                    }
                }
                this.m_incrementalData.setPayloadElement("instance", filteredI);
                if (!this.isStopRequested()) {
                    this.getStepManager().outputData(this.m_incrementalData);
                }
            }
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
        this.getStepManager().throughputUpdateEnd();
    }

    protected void checkPendingStreaming() throws WekaException {
        try {
            this.m_streamingFilter.batchFinished();
            Instances structureCopy = this.m_streamingFilter.getOutputFormat().stringFreeStructure();
            while (this.m_streamingFilter.numPendingOutput() > 0) {
                this.getStepManager().throughputUpdateStart();
                Instance filteredI = this.m_streamingFilter.output();
                if (this.m_stringAttsPresent) {
                    for (int i = 0; i < filteredI.numAttributes(); ++i) {
                        if (!filteredI.attribute(i).isString() || filteredI.isMissing(i)) continue;
                        String val = filteredI.stringValue(i);
                        structureCopy.attribute(i).setStringValue(val);
                        filteredI.setValue(i, 0.0);
                    }
                    filteredI.setDataset(structureCopy);
                }
                this.m_incrementalData.setPayloadElement("instance", filteredI);
                if (!this.isStopRequested()) {
                    this.getStepManager().outputData(this.m_incrementalData);
                }
                this.getStepManager().throughputUpdateEnd();
            }
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
    }

    @Override
    public Instances outputStructureForConnectionType(String connectionName) throws WekaException {
        Instances incomingStructure = null;
        String incomingConType = null;
        if (this.getStepManager().numIncomingConnectionsOfType("trainingSet") > 0) {
            incomingConType = "trainingSet";
        } else if (this.getStepManager().numIncomingConnectionsOfType("testSet") > 0) {
            incomingConType = "testSet";
        } else if (this.getStepManager().numIncomingConnectionsOfType("dataSet") > 0) {
            incomingConType = "dataSet";
        } else if (this.getStepManager().numIncomingConnectionsOfType("instance") > 0) {
            incomingConType = "instance";
        }
        if (incomingConType != null) {
            incomingStructure = this.getStepManager().getIncomingStructureForConnectionType(incomingConType);
        }
        if (incomingStructure != null) {
            try {
                weka.filters.Filter tempFilter = weka.filters.Filter.makeCopy(this.getFilter());
                if (tempFilter.setInputFormat(incomingStructure)) {
                    return tempFilter.getOutputFormat();
                }
            }
            catch (Exception ex) {
                throw new WekaException(ex);
            }
        }
        return null;
    }
}

