/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import weka.core.Attribute;
import weka.core.Environment;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.WekaException;
import weka.gui.ProgrammaticProperty;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.JobEnvironment;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="StorePropertiesInEnvironment", category="Flow", toolTipText="Store property settings for a particular algorithm-based step (eg Classifier, Clusterer etc) in the flow environment. When connected to a downstream Job step, the sub-flow executed by the Job can use a SetPropertiesFromEnvironment step to access the stored properties and set them on the underlying scheme in an algorithm-based step. Each property is configured by specifying the attribute in the incoming instance to obtain its value from, the target scheme-based step (in the sub-flow) that will receive it, the property name/path to set on the target step and a default property value (optional) to use if the value is missing in the incoming instance. If the property/path field is left blank, then it is assumed that the value is actually a scheme + options spec in command-line form; otherwise, the value is set by processing the property path - e.g. if our target step to receive property settings was Bagging (itself with default settings), and the property path to set was 'classifier.maxDepth', then the classifier property of Bagging would yield a REPTree base classifier and the maxDepth property of REPTree would be set. Note that the SetPropertiesFromEnvironment step will process property settings in the order that they are defined by this step. This means that it is possible to set the entire base learner for a Classifier stepwith one property setting and then drill down to a particular option in the base learner using a second property setting.", iconPath="weka/gui/knowledgeflow/icons/StorePropertiesInEnvironment.gif")
public class StorePropertiesInEnvironment
extends BaseStep {
    private static final long serialVersionUID = -1526289154505863542L;
    public static final String SEP1 = "@@vv@@";
    public static final String SEP2 = "@a@a";
    protected Map<String, List<String>> m_propsToSetFromIncomingInstances = new LinkedHashMap<String, List<String>>();
    protected boolean m_structureCheckComplete;
    protected boolean m_structureOK;
    protected String m_internalRep = "";
    protected boolean m_raiseErrorWhenValueMissing;

    @ProgrammaticProperty
    public void setPropsInternalRep(String rep) {
        this.m_internalRep = rep;
    }

    public String getPropsInternalRep() {
        return this.m_internalRep;
    }

    @Override
    public void stepInit() throws WekaException {
        this.m_structureCheckComplete = false;
        this.m_structureOK = false;
        this.m_propsToSetFromIncomingInstances = StorePropertiesInEnvironment.internalDynamicToMap(this.m_internalRep);
        Environment currentEnv = this.getStepManager().getExecutionEnvironment().getEnvironmentVariables();
        if (currentEnv == null) {
            throw new WekaException("The execution environment doesn't seem to have any support for variables");
        }
        if (!(currentEnv instanceof JobEnvironment)) {
            currentEnv = new JobEnvironment(currentEnv);
            this.getStepManager().getExecutionEnvironment().setEnvironmentVariables(currentEnv);
        }
        if (this.getStepManager().numIncomingConnections() > 0 && this.m_propsToSetFromIncomingInstances.size() == 0) {
            this.getStepManager().logWarning("Incoming data detected, but no properties to set from incoming instances have been defined.");
        }
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        if (!this.m_structureCheckComplete) {
            this.m_structureCheckComplete = true;
            Instances structure = null;
            structure = data.getConnectionName().equals("instance") ? ((Instance)data.getPrimaryPayload()).dataset() : (data.getConnectionName().equals("environment") ? ((Instance)data.getPayloadElement("aux_instance")).dataset() : (Instances)data.getPrimaryPayload());
            this.checkStructure(structure);
        }
        this.getStepManager().processing();
        if (data.getConnectionName().equals("instance") || data.getConnectionName().equals("environment")) {
            if (this.isStopRequested()) {
                this.getStepManager().interrupted();
                return;
            }
            if (this.getStepManager().isStreamFinished(data)) {
                Data finished = new Data("environment");
                if (data.getConnectionName().equals("environment")) {
                    finished.setPayloadElement("env_variables", data.getPayloadElement("env_variables"));
                    finished.setPayloadElement("env_properties", data.getPayloadElement("env_properties"));
                }
                this.getStepManager().throughputFinished(finished);
                return;
            }
            Instance toProcess = (Instance)(data.getConnectionName().equals("instance") ? data.getPrimaryPayload() : data.getPayloadElement("aux_instance"));
            this.getStepManager().throughputUpdateStart();
            this.processInstance(toProcess, data.getConnectionName().equals("environment") ? data : null);
            this.getStepManager().throughputUpdateEnd();
        } else {
            Instances insts = (Instances)data.getPrimaryPayload();
            for (int i = 0; i < insts.numInstances() && !this.isStopRequested(); ++i) {
                this.processInstance(insts.instance(i), null);
                Data finished = new Data("environment");
                this.getStepManager().throughputFinished(finished);
            }
            if (this.isStopRequested()) {
                this.getStepManager().interrupted();
            }
        }
    }

    protected void processInstance(Instance inst, Data existingEnv) throws WekaException {
        Map existingProps;
        HashMap<String, Map<String, String>> props = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, List<String>> e2 : this.m_propsToSetFromIncomingInstances.entrySet()) {
            LinkedHashMap<String, String> propsForStep;
            String attName = this.environmentSubstitute(e2.getKey());
            Attribute current = inst.dataset().attribute(attName);
            int index = -1;
            if (current != null) {
                index = current.index();
            } else {
                try {
                    index = Integer.parseInt(attName);
                    --index;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (index == -1) continue;
            String stepName = this.environmentSubstitute(e2.getValue().get(0));
            String propToSet = this.environmentSubstitute(e2.getValue().get(1));
            String val = this.environmentSubstitute(e2.getValue().get(2));
            if (inst.isMissing(index)) {
                if (val.length() == 0 && this.m_raiseErrorWhenValueMissing) {
                    throw new WekaException("Value of attribute '" + inst.attribute(index).name() + "' was missing in current instance and no default value has been specified");
                }
            } else {
                val = inst.stringValue(index);
            }
            if ((propsForStep = (LinkedHashMap<String, String>)props.get(stepName)) == null) {
                propsForStep = new LinkedHashMap<String, String>();
                props.put(stepName, propsForStep);
            }
            propsForStep.put(propToSet, val);
            this.getStepManager().logDebug("Storing property '" + propToSet + "' for step '" + stepName + "' with value '" + val + "'");
        }
        JobEnvironment env = (JobEnvironment)this.getStepManager().getExecutionEnvironment().getEnvironmentVariables();
        env.addToStepProperties(props);
        if (existingEnv != null && (existingProps = (Map)existingEnv.getPayloadElement("env_properties")) != null) {
            props.putAll(existingProps);
        }
        Data output = new Data("environment");
        output.setPayloadElement("env_properties", props);
        if (existingEnv != null) {
            output.setPayloadElement("env_variables", existingEnv.getPayloadElement("env_variables"));
        }
        output.setPayloadElement("aux_instance", inst);
        output.setPayloadElement("incremental_stream", true);
        this.getStepManager().outputData(output);
    }

    protected void checkStructure(Instances structure) {
        ArrayList<String> notFoundInIncoming = new ArrayList<String>();
        for (String attName : this.m_propsToSetFromIncomingInstances.keySet()) {
            if (structure.attribute(attName) == null) {
                notFoundInIncoming.add(attName);
                continue;
            }
            this.m_structureOK = true;
        }
        if (notFoundInIncoming.size() == this.m_propsToSetFromIncomingInstances.size()) {
            this.getStepManager().logWarning("None of the specified attributes appear to be in the incoming instance structure");
            return;
        }
        for (String s : notFoundInIncoming) {
            this.getStepManager().logWarning("Attribute '" + s + "' was not found in the incoming instance structure");
        }
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        if (this.getStepManager().numIncomingConnections() == 0) {
            return Arrays.asList("dataSet", "trainingSet", "testSet", "instance", "environment");
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        if (this.getStepManager().numIncomingConnections() != 0) {
            return Arrays.asList("environment");
        }
        return new ArrayList<String>();
    }

    @Override
    public String getCustomEditorForStep() {
        return "weka.gui.knowledgeflow.steps.StorePropertiesInEnvironmentStepEditorDialog";
    }

    public static Map<String, List<String>> internalDynamicToMap(String internalRep) {
        LinkedHashMap<String, List<String>> propsToSet = new LinkedHashMap<String, List<String>>();
        if (internalRep != null && internalRep.length() > 0) {
            String[] parts;
            for (String p : parts = internalRep.split(SEP1)) {
                String[] attVal = p.split(SEP2);
                if (attVal.length != 4) continue;
                String attName = attVal[0].trim();
                String stepName = attVal[1].trim();
                String propName = attVal[2].trim();
                String defVal = attVal[3].trim();
                if (attName.length() <= 0 || stepName.length() <= 0) continue;
                ArrayList<String> stepAndDefL = new ArrayList<String>();
                stepAndDefL.add(stepName);
                stepAndDefL.add(propName);
                stepAndDefL.add(defVal);
                propsToSet.put(attName, stepAndDefL);
            }
        }
        return propsToSet;
    }
}

