/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.util.VectorUtils;
import org.uma.jmetal.util.errorchecking.Check;

public class GenerationalDistance
extends QualityIndicator {
    private double pow = 2.0;

    public GenerationalDistance() {
    }

    public GenerationalDistance(double[][] referenceFront) {
        super(referenceFront);
    }

    @Override
    public double compute(double[][] front) {
        Check.notNull(front);
        return this.generationalDistance(front, this.referenceFront);
    }

    public double generationalDistance(double[][] front, double[][] referenceFront) {
        double sum = 0.0;
        for (int i = 0; i < front.length; ++i) {
            sum += Math.pow(VectorUtils.distanceToClosestVector(front[i], referenceFront), this.pow);
        }
        sum = Math.pow(sum, 1.0 / this.pow);
        return sum / (double)front.length;
    }

    @Override
    public String name() {
        return "GD";
    }

    @Override
    public String description() {
        return "Generational distance quality indicator";
    }

    @Override
    public boolean isTheLowerTheIndicatorValueTheBetter() {
        return true;
    }
}

