/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.densityestimator.impl;

import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.NormalizeUtils;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.comparator.ObjectiveComparator;
import org.uma.jmetal.util.densityestimator.DensityEstimator;
import org.uma.jmetal.util.distance.Distance;
import org.uma.jmetal.util.distance.impl.CosineSimilarityBetweenVectors;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.point.Point;

public class CosineSimilarityDensityEstimator<S extends Solution<?>>
implements DensityEstimator<S> {
    private final String attributeId = this.getClass().getName();
    private Distance<double[], double[]> distance;
    private Point referencePoint;
    private boolean normalize;

    public CosineSimilarityDensityEstimator(Point referencePoint) {
        this(referencePoint, true);
    }

    public CosineSimilarityDensityEstimator(Point referencePoint, boolean normalize) {
        this.referencePoint = referencePoint;
        this.distance = new CosineSimilarityBetweenVectors(referencePoint.values());
        this.normalize = normalize;
    }

    @Override
    public void compute(List<S> solutionList) {
        int i;
        int numberOfObjectives;
        int size = solutionList.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            ((Solution)solutionList.get(0)).attributes().put(this.attributeId, 0.0);
        }
        if (size == (numberOfObjectives = ((Solution)solutionList.get(0)).objectives().length)) {
            for (Solution solution : solutionList) {
                solution.attributes().put(this.attributeId, 0.0);
            }
            return;
        }
        for (Solution solution : solutionList) {
            this.referencePoint.update(solution.objectives());
        }
        double[][] distanceMatrix = new double[solutionList.size()][solutionList.size()];
        double[][] solutionMatrix = null;
        if (this.normalize) {
            try {
                solutionMatrix = NormalizeUtils.normalize(SolutionListUtils.getMatrixWithObjectiveValues(solutionList));
            }
            catch (JMetalException e) {
                e.printStackTrace();
            }
        } else {
            solutionMatrix = SolutionListUtils.getMatrixWithObjectiveValues(solutionList);
        }
        for (i = 0; i < solutionList.size(); ++i) {
            for (int j = i + 1; j < solutionList.size(); ++j) {
                distanceMatrix[i][j] = this.distance.compute(solutionMatrix[i], solutionMatrix[j]);
                distanceMatrix[j][i] = distanceMatrix[i][j];
            }
        }
        for (i = 0; i < solutionList.size(); ++i) {
            double currentMaximumDistance = 0.0;
            double secondCurrentMaximumDistance = 0.0;
            for (int j = 0; j < solutionList.size(); ++j) {
                if (i == j) continue;
                double d = distanceMatrix[i][j];
                if (d >= currentMaximumDistance) {
                    secondCurrentMaximumDistance = currentMaximumDistance;
                    currentMaximumDistance = d;
                    continue;
                }
                if (!(d > secondCurrentMaximumDistance)) continue;
                secondCurrentMaximumDistance = d;
            }
            ((Solution)solutionList.get(i)).attributes().put(this.attributeId, currentMaximumDistance + secondCurrentMaximumDistance);
            ((Solution)solutionList.get(i)).attributes().put("DIFF", Math.abs(currentMaximumDistance - secondCurrentMaximumDistance));
        }
        for (i = 0; i < ((Solution)solutionList.get(0)).objectives().length; ++i) {
            solutionList.sort(new ObjectiveComparator(i));
            ((Solution)solutionList.get(solutionList.size() - 1)).attributes().put(this.attributeId, 0.0);
        }
    }

    @Override
    public Double value(S solution) {
        Check.notNull(solution);
        Double result = 0.0;
        if (solution.attributes().get(this.attributeId) != null) {
            result = (Double)solution.attributes().get(this.attributeId);
        }
        return result;
    }

    @Override
    public Comparator<S> comparator() {
        return Comparator.comparing(this::value);
    }
}

