/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.observer.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.knowm.xchart.XYChart;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.NormalizeUtils;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.VectorUtils;
import org.uma.jmetal.util.observable.Observable;
import org.uma.jmetal.util.observer.Observer;
import org.uma.jmetal.util.plot.SingleValueScatterPlot;

public class IndicatorPlotObserver<S extends Solution<?>>
implements Observer<Map<String, Object>> {
    private final SingleValueScatterPlot chart;
    private Integer evaluations;
    private final int plotUpdateFrequency;
    double[][] referenceFront;
    double[][] normalizedReferenceFront;
    private QualityIndicator qualityIndicator;
    private String plotTitle;

    public IndicatorPlotObserver(String title, QualityIndicator qualityIndicator, String referenceFrontFileName, int plotUpdateFrequency) throws IOException {
        this.chart = new SingleValueScatterPlot(title, "Evaluations", qualityIndicator.name(), qualityIndicator.name());
        this.chart.delay(200L);
        this.plotUpdateFrequency = plotUpdateFrequency;
        this.qualityIndicator = qualityIndicator;
        this.plotTitle = title;
        this.referenceFront = VectorUtils.readVectors(referenceFrontFileName, ",");
        this.normalizedReferenceFront = NormalizeUtils.normalize(this.referenceFront);
        qualityIndicator.referenceFront(this.normalizedReferenceFront);
    }

    @Override
    public void update(Observable<Map<String, Object>> observable, Map<String, Object> data) {
        this.evaluations = (Integer)data.get("EVALUATIONS");
        List population = (List)data.get("POPULATION");
        if (this.evaluations != null && population != null) {
            if (this.evaluations % this.plotUpdateFrequency == 0) {
                double[][] normalizedFront = NormalizeUtils.normalize(SolutionListUtils.getMatrixWithObjectiveValues(population), NormalizeUtils.getMinValuesOfTheColumnsOfAMatrix(this.referenceFront), NormalizeUtils.getMaxValuesOfTheColumnsOfAMatrix(this.referenceFront));
                double indicatorValue = this.qualityIndicator.compute(normalizedFront);
                this.chart.updateChart(this.evaluations.intValue(), indicatorValue);
                String plotTitle = this.plotTitle + ". " + this.qualityIndicator.name() + ": " + String.format("%.5e", indicatorValue);
                this.chart.chartTitle(plotTitle);
            }
        } else {
            JMetalLogger.logger.warning(this.getClass().getName() + " : insufficient for generating real time information. Either EVALUATIONS or POPULATION keys have not been registered yet by the algorithm");
        }
    }

    public XYChart chart() {
        return this.chart.chart();
    }
}

