/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.plot;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.markers.SeriesMarkers;

public class FrontScatterPlot {
    private final XYChart chart;
    private SwingWrapper<XYChart> swingWrapper;
    private final String legend;
    private boolean firstUpdate = true;
    private long delay = 500L;

    public FrontScatterPlot(String title, String xAxisTitle, String yAxisTitle, String legend) {
        this.chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(800)).height(600)).title(title)).xAxisTitle(xAxisTitle).yAxisTitle(yAxisTitle).build();
        this.legend = legend;
        ((XYStyler)this.chart.getStyler()).setLegendPosition(Styler.LegendPosition.OutsideE);
        ((XYStyler)this.chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Scatter);
        ((XYStyler)this.chart.getStyler()).setMarkerSize(6);
        ((XYStyler)this.chart.getStyler()).setShowWithinAreaPoint(true);
        ((XYStyler)this.chart.getStyler()).setCursorEnabled(true);
    }

    private double[] objectiveValues(double[][] data, int obj) {
        return Arrays.stream(data).mapToDouble(v -> v[obj]).toArray();
    }

    public void delay(long delay) {
        this.delay = delay;
    }

    public void setFront(double[][] front, String frontName) {
        double[] x = this.objectiveValues(front, 0);
        double[] y = this.objectiveValues(front, 1);
        XYSeries series = this.chart.addSeries(frontName, x, y);
        series.setMarkerColor(Color.blue);
        series.setMarker(SeriesMarkers.CIRCLE);
    }

    public void addPoint(double x, double y, String pointName) {
        XYSeries pointSeries = this.chart.addSeries(pointName, new double[]{x}, new double[]{y});
        pointSeries.setMarker(SeriesMarkers.DIAMOND);
        pointSeries.setXYSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Line);
    }

    public void chartTitle(String newTitle) {
        this.chart.setTitle(newTitle);
    }

    public void addPoint(double x, double y, String pointName, Color color) {
        XYSeries pointSeries = this.chart.addSeries(pointName, new double[]{x}, new double[]{y});
        pointSeries.setMarker(SeriesMarkers.CIRCLE);
        pointSeries.setMarkerColor(color);
    }

    public void updatePoint(double x, double y, String pointName) {
        this.chart.updateXYSeries(pointName, new double[]{x}, new double[]{y}, null);
    }

    public void updateChart(double[] x, double[] y) {
        this.updateChart(Arrays.stream(x).boxed().collect(Collectors.toList()), Arrays.stream(y).boxed().collect(Collectors.toList()));
    }

    public void updateChart(List<Double> x, List<Double> y) {
        if (this.firstUpdate) {
            this.swingWrapper = new SwingWrapper((Chart)this.chart);
            this.swingWrapper.displayChart();
            this.firstUpdate = false;
            XYSeries series = this.chart.addSeries(this.legend, x, y);
            series.setMarkerColor(Color.BLACK);
            series.setMarker(SeriesMarkers.CIRCLE);
        } else {
            try {
                TimeUnit.MILLISECONDS.sleep(this.delay);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.chart.updateXYSeries(this.legend, x, y, null);
            this.swingWrapper.repaintChart();
        }
    }

    public XYChart chart() {
        return this.chart;
    }
}

